/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.navigation;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum UtcId {
    USNO("UTC(USNO)"),
    SU("UTC(SU)"),
    GAL("UTCGAL"),
    NTSC("UTC(NTSC)"),
    NICT("UTC(NICT)"),
    IRN("UTCIRN", "UTC(NPLI)"),
    OP("UTC(OP)"),
    NIST("UTC(NIST)");

    private static final Map<String, UtcId> MAP;
    private final String[] ids;

    private UtcId(String ... ids) {
        this.ids = (String[])ids.clone();
    }

    public static UtcId parseUtcId(String id) throws OrekitIllegalArgumentException {
        UtcId utcId = MAP.get(id);
        if (utcId == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_UTC_ID, id);
        }
        return utcId;
    }

    static {
        MAP = new HashMap<String, UtcId>();
        for (UtcId utc : UtcId.values()) {
            for (String id : utc.ids) {
                MAP.put(id, utc);
            }
        }
    }
}

