/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.navigation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.InputMismatchException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.rinex.navigation.EarthOrientationParameterMessage;
import org.orekit.files.rinex.navigation.IonosphereBDGIMMessage;
import org.orekit.files.rinex.navigation.IonosphereKlobucharMessage;
import org.orekit.files.rinex.navigation.IonosphereNequickGMessage;
import org.orekit.files.rinex.navigation.IonosphericCorrectionType;
import org.orekit.files.rinex.navigation.RegionCode;
import org.orekit.files.rinex.navigation.RinexNavigation;
import org.orekit.files.rinex.navigation.RinexNavigationHeader;
import org.orekit.files.rinex.navigation.SbasId;
import org.orekit.files.rinex.navigation.SystemTimeOffsetMessage;
import org.orekit.files.rinex.navigation.TimeSystemCorrection;
import org.orekit.files.rinex.navigation.UtcId;
import org.orekit.files.rinex.utils.parsing.RinexUtils;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.TimeSystem;
import org.orekit.propagation.analytical.gnss.data.AbstractNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.BeidouCivilianNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.BeidouLegacyNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.BeidouSatelliteType;
import org.orekit.propagation.analytical.gnss.data.GLONASSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GPSCivilianNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GPSLegacyNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GalileoNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.IRNSSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.QZSSCivilianNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.QZSSLegacyNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.SBASNavigationMessage;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.utils.units.Unit;

public class RinexNavigationParser {
    private static final Unit KM = Unit.KILOMETRE;
    private static final Unit KM_PER_S = Unit.parse("km/s");
    private static final Unit KM_PER_S2 = Unit.parse("km/s\u00b2");
    private static final Unit M_PER_S = Unit.parse("m/s");
    private static final Unit S_PER_S = Unit.parse("s/s");
    private static final Unit S_PER_S2 = Unit.parse("s/s\u00b2");
    private static final Unit S_PER_DAY = Unit.parse("s/d");
    private static final Unit S_PER_DAY2 = Unit.parse("s/d\u00b2");
    private static final Unit SQRT_M = Unit.parse("\u221am");
    private static final Unit RAD_PER_S = Unit.parse("rad/s");
    private static final Unit RAD_PER_S2 = Unit.parse("rad/s\u00b2");
    private static final Unit AS_PER_DAY = Unit.parse("as/d");
    private static final Unit AS_PER_DAY2 = Unit.parse("as/d\u00b2");
    private static final String INITIALS = "GRECIJS";
    private final TimeScales timeScales;

    @DefaultDataContext
    public RinexNavigationParser() {
        this(DataContext.getDefault().getTimeScales());
    }

    public RinexNavigationParser(TimeScales timeScales) {
        this.timeScales = timeScales;
    }

    public RinexNavigation parse(DataSource source) throws IOException {
        ParseInfo pi = new ParseInfo(source.getName());
        Iterable<LineParser> candidateParsers = Collections.singleton(LineParser.HEADER_VERSION);
        try (Reader reader = source.getOpener().openReaderOnce();
             BufferedReader br = new BufferedReader(reader);){
            String line = br.readLine();
            while (line != null) {
                block16: {
                    ++pi.lineNumber;
                    for (LineParser candidate : candidateParsers) {
                        if (!candidate.canHandle.test(line)) continue;
                        try {
                            candidate.parsingMethod.parse(line, pi);
                            candidateParsers = (Iterable)candidate.allowedNextProvider.apply(pi);
                            break block16;
                        }
                        catch (NumberFormatException | StringIndexOutOfBoundsException | InputMismatchException e) {
                            throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, source.getName(), line);
                        }
                    }
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, source.getName(), line);
                }
                line = br.readLine();
            }
        }
        if (!pi.headerParsed) {
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE, source.getName());
        }
        pi.closePendingMessage();
        return pi.file;
    }

    @FunctionalInterface
    private static interface ParsingMethod {
        public void parse(String var1, ParseInfo var2);
    }

    private static enum SatelliteSystemLineParser {
        GPS_LNAV{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                if (((RinexNavigationHeader)pi.file.getHeader()).getFormatVersion() < 3.0) {
                    this.parseSvEpochSvClockLineRinex2(line, pi.timeScales.getGPS(), pi.gpsLNav);
                } else {
                    this.parseSvEpochSvClockLine(line, pi.timeScales.getGPS(), pi.gpsLNav);
                }
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setIODE(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsLNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.gpsLNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.gpsLNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsLNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.gpsLNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsLNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsLNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsLNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsLNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsLNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.gpsLNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsLNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.gpsLNav.setWeek((int)RinexUtils.parseDouble(line, 42, 19));
                pi.gpsLNav.setDate(new GNSSDate(pi.gpsLNav.getWeek(), pi.gpsLNav.getTime(), SatelliteSystem.GPS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setSvAccuracy(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.METRE));
                pi.gpsLNav.setSvHealth(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.gpsLNav.setTGD(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsLNav.setIODC(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsLNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsLNav.setFitInterval(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addGPSLegacyNavigationMessage(pi.gpsLNav);
                pi.gpsLNav = null;
            }
        }
        ,
        GPS_CNAV{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getGPS(), pi.gpsCNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setADot(this.parseBroadcastDouble1(line, pi.initialSpaces, M_PER_S));
                pi.gpsCNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.gpsCNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.gpsCNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsCNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.gpsCNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsCNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsCNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsCNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsCNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsCNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.gpsCNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.gpsCNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.gpsCNav.setDeltaN0Dot(this.parseBroadcastDouble2(line, pi.initialSpaces, RAD_PER_S2));
                pi.gpsCNav.setUraiNed0(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.gpsCNav.setUraiNed1(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setUraiEd(this.parseBroadcastInt1(line, pi.initialSpaces));
                pi.gpsCNav.setSvHealth(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.gpsCNav.setTGD(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsCNav.setUraiNed2(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.gpsCNav.setIscL1CA(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsCNav.setIscL2C(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsCNav.setIscL5I5(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.gpsCNav.setIscL5Q5(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
            }

            @Override
            public void parseEighthBroadcastOrbit(String line, ParseInfo pi) {
                if (pi.gpsCNav.isCnv2()) {
                    pi.gpsCNav.setIscL1CD(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                    pi.gpsCNav.setIscL1CP(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                } else {
                    this.parseTransmissionTimeLine(line, pi);
                }
            }

            @Override
            public void parseNinthBroadcastOrbit(String line, ParseInfo pi) {
                this.parseTransmissionTimeLine(line, pi);
            }

            private void parseTransmissionTimeLine(String line, ParseInfo pi) {
                pi.gpsCNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addGPSLegacyNavigationMessage(pi.gpsCNav);
                pi.gpsCNav = null;
            }
        }
        ,
        GALILEO{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getGPS(), pi.galileoNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setIODNav(this.parseBroadcastInt1(line, pi.initialSpaces));
                pi.galileoNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.galileoNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.galileoNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.galileoNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.galileoNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.galileoNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.galileoNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.galileoNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.galileoNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.galileoNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.galileoNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.galileoNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.galileoNav.setDataSource(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.galileoNav.setWeek(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.galileoNav.setDate(new GNSSDate(pi.galileoNav.getWeek(), pi.galileoNav.getTime(), SatelliteSystem.GPS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setSisa(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.METRE));
                pi.galileoNav.setSvHealth(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.galileoNav.setBGDE1E5a(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.galileoNav.setBGDE5bE1(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.galileoNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addGalileoNavigationMessage(pi.galileoNav);
                pi.galileoNav = null;
            }
        }
        ,
        GLONASS{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                if (((RinexNavigationHeader)pi.file.getHeader()).getFormatVersion() < 3.0) {
                    pi.glonassNav.setPRN(RinexUtils.parseInt(line, 0, 2));
                    int year = RinexUtils.convert2DigitsYear(RinexUtils.parseInt(line, 3, 2));
                    int month = RinexUtils.parseInt(line, 6, 2);
                    int day = RinexUtils.parseInt(line, 9, 2);
                    int hours = RinexUtils.parseInt(line, 12, 2);
                    int min = RinexUtils.parseInt(line, 15, 2);
                    double sec = RinexUtils.parseDouble(line, 17, 5);
                    pi.glonassNav.setEpochToc(new AbsoluteDate(year, month, day, hours, min, sec, (TimeScale)pi.timeScales.getUTC()));
                    pi.glonassNav.setTauN(-RinexUtils.parseDouble(line, 22, 19));
                    pi.glonassNav.setGammaN(RinexUtils.parseDouble(line, 41, 19));
                    pi.glonassNav.setTime(SatelliteSystemLineParser.fmod(RinexUtils.parseDouble(line, 60, 19), 86400.0));
                    pi.glonassNav.setDate(pi.glonassNav.getEpochToc());
                } else {
                    pi.glonassNav.setPRN(RinexUtils.parseInt(line, 1, 2));
                    pi.glonassNav.setEpochToc(this.parsePrnSvEpochClock(line, pi.timeScales.getUTC()));
                    pi.glonassNav.setTauN(-RinexUtils.parseDouble(line, 23, 19));
                    pi.glonassNav.setGammaN(RinexUtils.parseDouble(line, 42, 19));
                    pi.glonassNav.setTime(SatelliteSystemLineParser.fmod(RinexUtils.parseDouble(line, 61, 19), 86400.0));
                    pi.glonassNav.setDate(pi.glonassNav.getEpochToc());
                }
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setX(this.parseBroadcastDouble1(line, pi.initialSpaces, KM));
                pi.glonassNav.setXDot(this.parseBroadcastDouble2(line, pi.initialSpaces, KM_PER_S));
                pi.glonassNav.setXDotDot(this.parseBroadcastDouble3(line, pi.initialSpaces, KM_PER_S2));
                pi.glonassNav.setHealth(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.NONE));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setY(this.parseBroadcastDouble1(line, pi.initialSpaces, KM));
                pi.glonassNav.setYDot(this.parseBroadcastDouble2(line, pi.initialSpaces, KM_PER_S));
                pi.glonassNav.setYDotDot(this.parseBroadcastDouble3(line, pi.initialSpaces, KM_PER_S2));
                pi.glonassNav.setFrequencyNumber(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.NONE));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setZ(this.parseBroadcastDouble1(line, pi.initialSpaces, KM));
                pi.glonassNav.setZDot(this.parseBroadcastDouble2(line, pi.initialSpaces, KM_PER_S));
                pi.glonassNav.setZDotDot(this.parseBroadcastDouble3(line, pi.initialSpaces, KM_PER_S2));
                if (((RinexNavigationHeader)pi.file.getHeader()).getFormatVersion() < 3.045) {
                    pi.closePendingMessage();
                }
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.glonassNav.setStatusFlags(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.NONE));
                pi.glonassNav.setGroupDelayDifference(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.glonassNav.setURA(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.NONE));
                pi.glonassNav.setHealthFlags(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.NONE));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addGlonassNavigationMessage(pi.glonassNav);
                pi.glonassNav = null;
            }
        }
        ,
        QZSS_LNAV{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getGPS(), pi.qzssLNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setIODE(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssLNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.qzssLNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.qzssLNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssLNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.qzssLNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssLNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssLNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssLNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssLNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssLNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.qzssLNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssLNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.qzssLNav.setWeek(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.qzssLNav.setDate(new GNSSDate(pi.qzssLNav.getWeek(), pi.qzssLNav.getTime(), SatelliteSystem.GPS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setSvAccuracy(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.METRE));
                pi.qzssLNav.setSvHealth(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.qzssLNav.setTGD(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssLNav.setIODC(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssLNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssLNav.setFitInterval(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addQZSSLegacyNavigationMessage(pi.qzssLNav);
                pi.qzssLNav = null;
            }
        }
        ,
        QZSS_CNAV{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getGPS(), pi.qzssCNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setADot(this.parseBroadcastDouble1(line, pi.initialSpaces, M_PER_S));
                pi.qzssCNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.qzssCNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.qzssCNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssCNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.qzssCNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssCNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssCNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssCNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssCNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssCNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.qzssCNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.qzssCNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.qzssCNav.setDeltaN0Dot(this.parseBroadcastDouble2(line, pi.initialSpaces, RAD_PER_S2));
                pi.qzssCNav.setUraiNed0(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.qzssCNav.setUraiNed1(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setUraiEd(this.parseBroadcastInt1(line, pi.initialSpaces));
                pi.qzssCNav.setSvHealth(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.qzssCNav.setTGD(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssCNav.setUraiNed2(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.qzssCNav.setIscL1CA(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssCNav.setIscL2C(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssCNav.setIscL5I5(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.qzssCNav.setIscL5Q5(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
            }

            @Override
            public void parseEighthBroadcastOrbit(String line, ParseInfo pi) {
                if (pi.qzssCNav.isCnv2()) {
                    pi.qzssCNav.setIscL1CD(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                    pi.qzssCNav.setIscL1CP(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                } else {
                    this.parseTransmissionTimeLine(line, pi);
                }
            }

            @Override
            public void parseNinthBroadcastOrbit(String line, ParseInfo pi) {
                this.parseTransmissionTimeLine(line, pi);
            }

            private void parseTransmissionTimeLine(String line, ParseInfo pi) {
                pi.qzssCNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addQZSSCivilianNavigationMessage(pi.qzssCNav);
                pi.qzssCNav = null;
            }
        }
        ,
        BEIDOU_D1_D2{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getBDT(), pi.beidouLNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setAODE(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.beidouLNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.beidouLNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.beidouLNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouLNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.beidouLNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouLNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.beidouLNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouLNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouLNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouLNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.beidouLNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouLNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.beidouLNav.setWeek(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.beidouLNav.setDate(new GNSSDate(pi.beidouLNav.getWeek(), pi.beidouLNav.getTime(), SatelliteSystem.BEIDOU, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setSvAccuracy(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.METRE));
                pi.beidouLNav.setTGD1(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                pi.beidouLNav.setTGD2(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouLNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.beidouLNav.setAODC(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addBeidouLegacyNavigationMessage(pi.beidouLNav);
                pi.beidouLNav = null;
            }
        }
        ,
        BEIDOU_CNV_123{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getBDT(), pi.beidouCNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setADot(this.parseBroadcastDouble1(line, pi.initialSpaces, M_PER_S));
                pi.beidouCNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.beidouCNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.beidouCNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouCNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.beidouCNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouCNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.beidouCNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouCNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouCNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouCNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.beidouCNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.beidouCNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.beidouCNav.setDeltaN0Dot(this.parseBroadcastDouble2(line, pi.initialSpaces, RAD_PER_S2));
                switch (this.parseBroadcastInt3(line, pi.initialSpaces)) {
                    case 0: {
                        pi.beidouCNav.setSatelliteType(BeidouSatelliteType.RESERVED);
                        break;
                    }
                    case 1: {
                        pi.beidouCNav.setSatelliteType(BeidouSatelliteType.GEO);
                        break;
                    }
                    case 2: {
                        pi.beidouCNav.setSatelliteType(BeidouSatelliteType.IGSO);
                        break;
                    }
                    case 3: {
                        pi.beidouCNav.setSatelliteType(BeidouSatelliteType.MEO);
                        break;
                    }
                    default: {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, pi.name, line);
                    }
                }
                pi.beidouCNav.setTime(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setSisaiOe(this.parseBroadcastInt1(line, pi.initialSpaces));
                pi.beidouCNav.setSisaiOcb(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.beidouCNav.setSisaiOc1(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.beidouCNav.setSisaiOc2(this.parseBroadcastInt4(line, pi.initialSpaces));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                if (pi.beidouCNav.getSignal() == Frequency.B1C) {
                    pi.beidouCNav.setIscB1CD(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                    pi.beidouCNav.setTgdB1Cp(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                    pi.beidouCNav.setTgdB2ap(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
                } else if (pi.beidouCNav.getSignal() == Frequency.B2A) {
                    pi.beidouCNav.setIscB2AD(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                    pi.beidouCNav.setTgdB1Cp(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
                    pi.beidouCNav.setTgdB2ap(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
                } else {
                    this.parseSismaiHealthIntegrity(line, pi);
                }
            }

            @Override
            public void parseEighthBroadcastOrbit(String line, ParseInfo pi) {
                if (pi.beidouCNav.getSignal() == Frequency.B2B) {
                    pi.beidouCNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                    pi.closePendingMessage();
                } else {
                    this.parseSismaiHealthIntegrity(line, pi);
                }
            }

            @Override
            public void parseNinthBroadcastOrbit(String line, ParseInfo pi) {
                pi.beidouCNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.beidouCNav.setIODE(this.parseBroadcastInt4(line, pi.initialSpaces));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addBeidouCivilianNavigationMessage(pi.beidouCNav);
                pi.beidouCNav = null;
            }

            private void parseSismaiHealthIntegrity(String line, ParseInfo pi) {
                pi.beidouCNav.setSismai(this.parseBroadcastInt1(line, pi.initialSpaces));
                pi.beidouCNav.setHealth(this.parseBroadcastInt2(line, pi.initialSpaces));
                pi.beidouCNav.setIntegrityFlags(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.beidouCNav.setIODC(this.parseBroadcastInt4(line, pi.initialSpaces));
            }
        }
        ,
        SBAS{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                pi.sbasNav.setPRN(RinexUtils.parseInt(line, 1, 2));
                int version100 = (int)FastMath.rint((double)(((RinexNavigationHeader)pi.file.getHeader()).getFormatVersion() * 100.0));
                TimeScale timeScale = version100 == 301 ? pi.timeScales.getUTC() : pi.timeScales.getGPS();
                pi.sbasNav.setEpochToc(this.parsePrnSvEpochClock(line, timeScale));
                pi.sbasNav.setAGf0(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.SECOND));
                pi.sbasNav.setAGf1(this.parseBroadcastDouble3(line, pi.initialSpaces, S_PER_S));
                pi.sbasNav.setTime(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.SECOND));
                pi.sbasNav.setDate(pi.sbasNav.getEpochToc());
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.sbasNav.setX(this.parseBroadcastDouble1(line, pi.initialSpaces, KM));
                pi.sbasNav.setXDot(this.parseBroadcastDouble2(line, pi.initialSpaces, KM_PER_S));
                pi.sbasNav.setXDotDot(this.parseBroadcastDouble3(line, pi.initialSpaces, KM_PER_S2));
                pi.sbasNav.setHealth(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.NONE));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.sbasNav.setY(this.parseBroadcastDouble1(line, pi.initialSpaces, KM));
                pi.sbasNav.setYDot(this.parseBroadcastDouble2(line, pi.initialSpaces, KM_PER_S));
                pi.sbasNav.setYDotDot(this.parseBroadcastDouble3(line, pi.initialSpaces, KM_PER_S2));
                pi.sbasNav.setURA(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.NONE));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.sbasNav.setZ(this.parseBroadcastDouble1(line, pi.initialSpaces, KM));
                pi.sbasNav.setZDot(this.parseBroadcastDouble2(line, pi.initialSpaces, KM_PER_S));
                pi.sbasNav.setZDotDot(this.parseBroadcastDouble3(line, pi.initialSpaces, KM_PER_S2));
                pi.sbasNav.setIODN(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.NONE));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addSBASNavigationMessage(pi.sbasNav);
                pi.sbasNav = null;
            }
        }
        ,
        IRNSS{

            @Override
            public void parseSvEpochSvClockLine(String line, ParseInfo pi) {
                this.parseSvEpochSvClockLine(line, pi.timeScales.getIRNSS(), pi.irnssNav);
            }

            @Override
            public void parseFirstBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setIODEC(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.irnssNav.setCrs(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.irnssNav.setDeltaN(this.parseBroadcastDouble3(line, pi.initialSpaces, RAD_PER_S));
                pi.irnssNav.setM0(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseSecondBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setCuc(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.irnssNav.setE(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.irnssNav.setCus(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.irnssNav.setSqrtA(this.parseBroadcastDouble4(line, pi.initialSpaces, SQRT_M));
            }

            @Override
            public void parseThirdBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.irnssNav.setCic(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.RADIAN));
                pi.irnssNav.setOmega0(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.irnssNav.setCis(this.parseBroadcastDouble4(line, pi.initialSpaces, Unit.RADIAN));
            }

            @Override
            public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setI0(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.RADIAN));
                pi.irnssNav.setCrc(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.METRE));
                pi.irnssNav.setPa(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.RADIAN));
                pi.irnssNav.setOmegaDot(this.parseBroadcastDouble4(line, pi.initialSpaces, RAD_PER_S));
            }

            @Override
            public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setIDot(this.parseBroadcastDouble1(line, pi.initialSpaces, RAD_PER_S));
                pi.irnssNav.setWeek(this.parseBroadcastInt3(line, pi.initialSpaces));
                pi.irnssNav.setDate(new GNSSDate(pi.irnssNav.getWeek(), pi.irnssNav.getTime(), SatelliteSystem.GPS, pi.timeScales).getDate());
            }

            @Override
            public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setURA(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.METRE));
                pi.irnssNav.setSvHealth(this.parseBroadcastDouble2(line, pi.initialSpaces, Unit.NONE));
                pi.irnssNav.setTGD(this.parseBroadcastDouble3(line, pi.initialSpaces, Unit.SECOND));
            }

            @Override
            public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
                pi.irnssNav.setTransmissionTime(this.parseBroadcastDouble1(line, pi.initialSpaces, Unit.SECOND));
                pi.closePendingMessage();
            }

            @Override
            public void closeMessage(ParseInfo pi) {
                pi.file.addIRNSSNavigationMessage(pi.irnssNav);
                pi.irnssNav = null;
            }
        };


        private static SatelliteSystemLineParser getParser(SatelliteSystem system, String type, ParseInfo parseInfo, String line) {
            switch (system) {
                case GPS: {
                    if (type == null || type.equals("LNAV")) {
                        parseInfo.gpsLNav = new GPSLegacyNavigationMessage();
                        return GPS_LNAV;
                    }
                    if (type.equals("CNAV")) {
                        parseInfo.gpsCNav = new GPSCivilianNavigationMessage(false);
                        return GPS_CNAV;
                    }
                    if (!type.equals("CNV2")) break;
                    parseInfo.gpsCNav = new GPSCivilianNavigationMessage(true);
                    return GPS_CNAV;
                }
                case GALILEO: {
                    if (type != null && !type.equals("INAV") && !type.equals("FNAV")) break;
                    parseInfo.galileoNav = new GalileoNavigationMessage();
                    return GALILEO;
                }
                case GLONASS: {
                    if (type != null && !type.equals("FDMA")) break;
                    parseInfo.glonassNav = new GLONASSNavigationMessage();
                    return GLONASS;
                }
                case QZSS: {
                    if (type == null || type.equals("LNAV")) {
                        parseInfo.qzssLNav = new QZSSLegacyNavigationMessage();
                        return QZSS_LNAV;
                    }
                    if (type.equals("CNAV")) {
                        parseInfo.qzssCNav = new QZSSCivilianNavigationMessage(false);
                        return QZSS_CNAV;
                    }
                    if (!type.equals("CNV2")) break;
                    parseInfo.qzssCNav = new QZSSCivilianNavigationMessage(true);
                    return QZSS_CNAV;
                }
                case BEIDOU: {
                    if (type == null || type.equals("D1") || type.equals("D2")) {
                        parseInfo.beidouLNav = new BeidouLegacyNavigationMessage();
                        return BEIDOU_D1_D2;
                    }
                    if (type.equals("CNV1")) {
                        parseInfo.beidouCNav = new BeidouCivilianNavigationMessage(Frequency.B1C);
                        return BEIDOU_CNV_123;
                    }
                    if (type.equals("CNV2")) {
                        parseInfo.beidouCNav = new BeidouCivilianNavigationMessage(Frequency.B2A);
                        return BEIDOU_CNV_123;
                    }
                    if (!type.equals("CNV3")) break;
                    parseInfo.beidouCNav = new BeidouCivilianNavigationMessage(Frequency.B2B);
                    return BEIDOU_CNV_123;
                }
                case IRNSS: {
                    if (type != null && !type.equals("LNAV")) break;
                    parseInfo.irnssNav = new IRNSSNavigationMessage();
                    return IRNSS;
                }
                case SBAS: {
                    if (type != null && !type.equals("SBAS")) break;
                    parseInfo.sbasNav = new SBASNavigationMessage();
                    return SBAS;
                }
            }
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, parseInfo.lineNumber, parseInfo.name, line);
        }

        protected void parseSvEpochSvClockLineRinex2(String line, TimeScale timeScale, AbstractNavigationMessage message) {
            message.setPRN(RinexUtils.parseInt(line, 0, 2));
            int year = RinexUtils.convert2DigitsYear(RinexUtils.parseInt(line, 2, 3));
            int month = RinexUtils.parseInt(line, 5, 3);
            int day = RinexUtils.parseInt(line, 8, 3);
            int hours = RinexUtils.parseInt(line, 11, 3);
            int min = RinexUtils.parseInt(line, 14, 3);
            double sec = RinexUtils.parseDouble(line, 17, 5);
            message.setEpochToc(new AbsoluteDate(year, month, day, hours, min, sec, timeScale));
            message.setAf0(RinexUtils.parseDouble(line, 22, 19));
            message.setAf1(RinexUtils.parseDouble(line, 41, 19));
            message.setAf2(RinexUtils.parseDouble(line, 60, 19));
        }

        protected void parseSvEpochSvClockLine(String line, TimeScale timeScale, AbstractNavigationMessage message) {
            message.setPRN(RinexUtils.parseInt(line, 1, 2));
            message.setEpochToc(this.parsePrnSvEpochClock(line, timeScale));
            message.setAf0(RinexUtils.parseDouble(line, 23, 19));
            message.setAf1(RinexUtils.parseDouble(line, 42, 19));
            message.setAf2(RinexUtils.parseDouble(line, 61, 19));
        }

        protected AbsoluteDate parsePrnSvEpochClock(String line, TimeScale timeScale) {
            int year = RinexUtils.parseInt(line, 4, 4);
            int month = RinexUtils.parseInt(line, 9, 2);
            int day = RinexUtils.parseInt(line, 12, 2);
            int hours = RinexUtils.parseInt(line, 15, 2);
            int min = RinexUtils.parseInt(line, 18, 2);
            int sec = RinexUtils.parseInt(line, 21, 2);
            return new AbsoluteDate(year, month, day, hours, min, (double)sec, timeScale);
        }

        protected double parseBroadcastDouble1(String line, int initialSpaces, Unit unit) {
            return unit.toSI(RinexUtils.parseDouble(line, initialSpaces, 19));
        }

        protected int parseBroadcastInt1(String line, int initialSpaces) {
            return (int)FastMath.rint((double)RinexUtils.parseDouble(line, initialSpaces, 19));
        }

        protected double parseBroadcastDouble2(String line, int initialSpaces, Unit unit) {
            return unit.toSI(RinexUtils.parseDouble(line, initialSpaces + 19, 19));
        }

        protected int parseBroadcastInt2(String line, int initialSpaces) {
            return (int)FastMath.rint((double)RinexUtils.parseDouble(line, initialSpaces + 19, 19));
        }

        protected double parseBroadcastDouble3(String line, int initialSpaces, Unit unit) {
            return unit.toSI(RinexUtils.parseDouble(line, initialSpaces + 38, 19));
        }

        protected int parseBroadcastInt3(String line, int initialSpaces) {
            return (int)FastMath.rint((double)RinexUtils.parseDouble(line, initialSpaces + 38, 19));
        }

        protected double parseBroadcastDouble4(String line, int initialSpaces, Unit unit) {
            return unit.toSI(RinexUtils.parseDouble(line, initialSpaces + 57, 19));
        }

        protected int parseBroadcastInt4(String line, int initialSpaces) {
            return (int)FastMath.rint((double)RinexUtils.parseDouble(line, initialSpaces + 57, 19));
        }

        public abstract void parseSvEpochSvClockLine(String var1, ParseInfo var2);

        public abstract void parseFirstBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseSecondBroadcastOrbit(String var1, ParseInfo var2);

        public abstract void parseThirdBroadcastOrbit(String var1, ParseInfo var2);

        public void parseFourthBroadcastOrbit(String line, ParseInfo pi) {
            throw new OrekitInternalError(null);
        }

        public void parseFifthBroadcastOrbit(String line, ParseInfo pi) {
            throw new OrekitInternalError(null);
        }

        public void parseSixthBroadcastOrbit(String line, ParseInfo pi) {
            throw new OrekitInternalError(null);
        }

        public void parseSeventhBroadcastOrbit(String line, ParseInfo pi) {
            throw new OrekitInternalError(null);
        }

        public void parseEighthBroadcastOrbit(String line, ParseInfo pi) {
            throw new OrekitInternalError(null);
        }

        public void parseNinthBroadcastOrbit(String line, ParseInfo pi) {
            throw new OrekitInternalError(null);
        }

        public abstract void closeMessage(ParseInfo var1);

        private static double fmod(double a, double b) {
            double x = (int)(a / b);
            return a - x * b;
        }
    }

    private static enum LineParser {
        HEADER_VERSION(line -> RinexUtils.matchesLabel(line, "RINEX VERSION / TYPE"), (line, pi) -> {
            RinexUtils.parseVersionFileTypeSatelliteSystem(line, pi.name, pi.file.getHeader(), new double[]{2.0, 2.01, 2.1, 2.11, 3.01, 3.02, 3.03, 3.04, 3.05, 4.0});
            pi.initialSpaces = ((RinexNavigationHeader)pi.file.getHeader()).getFormatVersion() < 3.0 ? 3 : 4;
        }, LineParser::headerNext),
        HEADER_PROGRAM(line -> RinexUtils.matchesLabel(line, "PGM / RUN BY / DATE"), (line, pi) -> RinexUtils.parseProgramRunByDate(line, pi.lineNumber, pi.name, pi.timeScales, pi.file.getHeader()), LineParser::headerNext),
        HEADER_COMMENT(line -> RinexUtils.matchesLabel(line, "COMMENT"), (line, pi) -> RinexUtils.parseComment(pi.lineNumber, line, pi.file), LineParser::headerNext),
        HEADER_ION_ALPHA(line -> RinexUtils.matchesLabel(line, "ION ALPHA"), (line, pi) -> {
            ((RinexNavigationHeader)pi.file.getHeader()).setIonosphericCorrectionType(IonosphericCorrectionType.GPS);
            double[] parameters = new double[]{RinexUtils.parseDouble(line, 2, 12), RinexUtils.parseDouble(line, 14, 12), RinexUtils.parseDouble(line, 26, 12), RinexUtils.parseDouble(line, 38, 12)};
            pi.file.setKlobucharAlpha(parameters);
            pi.isIonosphereAlphaInitialized = true;
        }, LineParser::headerNext),
        HEADER_ION_BETA(line -> RinexUtils.matchesLabel(line, "ION BETA"), (line, pi) -> {
            ((RinexNavigationHeader)pi.file.getHeader()).setIonosphericCorrectionType(IonosphericCorrectionType.GPS);
            double[] parameters = new double[]{RinexUtils.parseDouble(line, 2, 12), RinexUtils.parseDouble(line, 14, 12), RinexUtils.parseDouble(line, 26, 12), RinexUtils.parseDouble(line, 38, 12)};
            pi.file.setKlobucharBeta(parameters);
        }, LineParser::headerNext),
        HEADER_IONOSPHERIC(line -> RinexUtils.matchesLabel(line, "IONOSPHERIC CORR"), (line, pi) -> {
            IonosphericCorrectionType ionoType = IonosphericCorrectionType.valueOf(RinexUtils.parseString(line, 0, 3));
            ((RinexNavigationHeader)pi.file.getHeader()).setIonosphericCorrectionType(ionoType);
            double[] parameters = new double[]{RinexUtils.parseDouble(line, 5, 12), RinexUtils.parseDouble(line, 17, 12), RinexUtils.parseDouble(line, 29, 12), RinexUtils.parseDouble(line, 41, 12)};
            if (ionoType == IonosphericCorrectionType.GAL) {
                pi.file.setNeQuickAlpha(parameters);
            } else if (pi.isIonosphereAlphaInitialized) {
                pi.file.setKlobucharBeta(parameters);
            } else {
                pi.file.setKlobucharAlpha(parameters);
                pi.isIonosphereAlphaInitialized = true;
            }
        }, LineParser::headerNext),
        HEADER_DELTA_UTC(line -> RinexUtils.matchesLabel(line, "DELTA-UTC: A0,A1,T,W"), (line, pi) -> {
            double a0 = RinexUtils.parseDouble(line, 3, 19);
            double a1 = RinexUtils.parseDouble(line, 22, 19);
            int refTime = RinexUtils.parseInt(line, 41, 9);
            int refWeek = RinexUtils.parseInt(line, 50, 9);
            SatelliteSystem satSystem = ((RinexNavigationHeader)pi.file.getHeader()).getSatelliteSystem();
            AbsoluteDate date = new GNSSDate(refWeek, refTime, satSystem, pi.timeScales).getDate();
            TimeSystemCorrection tsc = new TimeSystemCorrection("GPUT", date, a0, a1);
            ((RinexNavigationHeader)pi.file.getHeader()).addTimeSystemCorrections(tsc);
        }, LineParser::headerNext),
        HEADER_CORR_SYSTEM_TIME(line -> RinexUtils.matchesLabel(line, "CORR TO SYSTEM TIME"), (line, pi) -> {
            int year = RinexUtils.parseInt(line, 0, 6);
            int month = RinexUtils.parseInt(line, 6, 6);
            int day = RinexUtils.parseInt(line, 12, 6);
            double minusTau = RinexUtils.parseDouble(line, 21, 19);
            SatelliteSystem satSystem = ((RinexNavigationHeader)pi.file.getHeader()).getSatelliteSystem();
            TimeScale timeScale = satSystem.getObservationTimeScale().getTimeScale(pi.timeScales);
            AbsoluteDate date = new AbsoluteDate(year, month, day, timeScale);
            TimeSystemCorrection tsc = new TimeSystemCorrection("GLUT", date, minusTau, 0.0);
            ((RinexNavigationHeader)pi.file.getHeader()).addTimeSystemCorrections(tsc);
        }, LineParser::headerNext),
        HEADER_TIME(line -> RinexUtils.matchesLabel(line, "TIME SYSTEM CORR"), (line, pi) -> {
            String type = RinexUtils.parseString(line, 0, 4);
            double a0 = RinexUtils.parseDouble(line, 5, 17);
            double a1 = RinexUtils.parseDouble(line, 22, 16);
            int refTime = RinexUtils.parseInt(line, 38, 7);
            int refWeek = RinexUtils.parseInt(line, 46, 5);
            SatelliteSystem satSystem = ((RinexNavigationHeader)pi.file.getHeader()).getSatelliteSystem();
            AbsoluteDate date = satSystem == SatelliteSystem.GLONASS ? null : (satSystem == SatelliteSystem.BEIDOU ? new GNSSDate(refWeek, refTime, satSystem, pi.timeScales).getDate() : new GNSSDate(refWeek, refTime, SatelliteSystem.GPS, pi.timeScales).getDate());
            TimeSystemCorrection tsc = new TimeSystemCorrection(type, date, a0, a1);
            ((RinexNavigationHeader)pi.file.getHeader()).addTimeSystemCorrections(tsc);
        }, LineParser::headerNext),
        HEADER_LEAP_SECONDS(line -> RinexUtils.matchesLabel(line, "LEAP SECONDS"), (line, pi) -> ((RinexNavigationHeader)pi.file.getHeader()).setNumberOfLeapSeconds(RinexUtils.parseInt(line, 0, 6)), LineParser::headerNext),
        HEADER_DOI(line -> RinexUtils.matchesLabel(line, "DOI"), (line, pi) -> ((RinexNavigationHeader)pi.file.getHeader()).setDoi(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        HEADER_LICENSE(line -> RinexUtils.matchesLabel(line, "LICENSE OF USE"), (line, pi) -> ((RinexNavigationHeader)pi.file.getHeader()).setLicense(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        HEADER_STATION_INFORMATION(line -> RinexUtils.matchesLabel(line, "STATION INFORMATION"), (line, pi) -> ((RinexNavigationHeader)pi.file.getHeader()).setStationInformation(RinexUtils.parseString(line, 0, 60)), LineParser::headerNext),
        HEADER_MERGED_FILE(line -> RinexUtils.matchesLabel(line, "MERGED FILE"), (line, pi) -> ((RinexNavigationHeader)pi.file.getHeader()).setMergedFiles(RinexUtils.parseInt(line, 0, 9)), LineParser::headerNext),
        HEADER_END(line -> RinexUtils.matchesLabel(line, "END OF HEADER"), (line, pi) -> {
            RinexNavigationHeader header = (RinexNavigationHeader)pi.file.getHeader();
            double version = header.getFormatVersion();
            if (header.getRunByName() == null || version >= 4.0 && header.getNumberOfLeapSeconds() < 0) {
                throw new OrekitException((Localizable)OrekitMessages.INCOMPLETE_HEADER, pi.name);
            }
            pi.headerParsed = true;
        }, LineParser::navigationNext),
        NAVIGATION_SV_EPOCH_CLOCK_RINEX_2(line -> true, (line, pi) -> {
            pi.messageLineNumber = 0;
            pi.closePendingMessage();
            pi.systemLineParser = SatelliteSystemLineParser.getParser(((RinexNavigationHeader)pi.file.getHeader()).getSatelliteSystem(), null, pi, line);
            pi.systemLineParser.parseSvEpochSvClockLine(line, pi);
        }, LineParser::navigationNext),
        NAVIGATION_SV_EPOCH_CLOCK(line -> RinexNavigationParser.INITIALS.indexOf(line.charAt(0)) >= 0, (line, pi) -> {
            pi.messageLineNumber = 0;
            if (((RinexNavigationHeader)pi.file.getHeader()).getFormatVersion() < 4.0) {
                SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 0, 1));
                pi.closePendingMessage();
                pi.systemLineParser = SatelliteSystemLineParser.getParser(system, null, pi, line);
            }
            pi.systemLineParser.parseSvEpochSvClockLine(line, pi);
        }, LineParser::navigationNext),
        EPH_TYPE(line -> line.startsWith("> EPH"), (line, pi) -> {
            SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 6, 1));
            String type = RinexUtils.parseString(line, 10, 4);
            pi.closePendingMessage();
            pi.systemLineParser = SatelliteSystemLineParser.getParser(system, type, pi, line);
        }, pi -> Collections.singleton(NAVIGATION_SV_EPOCH_CLOCK)),
        BROADCAST_ORBIT(line -> line.startsWith("   "), (line, pi) -> {
            switch (++pi.messageLineNumber) {
                case 1: {
                    pi.systemLineParser.parseFirstBroadcastOrbit(line, pi);
                    break;
                }
                case 2: {
                    pi.systemLineParser.parseSecondBroadcastOrbit(line, pi);
                    break;
                }
                case 3: {
                    pi.systemLineParser.parseThirdBroadcastOrbit(line, pi);
                    break;
                }
                case 4: {
                    pi.systemLineParser.parseFourthBroadcastOrbit(line, pi);
                    break;
                }
                case 5: {
                    pi.systemLineParser.parseFifthBroadcastOrbit(line, pi);
                    break;
                }
                case 6: {
                    pi.systemLineParser.parseSixthBroadcastOrbit(line, pi);
                    break;
                }
                case 7: {
                    pi.systemLineParser.parseSeventhBroadcastOrbit(line, pi);
                    break;
                }
                case 8: {
                    pi.systemLineParser.parseEighthBroadcastOrbit(line, pi);
                    break;
                }
                case 9: {
                    pi.systemLineParser.parseNinthBroadcastOrbit(line, pi);
                    break;
                }
                default: {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, pi.lineNumber, pi.name, line);
                }
            }
        }, LineParser::navigationNext),
        STO_LINE_1(line -> true, (line, pi) -> {
            pi.sto.setTransmissionTime(Unit.SECOND.toSI(RinexUtils.parseDouble(line, 4, 19)));
            pi.sto.setA0(Unit.SECOND.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.sto.setA1(S_PER_S.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.sto.setA2(S_PER_S2.toSI(RinexUtils.parseDouble(line, 61, 19)));
            pi.file.addSystemTimeOffset(pi.sto);
            pi.sto = null;
        }, LineParser::navigationNext),
        STO_SV_EPOCH_CLOCK(line -> true, (line, pi) -> {
            pi.sto.setDefinedTimeSystem(TimeSystem.parseTwoLettersCode(RinexUtils.parseString(line, 24, 2)));
            pi.sto.setReferenceTimeSystem(TimeSystem.parseTwoLettersCode(RinexUtils.parseString(line, 26, 2)));
            String sbas = RinexUtils.parseString(line, 43, 18);
            pi.sto.setSbasId(sbas.length() > 0 ? SbasId.valueOf(sbas) : null);
            String utc = RinexUtils.parseString(line, 62, 18);
            pi.sto.setUtcId(utc.length() > 0 ? UtcId.parseUtcId(utc) : null);
            int year = RinexUtils.parseInt(line, 4, 4);
            int month = RinexUtils.parseInt(line, 9, 2);
            int day = RinexUtils.parseInt(line, 12, 2);
            int hours = RinexUtils.parseInt(line, 15, 2);
            int min = RinexUtils.parseInt(line, 18, 2);
            int sec = RinexUtils.parseInt(line, 21, 2);
            pi.sto.setReferenceEpoch(new AbsoluteDate(year, month, day, hours, min, (double)sec, pi.sto.getDefinedTimeSystem().getTimeScale(pi.timeScales)));
        }, pi -> Collections.singleton(STO_LINE_1)),
        STO_TYPE(line -> line.startsWith("> STO"), (line, pi) -> {
            pi.closePendingMessage();
            pi.sto = new SystemTimeOffsetMessage(SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 6, 1)), RinexUtils.parseInt(line, 7, 2), RinexUtils.parseString(line, 10, 4));
        }, pi -> Collections.singleton(STO_SV_EPOCH_CLOCK)),
        EOP_LINE_2(line -> true, (line, pi) -> {
            pi.eop.setTransmissionTime(Unit.SECOND.toSI(RinexUtils.parseDouble(line, 4, 19)));
            pi.eop.setDut1(Unit.SECOND.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.eop.setDut1Dot(S_PER_DAY.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.eop.setDut1DotDot(S_PER_DAY2.toSI(RinexUtils.parseDouble(line, 61, 19)));
            pi.file.addEarthOrientationParameter(pi.eop);
            pi.eop = null;
        }, LineParser::navigationNext),
        EOP_LINE_1(line -> true, (line, pi) -> {
            pi.eop.setYp(Unit.ARC_SECOND.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.eop.setYpDot(AS_PER_DAY.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.eop.setYpDotDot(AS_PER_DAY2.toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(EOP_LINE_2)),
        EOP_SV_EPOCH_CLOCK(line -> true, (line, pi) -> {
            int year = RinexUtils.parseInt(line, 4, 4);
            int month = RinexUtils.parseInt(line, 9, 2);
            int day = RinexUtils.parseInt(line, 12, 2);
            int hours = RinexUtils.parseInt(line, 15, 2);
            int min = RinexUtils.parseInt(line, 18, 2);
            int sec = RinexUtils.parseInt(line, 21, 2);
            pi.eop.setReferenceEpoch(new AbsoluteDate(year, month, day, hours, min, (double)sec, pi.eop.getSystem().getObservationTimeScale().getTimeScale(pi.timeScales)));
            pi.eop.setXp(Unit.ARC_SECOND.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.eop.setXpDot(AS_PER_DAY.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.eop.setXpDotDot(AS_PER_DAY2.toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(EOP_LINE_1)),
        EOP_TYPE(line -> line.startsWith("> EOP"), (line, pi) -> {
            pi.closePendingMessage();
            pi.eop = new EarthOrientationParameterMessage(SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 6, 1)), RinexUtils.parseInt(line, 7, 2), RinexUtils.parseString(line, 10, 4));
        }, pi -> Collections.singleton(EOP_SV_EPOCH_CLOCK)),
        KLOBUCHAR_LINE_2(line -> true, (line, pi) -> {
            pi.klobuchar.setBetaI(3, IonosphereKlobucharMessage.S_PER_SC_N[3].toSI(RinexUtils.parseDouble(line, 4, 19)));
            pi.klobuchar.setRegionCode(RinexUtils.parseDouble(line, 23, 19) < 0.5 ? RegionCode.WIDE_AREA : RegionCode.JAPAN);
            pi.file.addKlobucharMessage(pi.klobuchar);
            pi.klobuchar = null;
        }, LineParser::navigationNext),
        KLOBUCHAR_LINE_1(line -> true, (line, pi) -> {
            pi.klobuchar.setAlphaI(3, IonosphereKlobucharMessage.S_PER_SC_N[3].toSI(RinexUtils.parseDouble(line, 4, 19)));
            pi.klobuchar.setBetaI(0, IonosphereKlobucharMessage.S_PER_SC_N[0].toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.klobuchar.setBetaI(1, IonosphereKlobucharMessage.S_PER_SC_N[1].toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.klobuchar.setBetaI(2, IonosphereKlobucharMessage.S_PER_SC_N[2].toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(KLOBUCHAR_LINE_2)),
        KLOBUCHAR_LINE_0(line -> true, (line, pi) -> {
            int year = RinexUtils.parseInt(line, 4, 4);
            int month = RinexUtils.parseInt(line, 9, 2);
            int day = RinexUtils.parseInt(line, 12, 2);
            int hours = RinexUtils.parseInt(line, 15, 2);
            int min = RinexUtils.parseInt(line, 18, 2);
            int sec = RinexUtils.parseInt(line, 21, 2);
            pi.klobuchar.setTransmitTime(new AbsoluteDate(year, month, day, hours, min, (double)sec, pi.klobuchar.getSystem().getObservationTimeScale().getTimeScale(pi.timeScales)));
            pi.klobuchar.setAlphaI(0, IonosphereKlobucharMessage.S_PER_SC_N[0].toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.klobuchar.setAlphaI(1, IonosphereKlobucharMessage.S_PER_SC_N[1].toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.klobuchar.setAlphaI(2, IonosphereKlobucharMessage.S_PER_SC_N[2].toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(KLOBUCHAR_LINE_1)),
        NEQUICK_LINE_1(line -> true, (line, pi) -> {
            pi.nequickG.setFlags((int)FastMath.rint((double)RinexUtils.parseDouble(line, 4, 19)));
            pi.file.addNequickGMessage(pi.nequickG);
            pi.nequickG = null;
        }, LineParser::navigationNext),
        NEQUICK_LINE_0(line -> true, (line, pi) -> {
            int year = RinexUtils.parseInt(line, 4, 4);
            int month = RinexUtils.parseInt(line, 9, 2);
            int day = RinexUtils.parseInt(line, 12, 2);
            int hours = RinexUtils.parseInt(line, 15, 2);
            int min = RinexUtils.parseInt(line, 18, 2);
            int sec = RinexUtils.parseInt(line, 21, 2);
            pi.nequickG.setTransmitTime(new AbsoluteDate(year, month, day, hours, min, (double)sec, pi.nequickG.getSystem().getObservationTimeScale().getTimeScale(pi.timeScales)));
            pi.nequickG.setAi0(IonosphereNequickGMessage.SFU.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.nequickG.setAi1(IonosphereNequickGMessage.SFU_PER_DEG.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.nequickG.setAi2(IonosphereNequickGMessage.SFU_PER_DEG2.toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(NEQUICK_LINE_1)),
        BDGIM_LINE_2(line -> true, (line, pi) -> {
            pi.bdgim.setAlphaI(7, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 4, 19)));
            pi.bdgim.setAlphaI(8, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.file.addBDGIMMessage(pi.bdgim);
            pi.bdgim = null;
        }, LineParser::navigationNext),
        BDGIM_LINE_1(line -> true, (line, pi) -> {
            pi.bdgim.setAlphaI(3, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 4, 19)));
            pi.bdgim.setAlphaI(4, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.bdgim.setAlphaI(5, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.bdgim.setAlphaI(6, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(BDGIM_LINE_2)),
        BDGIM_LINE_0(line -> true, (line, pi) -> {
            int year = RinexUtils.parseInt(line, 4, 4);
            int month = RinexUtils.parseInt(line, 9, 2);
            int day = RinexUtils.parseInt(line, 12, 2);
            int hours = RinexUtils.parseInt(line, 15, 2);
            int min = RinexUtils.parseInt(line, 18, 2);
            int sec = RinexUtils.parseInt(line, 21, 2);
            pi.bdgim.setTransmitTime(new AbsoluteDate(year, month, day, hours, min, (double)sec, pi.bdgim.getSystem().getObservationTimeScale().getTimeScale(pi.timeScales)));
            pi.bdgim.setAlphaI(0, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 23, 19)));
            pi.bdgim.setAlphaI(1, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 42, 19)));
            pi.bdgim.setAlphaI(2, Unit.TOTAL_ELECTRON_CONTENT_UNIT.toSI(RinexUtils.parseDouble(line, 61, 19)));
        }, pi -> Collections.singleton(BDGIM_LINE_1)),
        IONO_TYPE(line -> line.startsWith("> ION"), (line, pi) -> {
            pi.closePendingMessage();
            SatelliteSystem system = SatelliteSystem.parseSatelliteSystem(RinexUtils.parseString(line, 6, 1));
            int prn = RinexUtils.parseInt(line, 7, 2);
            String type = RinexUtils.parseString(line, 10, 4);
            if (system == SatelliteSystem.GALILEO) {
                pi.nequickG = new IonosphereNequickGMessage(system, prn, type);
            } else if (system == SatelliteSystem.BEIDOU && "CNVX".equals(type)) {
                pi.bdgim = new IonosphereBDGIMMessage(system, prn, type);
            } else {
                pi.klobuchar = new IonosphereKlobucharMessage(system, prn, type);
            }
        }, pi -> Collections.singleton(((ParseInfo)pi).nequickG != null ? NEQUICK_LINE_0 : (((ParseInfo)pi).bdgim != null ? BDGIM_LINE_0 : KLOBUCHAR_LINE_0)));

        private final Predicate<String> canHandle;
        private final ParsingMethod parsingMethod;
        private final Function<ParseInfo, Iterable<LineParser>> allowedNextProvider;

        private LineParser(Predicate<String> canHandle, ParsingMethod parsingMethod, Function<ParseInfo, Iterable<LineParser>> allowedNextProvider) {
            this.canHandle = canHandle;
            this.parsingMethod = parsingMethod;
            this.allowedNextProvider = allowedNextProvider;
        }

        private static Iterable<LineParser> headerNext(ParseInfo parseInfo) {
            if (((RinexNavigationHeader)parseInfo.file.getHeader()).getFormatVersion() < 3.0) {
                return Arrays.asList(HEADER_COMMENT, HEADER_PROGRAM, HEADER_ION_ALPHA, HEADER_ION_BETA, HEADER_DELTA_UTC, HEADER_CORR_SYSTEM_TIME, HEADER_LEAP_SECONDS, HEADER_END);
            }
            if (((RinexNavigationHeader)parseInfo.file.getHeader()).getFormatVersion() < 4.0) {
                return Arrays.asList(HEADER_COMMENT, HEADER_PROGRAM, HEADER_IONOSPHERIC, HEADER_TIME, HEADER_LEAP_SECONDS, HEADER_END);
            }
            return Arrays.asList(HEADER_COMMENT, HEADER_PROGRAM, HEADER_DOI, HEADER_LICENSE, HEADER_STATION_INFORMATION, HEADER_MERGED_FILE, HEADER_LEAP_SECONDS, HEADER_END);
        }

        private static Iterable<LineParser> navigationNext(ParseInfo parseInfo) {
            if (parseInfo.gpsLNav != null || parseInfo.gpsCNav != null || parseInfo.galileoNav != null || parseInfo.beidouLNav != null || parseInfo.beidouCNav != null || parseInfo.qzssLNav != null || parseInfo.qzssCNav != null || parseInfo.irnssNav != null || parseInfo.sbasNav != null) {
                return Collections.singleton(BROADCAST_ORBIT);
            }
            if (parseInfo.glonassNav != null) {
                if (parseInfo.messageLineNumber < 3) {
                    return Collections.singleton(BROADCAST_ORBIT);
                }
                if (((RinexNavigationHeader)parseInfo.file.getHeader()).getFormatVersion() < 4.0) {
                    return Arrays.asList(BROADCAST_ORBIT, NAVIGATION_SV_EPOCH_CLOCK);
                }
                return Arrays.asList(BROADCAST_ORBIT, EPH_TYPE, STO_TYPE, EOP_TYPE, IONO_TYPE);
            }
            if (((RinexNavigationHeader)parseInfo.file.getHeader()).getFormatVersion() < 3.0) {
                return Collections.singleton(NAVIGATION_SV_EPOCH_CLOCK_RINEX_2);
            }
            if (((RinexNavigationHeader)parseInfo.file.getHeader()).getFormatVersion() < 4.0) {
                return Collections.singleton(NAVIGATION_SV_EPOCH_CLOCK);
            }
            return Arrays.asList(EPH_TYPE, STO_TYPE, EOP_TYPE, IONO_TYPE);
        }
    }

    private class ParseInfo {
        private final String name;
        private final TimeScales timeScales;
        private RinexNavigation file;
        private int initialSpaces;
        private boolean headerParsed;
        private boolean isIonosphereAlphaInitialized;
        private SatelliteSystemLineParser systemLineParser;
        private int lineNumber;
        private int messageLineNumber;
        private GPSLegacyNavigationMessage gpsLNav;
        private GPSCivilianNavigationMessage gpsCNav;
        private GalileoNavigationMessage galileoNav;
        private BeidouLegacyNavigationMessage beidouLNav;
        private BeidouCivilianNavigationMessage beidouCNav;
        private QZSSLegacyNavigationMessage qzssLNav;
        private QZSSCivilianNavigationMessage qzssCNav;
        private IRNSSNavigationMessage irnssNav;
        private GLONASSNavigationMessage glonassNav;
        private SBASNavigationMessage sbasNav;
        private SystemTimeOffsetMessage sto;
        private EarthOrientationParameterMessage eop;
        private IonosphereKlobucharMessage klobuchar;
        private IonosphereNequickGMessage nequickG;
        private IonosphereBDGIMMessage bdgim;

        ParseInfo(String name) {
            this.name = name;
            this.timeScales = RinexNavigationParser.this.timeScales;
            this.isIonosphereAlphaInitialized = false;
            this.file = new RinexNavigation();
        }

        void closePendingMessage() {
            if (this.systemLineParser != null) {
                this.systemLineParser.closeMessage(this);
                this.systemLineParser = null;
            }
        }
    }
}

