/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.orekit.files.rinex.RinexFile;
import org.orekit.files.rinex.navigation.EarthOrientationParameterMessage;
import org.orekit.files.rinex.navigation.IonosphereBDGIMMessage;
import org.orekit.files.rinex.navigation.IonosphereKlobucharMessage;
import org.orekit.files.rinex.navigation.IonosphereNequickGMessage;
import org.orekit.files.rinex.navigation.RinexNavigationHeader;
import org.orekit.files.rinex.navigation.SystemTimeOffsetMessage;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.propagation.analytical.gnss.data.BeidouCivilianNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.BeidouLegacyNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GLONASSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GPSCivilianNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GPSLegacyNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GalileoNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.IRNSSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.QZSSCivilianNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.QZSSLegacyNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.SBASNavigationMessage;

public class RinexNavigation
extends RinexFile<RinexNavigationHeader> {
    private double[] klobucharAlpha;
    private double[] klobucharBeta;
    private double[] neQuickAlpha;
    private final Map<String, List<GPSLegacyNavigationMessage>> gpsLegacyData = new HashMap<String, List<GPSLegacyNavigationMessage>>();
    private final Map<String, List<GPSCivilianNavigationMessage>> gpsCivilianData = new HashMap<String, List<GPSCivilianNavigationMessage>>();
    private final Map<String, List<GalileoNavigationMessage>> galileoData = new HashMap<String, List<GalileoNavigationMessage>>();
    private final Map<String, List<BeidouLegacyNavigationMessage>> beidouLegacyData = new HashMap<String, List<BeidouLegacyNavigationMessage>>();
    private final Map<String, List<BeidouCivilianNavigationMessage>> beidouCivilianData = new HashMap<String, List<BeidouCivilianNavigationMessage>>();
    private final Map<String, List<QZSSLegacyNavigationMessage>> qzssLegacyData = new HashMap<String, List<QZSSLegacyNavigationMessage>>();
    private final Map<String, List<QZSSCivilianNavigationMessage>> qzssCivilianData = new HashMap<String, List<QZSSCivilianNavigationMessage>>();
    private final Map<String, List<IRNSSNavigationMessage>> irnssData = new HashMap<String, List<IRNSSNavigationMessage>>();
    private final Map<String, List<GLONASSNavigationMessage>> glonassData = new HashMap<String, List<GLONASSNavigationMessage>>();
    private final Map<String, List<SBASNavigationMessage>> sbasData = new HashMap<String, List<SBASNavigationMessage>>();
    private final List<SystemTimeOffsetMessage> systemTimeOffsets = new ArrayList<SystemTimeOffsetMessage>();
    private final List<EarthOrientationParameterMessage> eops = new ArrayList<EarthOrientationParameterMessage>();
    private final List<IonosphereKlobucharMessage> klobucharMessages = new ArrayList<IonosphereKlobucharMessage>();
    private final List<IonosphereNequickGMessage> nequickGMessages = new ArrayList<IonosphereNequickGMessage>();
    private final List<IonosphereBDGIMMessage> bdgimMessages = new ArrayList<IonosphereBDGIMMessage>();

    public RinexNavigation() {
        super(new RinexNavigationHeader());
    }

    public double[] getKlobucharAlpha() {
        return (double[])this.klobucharAlpha.clone();
    }

    public void setKlobucharAlpha(double[] klobucharAlpha) {
        this.klobucharAlpha = (double[])klobucharAlpha.clone();
    }

    public double[] getKlobucharBeta() {
        return (double[])this.klobucharBeta.clone();
    }

    public void setKlobucharBeta(double[] klobucharBeta) {
        this.klobucharBeta = (double[])klobucharBeta.clone();
    }

    public double[] getNeQuickAlpha() {
        return (double[])this.neQuickAlpha.clone();
    }

    public void setNeQuickAlpha(double[] neQuickAlpha) {
        this.neQuickAlpha = (double[])neQuickAlpha.clone();
    }

    public Map<String, List<GPSLegacyNavigationMessage>> getGPSLegacyNavigationMessages() {
        return Collections.unmodifiableMap(this.gpsLegacyData);
    }

    public List<GPSLegacyNavigationMessage> getGPSLegacyNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.gpsLegacyData.get(satId));
    }

    public void addGPSLegacyNavigationMessage(GPSLegacyNavigationMessage message) {
        int gpsPRN = message.getPRN();
        String prnString = gpsPRN < 10 ? "0" + String.valueOf(gpsPRN) : String.valueOf(gpsPRN);
        String satId = SatelliteSystem.GPS.getKey() + prnString;
        this.gpsLegacyData.putIfAbsent(satId, new ArrayList());
        this.gpsLegacyData.get(satId).add(message);
    }

    public Map<String, List<GPSCivilianNavigationMessage>> getGPSCivilianNavigationMessages() {
        return Collections.unmodifiableMap(this.gpsCivilianData);
    }

    public List<GPSCivilianNavigationMessage> getGPSCivilianNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.gpsCivilianData.get(satId));
    }

    public void addGPSLegacyNavigationMessage(GPSCivilianNavigationMessage message) {
        int gpsPRN = message.getPRN();
        String prnString = gpsPRN < 10 ? "0" + String.valueOf(gpsPRN) : String.valueOf(gpsPRN);
        String satId = SatelliteSystem.GPS.getKey() + prnString;
        this.gpsCivilianData.putIfAbsent(satId, new ArrayList());
        this.gpsCivilianData.get(satId).add(message);
    }

    public Map<String, List<GalileoNavigationMessage>> getGalileoNavigationMessages() {
        return Collections.unmodifiableMap(this.galileoData);
    }

    public List<GalileoNavigationMessage> getGalileoNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.galileoData.get(satId));
    }

    public void addGalileoNavigationMessage(GalileoNavigationMessage message) {
        int galPRN = message.getPRN();
        String prnString = galPRN < 10 ? "0" + String.valueOf(galPRN) : String.valueOf(galPRN);
        String satId = SatelliteSystem.GALILEO.getKey() + prnString;
        this.galileoData.putIfAbsent(satId, new ArrayList());
        this.galileoData.get(satId).add(message);
    }

    public Map<String, List<BeidouLegacyNavigationMessage>> getBeidouLegacyNavigationMessages() {
        return Collections.unmodifiableMap(this.beidouLegacyData);
    }

    public List<BeidouLegacyNavigationMessage> getBeidouLegacyNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.beidouLegacyData.get(satId));
    }

    public void addBeidouLegacyNavigationMessage(BeidouLegacyNavigationMessage message) {
        int bdtPRN = message.getPRN();
        String prnString = bdtPRN < 10 ? "0" + String.valueOf(bdtPRN) : String.valueOf(bdtPRN);
        String satId = SatelliteSystem.BEIDOU.getKey() + prnString;
        this.beidouLegacyData.putIfAbsent(satId, new ArrayList());
        this.beidouLegacyData.get(satId).add(message);
    }

    public Map<String, List<BeidouCivilianNavigationMessage>> getBeidouCivilianNavigationMessages() {
        return Collections.unmodifiableMap(this.beidouCivilianData);
    }

    public List<BeidouCivilianNavigationMessage> getBeidouCivilianNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.beidouCivilianData.get(satId));
    }

    public void addBeidouCivilianNavigationMessage(BeidouCivilianNavigationMessage message) {
        int bdtPRN = message.getPRN();
        String prnString = bdtPRN < 10 ? "0" + String.valueOf(bdtPRN) : String.valueOf(bdtPRN);
        String satId = SatelliteSystem.BEIDOU.getKey() + prnString;
        this.beidouCivilianData.putIfAbsent(satId, new ArrayList());
        this.beidouCivilianData.get(satId).add(message);
    }

    public Map<String, List<QZSSLegacyNavigationMessage>> getQZSSLegacyNavigationMessages() {
        return Collections.unmodifiableMap(this.qzssLegacyData);
    }

    public List<QZSSLegacyNavigationMessage> getQZSSLegacyNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.qzssLegacyData.get(satId));
    }

    public void addQZSSLegacyNavigationMessage(QZSSLegacyNavigationMessage message) {
        int qzsPRN = message.getPRN();
        String prnString = qzsPRN < 10 ? "0" + String.valueOf(qzsPRN) : String.valueOf(qzsPRN);
        String satId = SatelliteSystem.QZSS.getKey() + prnString;
        this.qzssLegacyData.putIfAbsent(satId, new ArrayList());
        this.qzssLegacyData.get(satId).add(message);
    }

    public Map<String, List<QZSSCivilianNavigationMessage>> getQZSSCivilianNavigationMessages() {
        return Collections.unmodifiableMap(this.qzssCivilianData);
    }

    public List<QZSSCivilianNavigationMessage> getQZSSCivilianNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.qzssCivilianData.get(satId));
    }

    public void addQZSSCivilianNavigationMessage(QZSSCivilianNavigationMessage message) {
        int qzsPRN = message.getPRN();
        String prnString = qzsPRN < 10 ? "0" + String.valueOf(qzsPRN) : String.valueOf(qzsPRN);
        String satId = SatelliteSystem.QZSS.getKey() + prnString;
        this.qzssCivilianData.putIfAbsent(satId, new ArrayList());
        this.qzssCivilianData.get(satId).add(message);
    }

    public Map<String, List<IRNSSNavigationMessage>> getIRNSSNavigationMessages() {
        return Collections.unmodifiableMap(this.irnssData);
    }

    public List<IRNSSNavigationMessage> getIRNSSNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.irnssData.get(satId));
    }

    public void addIRNSSNavigationMessage(IRNSSNavigationMessage message) {
        int irsPRN = message.getPRN();
        String prnString = irsPRN < 10 ? "0" + String.valueOf(irsPRN) : String.valueOf(irsPRN);
        String satId = SatelliteSystem.IRNSS.getKey() + prnString;
        this.irnssData.putIfAbsent(satId, new ArrayList());
        this.irnssData.get(satId).add(message);
    }

    public Map<String, List<GLONASSNavigationMessage>> getGlonassNavigationMessages() {
        return Collections.unmodifiableMap(this.glonassData);
    }

    public List<GLONASSNavigationMessage> getGlonassNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.glonassData.get(satId));
    }

    public void addGlonassNavigationMessage(GLONASSNavigationMessage message) {
        int gloPRN = message.getPRN();
        String prnString = gloPRN < 10 ? "0" + String.valueOf(gloPRN) : String.valueOf(gloPRN);
        String satId = SatelliteSystem.GLONASS.getKey() + prnString;
        this.glonassData.putIfAbsent(satId, new ArrayList());
        this.glonassData.get(satId).add(message);
    }

    public Map<String, List<SBASNavigationMessage>> getSBASNavigationMessages() {
        return Collections.unmodifiableMap(this.sbasData);
    }

    public List<SBASNavigationMessage> getSBASNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.sbasData.get(satId));
    }

    public void addSBASNavigationMessage(SBASNavigationMessage message) {
        int sbsPRN = message.getPRN();
        String prnString = sbsPRN < 10 ? "0" + String.valueOf(sbsPRN) : String.valueOf(sbsPRN);
        String satId = SatelliteSystem.SBAS.getKey() + prnString;
        this.sbasData.putIfAbsent(satId, new ArrayList());
        this.sbasData.get(satId).add(message);
    }

    public List<SystemTimeOffsetMessage> getSystemTimeOffsets() {
        return Collections.unmodifiableList(this.systemTimeOffsets);
    }

    public void addSystemTimeOffset(SystemTimeOffsetMessage systemTimeOffset) {
        this.systemTimeOffsets.add(systemTimeOffset);
    }

    public List<EarthOrientationParameterMessage> getEarthOrientationParameters() {
        return Collections.unmodifiableList(this.eops);
    }

    public void addEarthOrientationParameter(EarthOrientationParameterMessage eop) {
        this.eops.add(eop);
    }

    public List<IonosphereKlobucharMessage> getKlobucharMessages() {
        return Collections.unmodifiableList(this.klobucharMessages);
    }

    public void addKlobucharMessage(IonosphereKlobucharMessage klobuchar) {
        this.klobucharMessages.add(klobuchar);
    }

    public List<IonosphereNequickGMessage> getNequickGMessages() {
        return Collections.unmodifiableList(this.nequickGMessages);
    }

    public void addNequickGMessage(IonosphereNequickGMessage nequickG) {
        this.nequickGMessages.add(nequickG);
    }

    public List<IonosphereBDGIMMessage> getBDGIMMessages() {
        return Collections.unmodifiableList(this.bdgimMessages);
    }

    public void addBDGIMMessage(IonosphereBDGIMMessage bdgim) {
        this.bdgimMessages.add(bdgim);
    }
}

