/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.navigation;

import org.orekit.files.rinex.navigation.IonosphereBaseMessage;
import org.orekit.files.rinex.navigation.RegionCode;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.utils.units.Unit;

public class IonosphereKlobucharMessage
extends IonosphereBaseMessage {
    static final Unit[] S_PER_SC_N;
    private final double[] alpha = new double[4];
    private final double[] beta = new double[4];
    private RegionCode regionCode;

    public IonosphereKlobucharMessage(SatelliteSystem system, int prn, String navigationMessageType) {
        super(system, prn, navigationMessageType);
    }

    public double[] getAlpha() {
        return (double[])this.alpha.clone();
    }

    public void setAlphaI(int i, double alphaI) {
        this.alpha[i] = alphaI;
    }

    public double[] getBeta() {
        return (double[])this.beta.clone();
    }

    public void setBetaI(int i, double betaI) {
        this.beta[i] = betaI;
    }

    public RegionCode getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(RegionCode regionCode) {
        this.regionCode = regionCode;
    }

    static {
        Unit sc = Unit.RADIAN.scale("sc", 3.1415926535898);
        S_PER_SC_N = new Unit[4];
        IonosphereKlobucharMessage.S_PER_SC_N[0] = Unit.SECOND;
        IonosphereKlobucharMessage.S_PER_SC_N[1] = S_PER_SC_N[0].divide("s/sc", sc);
        IonosphereKlobucharMessage.S_PER_SC_N[2] = S_PER_SC_N[1].divide("s/sc\u00b2", sc);
        IonosphereKlobucharMessage.S_PER_SC_N[3] = S_PER_SC_N[2].divide("s/sc\u00b3", sc);
    }
}

