/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.rinex.clock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.rinex.AppliedDCBS;
import org.orekit.files.rinex.AppliedPCVS;
import org.orekit.frames.Frame;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.TimeSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.ClockOffset;
import org.orekit.time.DateComponents;
import org.orekit.time.SampledClockModel;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeSpanMap;

public class RinexClock {
    private double formatVersion = 0.0;
    private SatelliteSystem satelliteSystem;
    private String programName;
    private String agencyName = "";
    private String creationDateString = "";
    private String creationTimeString = "";
    private String creationTimeZoneString = "";
    private AbsoluteDate creationDate = null;
    private String comments = "";
    private final Map<SatelliteSystem, List<ObservationType>> systemObservationTypes = new HashMap<SatelliteSystem, List<ObservationType>>();
    private TimeSystem timeSystem;
    private TimeScale timeScale;
    private int numberOfLeapSeconds;
    private int numberOfLeapSecondsGNSS;
    private final List<AppliedDCBS> listAppliedDCBS = new ArrayList<AppliedDCBS>();
    private final List<AppliedPCVS> listAppliedPCVS = new ArrayList<AppliedPCVS>();
    private final List<ClockDataType> clockDataTypes = new ArrayList<ClockDataType>();
    private String stationName;
    private String stationIdentifier;
    private String externalClockReference = "";
    private String analysisCenterID = "";
    private String analysisCenterName = "";
    private final TimeSpanMap<List<ReferenceClock>> referenceClocks;
    private String frameName;
    private final Function<? super String, ? extends Frame> frameBuilder;
    private final List<Receiver> receivers = new ArrayList<Receiver>();
    private final List<String> satellites = new ArrayList<String>();
    private final Map<String, List<ClockDataLine>> clockData = new HashMap<String, List<ClockDataLine>>();
    private AbsoluteDate earliestEpoch;
    private AbsoluteDate latestEpoch;

    public RinexClock(Function<? super String, ? extends Frame> frameBuilder) {
        this.frameBuilder = frameBuilder;
        this.frameName = "";
        this.numberOfLeapSeconds = 0;
        this.numberOfLeapSecondsGNSS = 0;
        this.programName = "";
        this.referenceClocks = new TimeSpanMap<Object>(null);
        this.satelliteSystem = null;
        this.stationIdentifier = "";
        this.stationName = "";
        this.timeScale = null;
        this.timeSystem = null;
        this.earliestEpoch = AbsoluteDate.FUTURE_INFINITY;
        this.latestEpoch = AbsoluteDate.PAST_INFINITY;
    }

    public void addSatellite(String satId) {
        if (!this.satellites.contains(satId)) {
            this.satellites.add(satId);
        }
    }

    public void addReceiver(Receiver receiver) {
        boolean notInList = true;
        for (Receiver rec : this.receivers) {
            if (!rec.designator.equals(receiver.designator)) continue;
            notInList = false;
            break;
        }
        if (notInList) {
            this.receivers.add(receiver);
        }
    }

    public int getNumberOfClockDataTypes() {
        return this.clockDataTypes.size();
    }

    public int getTotalNumberOfDataLines() {
        int result = 0;
        Map<String, List<ClockDataLine>> data = this.getClockData();
        for (Map.Entry<String, List<ClockDataLine>> entry : data.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public int numberOfObsTypes(SatelliteSystem system) {
        if (this.systemObservationTypes.containsKey((Object)system)) {
            return this.systemObservationTypes.get((Object)system).size();
        }
        return 0;
    }

    public int getNumberOfReceivers() {
        return this.receivers.size();
    }

    public int getNumberOfSatellites() {
        return this.satellites.size();
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    public void setSatelliteSystem(SatelliteSystem satelliteSystem) {
        this.satelliteSystem = satelliteSystem;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getCreationDateString() {
        return this.creationDateString;
    }

    public void setCreationDateString(String creationDateString) {
        this.creationDateString = creationDateString;
    }

    public String getCreationTimeString() {
        return this.creationTimeString;
    }

    public void setCreationTimeString(String creationTimeString) {
        this.creationTimeString = creationTimeString;
    }

    public String getCreationTimeZoneString() {
        return this.creationTimeZoneString;
    }

    public void setCreationTimeZoneString(String creationTimeZoneString) {
        this.creationTimeZoneString = creationTimeZoneString;
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void addComment(String comment) {
        this.comments = this.comments.concat(comment + "\n");
    }

    public Map<SatelliteSystem, List<ObservationType>> getSystemObservationTypes() {
        return Collections.unmodifiableMap(this.systemObservationTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemObservationType(SatelliteSystem satSystem, ObservationType observationType) {
        List list;
        Map<SatelliteSystem, List<ObservationType>> map = this.systemObservationTypes;
        synchronized (map) {
            list = this.systemObservationTypes.computeIfAbsent(satSystem, s -> new ArrayList());
        }
        list.add(observationType);
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(TimeSystem timeSystem) {
        this.timeSystem = timeSystem;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(TimeScale timeScale) {
        this.timeScale = timeScale;
    }

    public int getNumberOfLeapSeconds() {
        return this.numberOfLeapSeconds;
    }

    public void setNumberOfLeapSeconds(int numberOfLeapSeconds) {
        this.numberOfLeapSeconds = numberOfLeapSeconds;
    }

    public int getNumberOfLeapSecondsGNSS() {
        return this.numberOfLeapSecondsGNSS;
    }

    public void setNumberOfLeapSecondsGNSS(int numberOfLeapSecondsGNSS) {
        this.numberOfLeapSecondsGNSS = numberOfLeapSecondsGNSS;
    }

    public List<AppliedDCBS> getListAppliedDCBS() {
        return Collections.unmodifiableList(this.listAppliedDCBS);
    }

    public void addAppliedDCBS(AppliedDCBS appliedDCBS) {
        this.listAppliedDCBS.add(appliedDCBS);
    }

    public List<AppliedPCVS> getListAppliedPCVS() {
        return Collections.unmodifiableList(this.listAppliedPCVS);
    }

    public void addAppliedPCVS(AppliedPCVS appliedPCVS) {
        this.listAppliedPCVS.add(appliedPCVS);
    }

    public List<ClockDataType> getClockDataTypes() {
        return Collections.unmodifiableList(this.clockDataTypes);
    }

    public void addClockDataType(ClockDataType clockDataType) {
        this.clockDataTypes.add(clockDataType);
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getStationIdentifier() {
        return this.stationIdentifier;
    }

    public void setStationIdentifier(String stationIdentifier) {
        this.stationIdentifier = stationIdentifier;
    }

    public String getExternalClockReference() {
        return this.externalClockReference;
    }

    public void setExternalClockReference(String externalClockReference) {
        this.externalClockReference = externalClockReference;
    }

    public String getAnalysisCenterID() {
        return this.analysisCenterID;
    }

    public void setAnalysisCenterID(String analysisCenterID) {
        this.analysisCenterID = analysisCenterID;
    }

    public String getAnalysisCenterName() {
        return this.analysisCenterName;
    }

    public void setAnalysisCenterName(String analysisCenterName) {
        this.analysisCenterName = analysisCenterName;
    }

    public TimeSpanMap<List<ReferenceClock>> getReferenceClocks() {
        return this.referenceClocks;
    }

    public void addReferenceClockList(List<ReferenceClock> referenceClockList, AbsoluteDate startDate) {
        this.referenceClocks.addValidAfter(referenceClockList, startDate, false);
    }

    public String getFrameName() {
        return this.frameName;
    }

    public void setFrameName(String frameName) {
        this.frameName = frameName;
    }

    public List<Receiver> getReceivers() {
        return Collections.unmodifiableList(this.receivers);
    }

    public List<String> getSatellites() {
        return Collections.unmodifiableList(this.satellites);
    }

    public Frame getFrame() {
        return this.frameBuilder.apply(this.frameName);
    }

    public SampledClockModel extractClockModel(String name, int nbInterpolationPoints) {
        ArrayList<ClockOffset> sample = new ArrayList<ClockOffset>();
        this.clockData.get(name).forEach(c -> {
            double offset = ((ClockDataLine)c).clockBias;
            double rate = ((ClockDataLine)c).numberOfValues > 2 ? ((ClockDataLine)c).clockRate : Double.NaN;
            double acceleration = ((ClockDataLine)c).numberOfValues > 4 ? ((ClockDataLine)c).clockAcceleration : Double.NaN;
            sample.add(new ClockOffset(c.getEpoch(), offset, rate, acceleration));
        });
        return new SampledClockModel(sample, nbInterpolationPoints);
    }

    public Map<String, List<ClockDataLine>> getClockData() {
        return Collections.unmodifiableMap(this.clockData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClockData(String id, ClockDataLine clockDataLine) {
        List list;
        Map<String, List<ClockDataLine>> map = this.clockData;
        synchronized (map) {
            list = this.clockData.computeIfAbsent(id, i -> new ArrayList());
        }
        list.add(clockDataLine);
        AbsoluteDate epoch = clockDataLine.getEpoch();
        if (epoch.isBefore(this.earliestEpoch)) {
            this.earliestEpoch = epoch;
        }
        if (epoch.isAfter(this.latestEpoch)) {
            this.latestEpoch = epoch;
        }
    }

    public AbsoluteDate getEarliestEpoch() {
        return this.earliestEpoch;
    }

    public AbsoluteDate getLatestEpoch() {
        return this.latestEpoch;
    }

    public static RinexClock splice(Collection<RinexClock> clocks, double maxGap) {
        ChronologicalComparator comparator = new ChronologicalComparator();
        TreeSet<RinexClock> sorted = new TreeSet<RinexClock>((c1, c2) -> comparator.compare(c1.earliestEpoch, c2.earliestEpoch));
        sorted.addAll(clocks);
        RinexClock first = (RinexClock)sorted.first();
        RinexClock spliced = new RinexClock(first.frameBuilder);
        spliced.setFormatVersion(first.getFormatVersion());
        spliced.setSatelliteSystem(first.satelliteSystem);
        spliced.setProgramName(first.getProgramName());
        spliced.setAgencyName(first.getAgencyName());
        spliced.setCreationDateString(first.getCreationDateString());
        spliced.setCreationTimeString(first.getCreationTimeString());
        spliced.setCreationTimeZoneString(first.getCreationTimeZoneString());
        spliced.setCreationDate(first.getCreationDate());
        spliced.addComment(first.getComments());
        first.getSystemObservationTypes().forEach((s, l) -> l.forEach(o -> spliced.addSystemObservationType((SatelliteSystem)((Object)s), (ObservationType)((Object)((Object)o)))));
        spliced.setTimeSystem(first.getTimeSystem());
        spliced.setTimeScale(first.getTimeScale());
        spliced.setNumberOfLeapSeconds(first.getNumberOfLeapSeconds());
        spliced.setNumberOfLeapSecondsGNSS(first.getNumberOfLeapSecondsGNSS());
        first.getListAppliedDCBS().forEach(spliced::addAppliedDCBS);
        first.getListAppliedPCVS().forEach(spliced::addAppliedPCVS);
        first.getClockDataTypes().forEach(spliced::addClockDataType);
        spliced.setStationName(first.getStationName());
        spliced.setStationIdentifier(first.getStationIdentifier());
        spliced.setExternalClockReference(first.getExternalClockReference());
        spliced.setAnalysisCenterID(first.getAnalysisCenterID());
        spliced.setAnalysisCenterName(first.getAnalysisCenterName());
        spliced.setFrameName(first.getFrameName());
        sorted.forEach(rc -> {
            for (TimeSpanMap.Span<List<ReferenceClock>> span = rc.getReferenceClocks().getFirstSpan(); span != null; span = span.next()) {
                if (span.getData() == null) continue;
                spliced.addReferenceClockList(span.getData(), span.getStart());
            }
        });
        ArrayList clockIds = new ArrayList();
        first.getReceivers().stream().filter(r -> RinexClock.availableInAllFiles(r.getDesignator(), sorted)).forEach(r -> {
            spliced.addReceiver((Receiver)r);
            clockIds.add(r.getDesignator());
        });
        first.getSatellites().stream().filter(s -> RinexClock.availableInAllFiles(s, sorted)).forEach(s -> {
            spliced.addSatellite((String)s);
            clockIds.add(s);
        });
        for (String clockId : clockIds) {
            AbsoluteDate previous = null;
            for (RinexClock rc2 : sorted) {
                if (previous != null && rc2.getEarliestEpoch().durationFrom(previous) > maxGap) {
                    throw new OrekitException((Localizable)OrekitMessages.TOO_LONG_TIME_GAP_BETWEEN_DATA_POINTS, rc2.getEarliestEpoch().durationFrom(previous));
                }
                previous = rc2.getLatestEpoch();
                rc2.getClockData().get(clockId).forEach(cd -> spliced.addClockData(clockId, (ClockDataLine)cd));
            }
        }
        return spliced;
    }

    private static boolean availableInAllFiles(String clockId, Collection<RinexClock> files) {
        for (RinexClock rc : files) {
            if (rc.getClockData().containsKey(clockId)) continue;
            return false;
        }
        return true;
    }

    public static enum ClockDataType {
        AR("AR"),
        AS("AS"),
        CR("CR"),
        DR("DR"),
        MS("MS");

        private static final Map<String, ClockDataType> KEYS_MAP;
        private final String key;

        private ClockDataType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static ClockDataType parseClockDataType(String s) throws OrekitIllegalArgumentException {
            ClockDataType clockDataType = KEYS_MAP.get(s);
            if (clockDataType == null) {
                throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_CLOCK_DATA_TYPE, s);
            }
            return clockDataType;
        }

        static {
            KEYS_MAP = new HashMap<String, ClockDataType>();
            for (ClockDataType timeSystem : ClockDataType.values()) {
                KEYS_MAP.put(timeSystem.getKey(), timeSystem);
            }
        }
    }

    public static class Receiver {
        private final String designator;
        private final String receiverIdentifier;
        private final double x;
        private final double y;
        private final double z;

        public Receiver(String designator, String receiverIdentifier, double x, double y, double z) {
            this.designator = designator;
            this.receiverIdentifier = receiverIdentifier;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String getDesignator() {
            return this.designator;
        }

        public String getReceiverIdentifier() {
            return this.receiverIdentifier;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }

    public static class ReferenceClock {
        private final String referenceName;
        private final String clockID;
        private final double clockConstraint;
        private final AbsoluteDate startDate;
        private final AbsoluteDate endDate;

        public ReferenceClock(String referenceName, String clockID, double clockConstraint, AbsoluteDate startDate, AbsoluteDate endDate) {
            this.referenceName = referenceName;
            this.clockID = clockID;
            this.clockConstraint = clockConstraint;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public String getReferenceName() {
            return this.referenceName;
        }

        public String getClockID() {
            return this.clockID;
        }

        public double getClockConstraint() {
            return this.clockConstraint;
        }

        public AbsoluteDate getStartDate() {
            return this.startDate;
        }

        public AbsoluteDate getEndDate() {
            return this.endDate;
        }
    }

    public class ClockDataLine {
        private final ClockDataType dataType;
        private final String name;
        private final DateComponents dateComponents;
        private final TimeComponents timeComponents;
        private final int numberOfValues;
        private final double clockBias;
        private final double clockBiasSigma;
        private final double clockRate;
        private final double clockRateSigma;
        private final double clockAcceleration;
        private final double clockAccelerationSigma;

        public ClockDataLine(ClockDataType type, String name, DateComponents dateComponents, TimeComponents timeComponents, int numberOfValues, double clockBias, double clockBiasSigma, double clockRate, double clockRateSigma, double clockAcceleration, double clockAccelerationSigma) {
            this.dataType = type;
            this.name = name;
            this.dateComponents = dateComponents;
            this.timeComponents = timeComponents;
            this.numberOfValues = numberOfValues;
            this.clockBias = clockBias;
            this.clockBiasSigma = clockBiasSigma;
            this.clockRate = clockRate;
            this.clockRateSigma = clockRateSigma;
            this.clockAcceleration = clockAcceleration;
            this.clockAccelerationSigma = clockAccelerationSigma;
        }

        public ClockDataType getDataType() {
            return this.dataType;
        }

        public String getName() {
            return this.name;
        }

        public int getNumberOfValues() {
            return this.numberOfValues;
        }

        public AbsoluteDate getEpoch() {
            return new AbsoluteDate(this.dateComponents, this.timeComponents, RinexClock.this.timeScale);
        }

        public AbsoluteDate getEpoch(TimeScale epochTimeScale) {
            return new AbsoluteDate(this.dateComponents, this.timeComponents, epochTimeScale);
        }

        public double getClockBias() {
            return this.clockBias;
        }

        public double getClockBiasSigma() {
            return this.clockBiasSigma;
        }

        public double getClockRate() {
            return this.clockRate;
        }

        public double getClockRateSigma() {
            return this.clockRateSigma;
        }

        public double getClockAcceleration() {
            return this.clockAcceleration;
        }

        public double getClockAccelerationSigma() {
            return this.clockAccelerationSigma;
        }
    }
}

