/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ilrs.CRD;
import org.orekit.files.ilrs.ILRSHeader;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UTCScale;

public class CRDHeader
extends ILRSHeader {
    private static final String DATETIME_DELIMITER_REGEX = "[-:T]";
    private static final String SPACE = " ";
    public static final Pattern PATTERN_DATETIME_DELIMITER_REGEX = Pattern.compile("[-:T]");
    private String stationName;
    private int systemIdentifier;
    private int systemNumber;
    private int systemOccupancy;
    private int epochIdentifier;
    private String stationNetword;
    private int spacecraftEpochTimeScale;
    private int dataType;
    private int dataReleaseFlag;
    private boolean isTroposphericRefractionApplied;
    private boolean isCenterOfMassCorrectionApplied;
    private boolean isReceiveAmplitudeCorrectionApplied;
    private boolean isStationSystemDelayApplied;
    private boolean isTransponderDelayApplied;
    private RangeType rangeType;
    private int qualityIndicator;
    private int predictionType;
    private int yearOfCentury;
    private String dateAndTime;
    private String predictionProvider;

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public int getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public void setSystemIdentifier(int systemIdentifier) {
        this.systemIdentifier = systemIdentifier;
    }

    public int getSystemNumber() {
        return this.systemNumber;
    }

    public void setSystemNumber(int systemNumber) {
        this.systemNumber = systemNumber;
    }

    public int getSystemOccupancy() {
        return this.systemOccupancy;
    }

    public void setSystemOccupancy(int systemOccupancy) {
        this.systemOccupancy = systemOccupancy;
    }

    public int getEpochIdentifier() {
        return this.epochIdentifier;
    }

    public void setEpochIdentifier(int epochIdentifier) {
        this.epochIdentifier = epochIdentifier;
    }

    public String getStationNetword() {
        return this.stationNetword;
    }

    public void setStationNetword(String stationNetword) {
        this.stationNetword = stationNetword;
    }

    public int getSpacecraftEpochTimeScale() {
        return this.spacecraftEpochTimeScale;
    }

    public void setSpacecraftEpochTimeScale(int spacecraftEpochTimeScale) {
        this.spacecraftEpochTimeScale = spacecraftEpochTimeScale;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDataReleaseFlag() {
        return this.dataReleaseFlag;
    }

    public void setDataReleaseFlag(int dataReleaseFlag) {
        this.dataReleaseFlag = dataReleaseFlag;
    }

    public boolean isTroposphericRefractionApplied() {
        return this.isTroposphericRefractionApplied;
    }

    public void setIsTroposphericRefractionApplied(boolean isTroposphericRefractionApplied) {
        this.isTroposphericRefractionApplied = isTroposphericRefractionApplied;
    }

    public boolean isCenterOfMassCorrectionApplied() {
        return this.isCenterOfMassCorrectionApplied;
    }

    public void setIsCenterOfMassCorrectionApplied(boolean isCenterOfMassCorrectionApplied) {
        this.isCenterOfMassCorrectionApplied = isCenterOfMassCorrectionApplied;
    }

    public boolean isReceiveAmplitudeCorrectionApplied() {
        return this.isReceiveAmplitudeCorrectionApplied;
    }

    public void setIsReceiveAmplitudeCorrectionApplied(boolean isReceiveAmplitudeCorrectionApplied) {
        this.isReceiveAmplitudeCorrectionApplied = isReceiveAmplitudeCorrectionApplied;
    }

    public boolean isStationSystemDelayApplied() {
        return this.isStationSystemDelayApplied;
    }

    public void setIsStationSystemDelayApplied(boolean isStationSystemDelayApplied) {
        this.isStationSystemDelayApplied = isStationSystemDelayApplied;
    }

    public boolean isTransponderDelayApplied() {
        return this.isTransponderDelayApplied;
    }

    public void setIsTransponderDelayApplied(boolean isTransponderDelayApplied) {
        this.isTransponderDelayApplied = isTransponderDelayApplied;
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(int indicator) {
        this.rangeType = RangeType.getRangeType(indicator);
    }

    public int getQualityIndicator() {
        return this.qualityIndicator;
    }

    public void setQualityIndicator(int qualityIndicator) {
        this.qualityIndicator = qualityIndicator;
    }

    public int getPredictionType() {
        return this.predictionType;
    }

    public void setPredictionType(int predictionType) {
        this.predictionType = predictionType;
    }

    public int getYearOfCentury() {
        return this.yearOfCentury;
    }

    public void setYearOfCentury(int yearOfCentury) {
        this.yearOfCentury = yearOfCentury;
    }

    public String getDateAndTime() {
        return this.dateAndTime;
    }

    public void setDateAndTime(String dateAndTime) {
        this.dateAndTime = dateAndTime;
    }

    public String getPredictionProvider() {
        return this.predictionProvider;
    }

    public void setPredictionProvider(String predictionProvider) {
        this.predictionProvider = predictionProvider;
    }

    public String getH1CrdString() {
        DateComponents dc = this.getProductionEpoch();
        return String.format("H1 %3s %2d %04d %02d %02d %02d", this.getFormat(), this.getVersion(), dc.getYear(), dc.getMonth(), dc.getDay(), this.getProductionHour());
    }

    public String getH2CrdString() {
        return String.format("H2 %s %4d %02d %02d %2d %s", this.stationName, this.systemIdentifier, this.systemNumber, this.systemOccupancy, this.epochIdentifier, this.stationNetword);
    }

    public String getH3CrdString() {
        int targetLocation = this.getTargetLocation();
        return String.format("H3 %s %7s %4s %5s %1d %1d %2s", this.getName(), this.getIlrsSatelliteId(), this.getSic(), this.getNoradId(), this.getSpacecraftEpochTimeScale(), this.getTargetClass(), CRD.formatIntegerOrNaN(targetLocation, -1));
    }

    @DefaultDataContext
    public String getH4CrdString() {
        UTCScale utc = TimeScalesFactory.getUTC();
        String startEpoch = this.getStartEpoch().toStringWithoutUtcOffset(utc, 0);
        String endEpoch = this.getEndEpoch().toStringWithoutUtcOffset(utc, 0);
        return String.format("H4 %2d %s %s %d %d %d %d %d %d %d %d", this.getDataType(), PATTERN_DATETIME_DELIMITER_REGEX.matcher(startEpoch).replaceAll(SPACE), PATTERN_DATETIME_DELIMITER_REGEX.matcher(endEpoch).replaceAll(SPACE), this.dataReleaseFlag, this.isTroposphericRefractionApplied ? 1 : 0, this.isCenterOfMassCorrectionApplied ? 1 : 0, this.isReceiveAmplitudeCorrectionApplied ? 1 : 0, this.isStationSystemDelayApplied ? 1 : 0, this.isTransponderDelayApplied ? 1 : 0, this.rangeType.getIndicator(), this.qualityIndicator);
    }

    public String getH5CrdString() {
        return String.format("H5 %2d %02d %s %3s %5d", this.getPredictionType(), this.getYearOfCentury(), this.getDateAndTime(), this.getPredictionProvider(), this.getSequenceNumber());
    }

    public static enum DataType {
        FULL_RATE(0),
        NORMAL_POINT(1),
        SAMPLED_ENGIEERING(2);

        private static final Map<Integer, DataType> CODES_MAP;
        private final int indicator;

        private DataType(int indicator) {
            this.indicator = indicator;
        }

        public int getIndicator() {
            return this.indicator;
        }

        public static DataType getDataType(int id) {
            DataType type = CODES_MAP.get(id);
            if (type == null) {
                throw new RuntimeException(String.format("Invalid data type indicator {0} in CRD file header", id));
            }
            return type;
        }

        static {
            CODES_MAP = new HashMap<Integer, DataType>();
            for (DataType type : DataType.values()) {
                CODES_MAP.put(type.getIndicator(), type);
            }
        }
    }

    public static enum RangeType {
        NO_RANGES(0),
        ONE_WAY(1),
        TWO_WAY(2),
        RECEIVED_ONLY(3),
        MIXED(4);

        private static final Map<Integer, RangeType> CODES_MAP;
        private final int indicator;

        private RangeType(int indicator) {
            this.indicator = indicator;
        }

        public int getIndicator() {
            return this.indicator;
        }

        public static RangeType getRangeType(int id) {
            RangeType type = CODES_MAP.get(id);
            if (type == null) {
                throw new OrekitException((Localizable)OrekitMessages.INVALID_RANGE_INDICATOR_IN_CRD_FILE, id);
            }
            return type;
        }

        static {
            CODES_MAP = new HashMap<Integer, RangeType>();
            for (RangeType type : RangeType.values()) {
                CODES_MAP.put(type.getIndicator(), type);
            }
        }
    }
}

