/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.orekit.files.ilrs.CRD;

public class CRDConfiguration {
    private Map<String, BaseConfiguration> mapConfigurationRecords;
    private List<SystemConfiguration> systemConfigurationRecords = new ArrayList<SystemConfiguration>();

    public CRDConfiguration() {
        this.mapConfigurationRecords = new Hashtable<String, BaseConfiguration>();
    }

    public SystemConfiguration getSystemRecord() {
        return this.systemConfigurationRecords.isEmpty() ? null : this.systemConfigurationRecords.get(0);
    }

    public SystemConfiguration getLastSystemRecord() {
        return this.systemConfigurationRecords.isEmpty() ? null : this.systemConfigurationRecords.get(this.systemConfigurationRecords.size() - 1);
    }

    public LaserConfiguration getLaserRecord() {
        return this.getLaserRecord(this.getSystemRecord());
    }

    public DetectorConfiguration getDetectorRecord() {
        return this.getDetectorRecord(this.getSystemRecord());
    }

    public TimingSystemConfiguration getTimingRecord() {
        return this.getTimingRecord(this.getSystemRecord());
    }

    public TransponderConfiguration getTransponderRecord() {
        return this.getTransponderRecord(this.getSystemRecord());
    }

    public SoftwareConfiguration getSoftwareRecord() {
        return this.getSoftwareRecord(this.getSystemRecord());
    }

    public MeteorologicalConfiguration getMeteorologicalRecord() {
        return this.getMeteorologicalRecord(this.getSystemRecord());
    }

    public void addConfigurationRecord(BaseConfiguration config) {
        if (config == null) {
            return;
        }
        this.mapConfigurationRecords.put(config.getConfigurationId(), config);
        if (config instanceof SystemConfiguration) {
            this.systemConfigurationRecords.add((SystemConfiguration)config);
        }
    }

    public Map<String, BaseConfiguration> getConfigurationRecordMap() {
        return Collections.unmodifiableMap(this.mapConfigurationRecords);
    }

    public BaseConfiguration getConfigurationRecord(String configId) {
        return this.mapConfigurationRecords.get(configId);
    }

    public Set<String> getSystemConfigurationIds() {
        return Collections.unmodifiableSet(this.mapConfigurationRecords.keySet());
    }

    public List<SystemConfiguration> getSystemConfigurationRecords() {
        return Collections.unmodifiableList(this.systemConfigurationRecords);
    }

    private BaseConfiguration getRecord(SystemConfiguration systemRecord, Class<? extends BaseConfiguration> c) {
        for (String configId : systemRecord.getComponents()) {
            BaseConfiguration config = this.getConfigurationRecord(configId);
            if (config == null || config.getClass() != c) continue;
            return config;
        }
        return null;
    }

    public SystemConfiguration getSystemRecord(String configId) {
        if (configId == null) {
            return this.getSystemRecord();
        }
        BaseConfiguration config = this.mapConfigurationRecords.get(configId);
        return config == null ? null : (SystemConfiguration)config;
    }

    public LaserConfiguration getLaserRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, LaserConfiguration.class);
        return config == null ? null : (LaserConfiguration)config;
    }

    public DetectorConfiguration getDetectorRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, DetectorConfiguration.class);
        return config == null ? null : (DetectorConfiguration)config;
    }

    public TimingSystemConfiguration getTimingRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, TimingSystemConfiguration.class);
        return config == null ? null : (TimingSystemConfiguration)config;
    }

    public TransponderConfiguration getTransponderRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, TransponderConfiguration.class);
        return config == null ? null : (TransponderConfiguration)config;
    }

    public SoftwareConfiguration getSoftwareRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, SoftwareConfiguration.class);
        return config == null ? null : (SoftwareConfiguration)config;
    }

    public MeteorologicalConfiguration getMeteorologicalRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, MeteorologicalConfiguration.class);
        return config == null ? null : (MeteorologicalConfiguration)config;
    }

    public CalibrationTargetConfiguration getCalibrationTargetRecord(SystemConfiguration systemRecord) {
        BaseConfiguration config = this.getRecord(systemRecord, CalibrationTargetConfiguration.class);
        return config == null ? null : (CalibrationTargetConfiguration)config;
    }

    public CalibrationTargetConfiguration getCalibrationTargetRecord() {
        return this.getCalibrationTargetRecord(this.getSystemRecord());
    }

    public static class CalibrationTargetConfiguration
    extends BaseConfiguration {
        private String targetName;
        private double surveyedTargetDistance;
        private double surveyError;
        private double sumOfAllConstantDelays;
        private double pulseEnergy;
        private String processingSoftwareName;
        private String processingSoftwareVersion;

        public String getTargetName() {
            return this.targetName;
        }

        public void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public double getSurveyedTargetDistance() {
            return this.surveyedTargetDistance;
        }

        public void setSurveyedTargetDistance(double surveyedTargetDistance) {
            this.surveyedTargetDistance = surveyedTargetDistance;
        }

        public double getSurveyError() {
            return this.surveyError;
        }

        public void setSurveyError(double surveyError) {
            this.surveyError = surveyError;
        }

        public double getSumOfAllConstantDelays() {
            return this.sumOfAllConstantDelays;
        }

        public void setSumOfAllConstantDelays(double sumOfAllConstantDelays) {
            this.sumOfAllConstantDelays = sumOfAllConstantDelays;
        }

        public double getPulseEnergy() {
            return this.pulseEnergy;
        }

        public void setPulseEnergy(double pulseEnergy) {
            this.pulseEnergy = pulseEnergy;
        }

        public String getProcessingSoftwareName() {
            return this.processingSoftwareName;
        }

        public void setProcessingSoftwareName(String processingSoftwareName) {
            this.processingSoftwareName = processingSoftwareName;
        }

        public String getProcessingSoftwareVersion() {
            return this.processingSoftwareVersion;
        }

        public void setProcessingSoftwareVersion(String processingSoftwareVersion) {
            this.processingSoftwareVersion = processingSoftwareVersion;
        }

        @Override
        public String toCrdString() {
            return String.format("C7 0 %s", this.toString());
        }

        public String toString() {
            String str = String.format("%s %s %.5f %.2f %.4f %.2f %s %s", this.getConfigurationId(), this.targetName, this.surveyedTargetDistance, this.surveyError * 1000.0, this.sumOfAllConstantDelays, this.pulseEnergy, this.processingSoftwareName, this.processingSoftwareVersion);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class MeteorologicalConfiguration
    extends BaseConfiguration {
        private String pressSensorManufacturer;
        private String pressSensorModel;
        private String pressSensorSerialNumber;
        private String tempSensorManufacturer;
        private String tempSensorModel;
        private String tempSensorSerialNumber;
        private String humiSensorManufacturer;
        private String humiSensorModel;
        private String humiSensorSerialNumber;

        public String getMeteorologicalId() {
            return this.getConfigurationId();
        }

        public void setMeteorologicalId(String meteorologicalId) {
            this.setConfigurationId(meteorologicalId);
        }

        public String getPressSensorManufacturer() {
            return this.pressSensorManufacturer;
        }

        public void setPressSensorManufacturer(String pressSensorManufacturer) {
            this.pressSensorManufacturer = pressSensorManufacturer;
        }

        public String getPressSensorModel() {
            return this.pressSensorModel;
        }

        public void setPressSensorModel(String pressSensorModel) {
            this.pressSensorModel = pressSensorModel;
        }

        public String getPressSensorSerialNumber() {
            return this.pressSensorSerialNumber;
        }

        public void setPressSensorSerialNumber(String pressSensorSerialNumber) {
            this.pressSensorSerialNumber = pressSensorSerialNumber;
        }

        public String getTempSensorManufacturer() {
            return this.tempSensorManufacturer;
        }

        public void setTempSensorManufacturer(String tempSensorManufacturer) {
            this.tempSensorManufacturer = tempSensorManufacturer;
        }

        public String getTempSensorModel() {
            return this.tempSensorModel;
        }

        public void setTempSensorModel(String tempSensorModel) {
            this.tempSensorModel = tempSensorModel;
        }

        public String getTempSensorSerialNumber() {
            return this.tempSensorSerialNumber;
        }

        public void setTempSensorSerialNumber(String tempSensorSerialNumber) {
            this.tempSensorSerialNumber = tempSensorSerialNumber;
        }

        public String getHumiSensorManufacturer() {
            return this.humiSensorManufacturer;
        }

        public void setHumiSensorManufacturer(String humiSensorManufacturer) {
            this.humiSensorManufacturer = humiSensorManufacturer;
        }

        public String getHumiSensorModel() {
            return this.humiSensorModel;
        }

        public void setHumiSensorModel(String humiSensorModel) {
            this.humiSensorModel = humiSensorModel;
        }

        public String getHumiSensorSerialNumber() {
            return this.humiSensorSerialNumber;
        }

        public void setHumiSensorSerialNumber(String humiSensorSerialNumber) {
            this.humiSensorSerialNumber = humiSensorSerialNumber;
        }

        @Override
        public String toCrdString() {
            return String.format("C6 0 %s", this.toString());
        }

        public String toString() {
            return String.format("%s %s %s %s %s %s %s %s %s %s", this.getConfigurationId(), this.pressSensorManufacturer, this.pressSensorModel, this.pressSensorSerialNumber, this.tempSensorManufacturer, this.tempSensorModel, this.tempSensorSerialNumber, this.humiSensorManufacturer, this.humiSensorModel, this.humiSensorSerialNumber);
        }
    }

    public static class SoftwareConfiguration
    extends BaseConfiguration {
        private static final Pattern PATTERN_WHITESPACE_OR_SQUAREBRACKET = Pattern.compile("[\\s+\\[\\]]");
        private String[] trackingSoftwares;
        private String[] trackingSoftwareVersions;
        private String[] processingSoftwares;
        private String[] processingSoftwareVersions;

        public String getSoftwareId() {
            return this.getConfigurationId();
        }

        public void setSoftwareId(String softwareId) {
            this.setConfigurationId(softwareId);
        }

        public String[] getTrackingSoftwares() {
            return (String[])this.trackingSoftwares.clone();
        }

        public void setTrackingSoftwares(String[] trackingSoftwares) {
            this.trackingSoftwares = (String[])trackingSoftwares.clone();
        }

        public String[] getTrackingSoftwareVersions() {
            return (String[])this.trackingSoftwareVersions.clone();
        }

        public void setTrackingSoftwareVersions(String[] trackingSoftwareVersions) {
            this.trackingSoftwareVersions = (String[])trackingSoftwareVersions.clone();
        }

        public String[] getProcessingSoftwares() {
            return (String[])this.processingSoftwares.clone();
        }

        public void setProcessingSoftwares(String[] processingSoftwares) {
            this.processingSoftwares = (String[])processingSoftwares.clone();
        }

        public String[] getProcessingSoftwareVersions() {
            return (String[])this.processingSoftwareVersions.clone();
        }

        public void setProcessingSoftwareVersions(String[] processingSoftwareVersions) {
            this.processingSoftwareVersions = (String[])processingSoftwareVersions.clone();
        }

        private static String formatArray(String[] arr) {
            String s = Arrays.toString(arr);
            return PATTERN_WHITESPACE_OR_SQUAREBRACKET.matcher(s).replaceAll("");
        }

        @Override
        public String toCrdString() {
            return String.format("C5 0 %s", this.toString());
        }

        public String toString() {
            return String.format("%s %s %s %s %s", this.getConfigurationId(), SoftwareConfiguration.formatArray(this.trackingSoftwares), SoftwareConfiguration.formatArray(this.trackingSoftwareVersions), SoftwareConfiguration.formatArray(this.processingSoftwares), SoftwareConfiguration.formatArray(this.processingSoftwareVersions));
        }
    }

    public static class TransponderConfiguration
    extends BaseConfiguration {
        private double stationUTCOffset;
        private double stationOscDrift;
        private double transpUTCOffset;
        private double transpOscDrift;
        private double transpClkRefTime;
        private int stationClockAndDriftApplied;
        private int spacecraftClockAndDriftApplied;
        private boolean isSpacecraftTimeSimplified;

        public String getTransponderId() {
            return this.getConfigurationId();
        }

        public void setTransponderId(String transponderId) {
            this.setConfigurationId(transponderId);
        }

        public double getStationUTCOffset() {
            return this.stationUTCOffset;
        }

        public void setStationUTCOffset(double stationUTCOffset) {
            this.stationUTCOffset = stationUTCOffset;
        }

        public double getStationOscDrift() {
            return this.stationOscDrift;
        }

        public void setStationOscDrift(double stationOscDrift) {
            this.stationOscDrift = stationOscDrift;
        }

        public double getTranspUTCOffset() {
            return this.transpUTCOffset;
        }

        public void setTranspUTCOffset(double transpUTCOffset) {
            this.transpUTCOffset = transpUTCOffset;
        }

        public double getTranspOscDrift() {
            return this.transpOscDrift;
        }

        public void setTranspOscDrift(double transpOscDrift) {
            this.transpOscDrift = transpOscDrift;
        }

        public double getTranspClkRefTime() {
            return this.transpClkRefTime;
        }

        public void setTranspClkRefTime(double transpClkRefTime) {
            this.transpClkRefTime = transpClkRefTime;
        }

        public int getStationClockAndDriftApplied() {
            return this.stationClockAndDriftApplied;
        }

        public void setStationClockAndDriftApplied(int stationClockAndDriftApplied) {
            this.stationClockAndDriftApplied = stationClockAndDriftApplied;
        }

        public int getSpacecraftClockAndDriftApplied() {
            return this.spacecraftClockAndDriftApplied;
        }

        public void setSpacecraftClockAndDriftApplied(int spacecraftClockAndDriftApplied) {
            this.spacecraftClockAndDriftApplied = spacecraftClockAndDriftApplied;
        }

        public boolean isSpacecraftTimeSimplified() {
            return this.isSpacecraftTimeSimplified;
        }

        public void setIsSpacecraftTimeSimplified(boolean isSpacecraftTimeSimplified) {
            this.isSpacecraftTimeSimplified = isSpacecraftTimeSimplified;
        }

        @Override
        public String toCrdString() {
            return String.format("C4 0 %s", this.toString());
        }

        public String toString() {
            String str = String.format("%s %.3f %.2f %.3f %.2f %.12f %d %d %d", this.getConfigurationId(), this.stationUTCOffset * 1.0E9, this.stationOscDrift, this.transpUTCOffset * 1.0E9, this.transpOscDrift, this.transpClkRefTime, this.stationClockAndDriftApplied, this.spacecraftClockAndDriftApplied, this.isSpacecraftTimeSimplified ? 1 : 0);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class TimingSystemConfiguration
    extends BaseConfiguration {
        private String timeSource;
        private String frequencySource;
        private String timer;
        private String timerSerialNumber;
        private double epochDelayCorrection;

        public String getTimeSource() {
            return this.timeSource;
        }

        public String getLocalTimingId() {
            return this.getConfigurationId();
        }

        public void setLocalTimingId(String localTimingId) {
            this.setConfigurationId(localTimingId);
        }

        public void setTimeSource(String timeSource) {
            this.timeSource = timeSource;
        }

        public String getFrequencySource() {
            return this.frequencySource;
        }

        public void setFrequencySource(String frequencySource) {
            this.frequencySource = frequencySource;
        }

        public String getTimer() {
            return this.timer;
        }

        public void setTimer(String timer) {
            this.timer = timer;
        }

        public String getTimerSerialNumber() {
            return this.timerSerialNumber;
        }

        public void setTimerSerialNumber(String timerSerialNumber) {
            this.timerSerialNumber = timerSerialNumber;
        }

        public double getEpochDelayCorrection() {
            return this.epochDelayCorrection;
        }

        public void setEpochDelayCorrection(double epochDelayCorrection) {
            this.epochDelayCorrection = epochDelayCorrection;
        }

        @Override
        public String toCrdString() {
            return String.format("C3 0 %s", this.toString());
        }

        public String toString() {
            String str = String.format("%s %s %s %s %s %.1f", this.getConfigurationId(), this.timeSource, this.frequencySource, this.timer, this.timerSerialNumber, this.epochDelayCorrection * 1000000.0);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class DetectorConfiguration
    extends BaseConfiguration {
        private String detectorType;
        private double applicableWavelength;
        private double quantumEfficiency;
        private double appliedVoltage;
        private double darkCount;
        private String outputPulseType;
        private double outputPulseWidth;
        private double spectralFilter;
        private double transmissionOfSpectralFilter;
        private double spatialFilter;
        private String externalSignalProcessing;
        private double amplifierGain;
        private double amplifierBandwidth;
        private String amplifierInUse;

        public String getDetectorId() {
            return this.getConfigurationId();
        }

        public void setDetectorId(String detectorId) {
            this.setConfigurationId(detectorId);
        }

        public String getDetectorType() {
            return this.detectorType;
        }

        public void setDetectorType(String detectorType) {
            this.detectorType = detectorType;
        }

        public double getApplicableWavelength() {
            return this.applicableWavelength;
        }

        public void setApplicableWavelength(double applicableWavelength) {
            this.applicableWavelength = applicableWavelength;
        }

        public double getQuantumEfficiency() {
            return this.quantumEfficiency;
        }

        public void setQuantumEfficiency(double quantumEfficiency) {
            this.quantumEfficiency = quantumEfficiency == -1.0 ? Double.NaN : quantumEfficiency;
        }

        public double getAppliedVoltage() {
            return this.appliedVoltage;
        }

        public void setAppliedVoltage(double appliedVoltage) {
            this.appliedVoltage = appliedVoltage == -1.0 ? Double.NaN : appliedVoltage;
        }

        public double getDarkCount() {
            return this.darkCount;
        }

        public void setDarkCount(double darkCount) {
            this.darkCount = darkCount == -1000.0 ? Double.NaN : darkCount;
        }

        public String getOutputPulseType() {
            return this.outputPulseType;
        }

        public void setOutputPulseType(String outputPulseType) {
            this.outputPulseType = outputPulseType;
        }

        public double getOutputPulseWidth() {
            return this.outputPulseWidth;
        }

        public void setOutputPulseWidth(double outputPulseWidth) {
            this.outputPulseWidth = outputPulseWidth == -1.0 ? Double.NaN : outputPulseWidth;
        }

        public double getSpectralFilter() {
            return this.spectralFilter;
        }

        public void setSpectralFilter(double spectralFilter) {
            this.spectralFilter = spectralFilter;
        }

        public double getTransmissionOfSpectralFilter() {
            return this.transmissionOfSpectralFilter;
        }

        public void setTransmissionOfSpectralFilter(double transmissionOfSpectralFilter) {
            this.transmissionOfSpectralFilter = transmissionOfSpectralFilter;
        }

        public double getSpatialFilter() {
            return this.spatialFilter;
        }

        public void setSpatialFilter(double spatialFilter) {
            this.spatialFilter = spatialFilter;
        }

        public String getExternalSignalProcessing() {
            return this.externalSignalProcessing;
        }

        public void setExternalSignalProcessing(String externalSignalProcessing) {
            this.externalSignalProcessing = externalSignalProcessing;
        }

        public double getAmplifierGain() {
            return this.amplifierGain;
        }

        public void setAmplifierGain(double amplifierGain) {
            this.amplifierGain = amplifierGain;
        }

        public double getAmplifierBandwidth() {
            return this.amplifierBandwidth;
        }

        public void setAmplifierBandwidth(double amplifierBandwidth) {
            this.amplifierBandwidth = amplifierBandwidth;
        }

        public String getAmplifierInUse() {
            return this.amplifierInUse;
        }

        public void setAmplifierInUse(String amplifierInUse) {
            this.amplifierInUse = amplifierInUse;
        }

        @Override
        public String toCrdString() {
            return String.format("C2 0 %s", this.toString());
        }

        public String toString() {
            String str = String.format("%s %s %.3f %.2f %.1f %.1f %s %.1f %.2f %.1f %.1f %s %.1f %.1f %s", this.getConfigurationId(), this.detectorType, this.applicableWavelength * 1.0E9, this.quantumEfficiency, this.appliedVoltage, this.darkCount * 0.001, this.outputPulseType, this.outputPulseWidth, this.spectralFilter * 1.0E9, this.transmissionOfSpectralFilter, this.spatialFilter, this.externalSignalProcessing, this.amplifierGain, this.amplifierBandwidth * 0.001, this.amplifierInUse);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class LaserConfiguration
    extends BaseConfiguration {
        private String laserType;
        private double primaryWavelength;
        private double nominalFireRate;
        private double pulseEnergy;
        private double pulseWidth;
        private double beamDivergence;
        private int pulseInOutgoingSemiTrain;

        public String getLaserId() {
            return this.getConfigurationId();
        }

        public void setLaserId(String laserId) {
            this.setConfigurationId(laserId);
        }

        public String getLaserType() {
            return this.laserType;
        }

        public void setLaserType(String laserType) {
            this.laserType = laserType;
        }

        public double getPrimaryWavelength() {
            return this.primaryWavelength;
        }

        public void setPrimaryWavelength(double primaryWavelength) {
            this.primaryWavelength = primaryWavelength;
        }

        public double getNominalFireRate() {
            return this.nominalFireRate;
        }

        public void setNominalFireRate(double nominalFireRate) {
            this.nominalFireRate = nominalFireRate;
        }

        public double getPulseEnergy() {
            return this.pulseEnergy;
        }

        public void setPulseEnergy(double pulseEnergy) {
            this.pulseEnergy = pulseEnergy;
        }

        public double getPulseWidth() {
            return this.pulseWidth;
        }

        public void setPulseWidth(double pulseWidth) {
            this.pulseWidth = pulseWidth;
        }

        public double getBeamDivergence() {
            return this.beamDivergence;
        }

        public void setBeamDivergence(double beamDivergence) {
            this.beamDivergence = beamDivergence;
        }

        public int getPulseInOutgoingSemiTrain() {
            return this.pulseInOutgoingSemiTrain;
        }

        public void setPulseInOutgoingSemiTrain(int pulseInOutgoingSemiTrain) {
            this.pulseInOutgoingSemiTrain = pulseInOutgoingSemiTrain;
        }

        @Override
        public String toCrdString() {
            return String.format("C1 0 %s", this.toString());
        }

        public String toString() {
            String str = String.format("%s %s %.2f %.2f %.2f %.1f %.2f %d", this.getConfigurationId(), this.laserType, this.primaryWavelength * 1.0E9, this.nominalFireRate, this.pulseEnergy, this.pulseWidth, this.beamDivergence, this.pulseInOutgoingSemiTrain);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class SystemConfiguration
    extends BaseConfiguration {
        private double wavelength;
        private List<String> components = new ArrayList<String>();

        public double getWavelength() {
            return this.wavelength;
        }

        public void setWavelength(double wavelength) {
            this.wavelength = wavelength;
        }

        public String getSystemId() {
            return this.getConfigurationId();
        }

        public void setSystemId(String systemId) {
            this.setConfigurationId(systemId);
        }

        public List<String> getComponents() {
            return Collections.unmodifiableList(this.components);
        }

        public void setComponents(String[] components) {
            this.components = Arrays.asList(components);
        }

        @Override
        public String toCrdString() {
            return String.format("C0 0 %s", this.toString());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%10.3f %s", this.wavelength * 1.0E9, this.getConfigurationId()));
            for (String comp : this.components) {
                sb.append(String.format(" %s", comp));
            }
            return sb.toString().replace(',', '.');
        }
    }

    public static abstract class BaseConfiguration {
        private String configurationId;

        public String getConfigurationId() {
            return this.configurationId;
        }

        public void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object record) {
            if (record == null) {
                return false;
            }
            if (record == this) {
                return true;
            }
            return this.toString().equals(record.toString());
        }

        public abstract String toCrdString();
    }
}

