/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.files.ilrs.CRDConfiguration;
import org.orekit.files.ilrs.CRDHeader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ImmutableTimeStampedCache;

public class CRD {
    public static final String STR_VALUE_NOT_AVAILABLE = "na";
    public static final String STR_NAN = "NaN";
    public static final Pattern PATTERN_NAN = Pattern.compile("NaN");
    private List<String> comments = new ArrayList<String>();
    private List<CRDDataBlock> dataBlocks = new ArrayList<CRDDataBlock>();

    public static String formatIntegerOrNaN(int value, int valueNotAvailable) {
        return value == valueNotAvailable ? STR_VALUE_NOT_AVAILABLE : String.format("%d", value);
    }

    public static String handleNaN(String crdString) {
        return PATTERN_NAN.matcher(crdString).replaceAll(STR_VALUE_NOT_AVAILABLE);
    }

    public void addDataBlock(CRDDataBlock dataBlock) {
        this.dataBlocks.add(dataBlock);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<CRDDataBlock> getDataBlocks() {
        return Collections.unmodifiableList(this.dataBlocks);
    }

    public static class SessionStatistics {
        private final String systemConfigurationId;
        private final double rms;
        private final double skewness;
        private final double kurtosis;
        private final double peakMinusMean;
        private final int dataQulityIndicator;

        public SessionStatistics(String systemConfigurationId, double rms, double skewness, double kurtosis, double peakMinusMean, int dataQulityIndicator) {
            this.systemConfigurationId = systemConfigurationId;
            this.rms = rms;
            this.skewness = skewness;
            this.kurtosis = kurtosis;
            this.peakMinusMean = peakMinusMean;
            this.dataQulityIndicator = dataQulityIndicator;
        }

        public String getSystemConfigurationId() {
            return this.systemConfigurationId;
        }

        public double getRms() {
            return this.rms;
        }

        public double getSkewness() {
            return this.skewness;
        }

        public double getKurtosis() {
            return this.kurtosis;
        }

        public double getPeakMinusMean() {
            return this.peakMinusMean;
        }

        public int getDataQulityIndicator() {
            return this.dataQulityIndicator;
        }

        public String toCrdString() {
            return String.format("50 %s", this.toString());
        }

        public String toString() {
            String str = String.format("%4s %6.1f %7.3f %7.3f %6.1f %1d", this.systemConfigurationId, this.rms * 1.0E12, this.skewness, this.kurtosis, this.peakMinusMean * 1.0E12, this.dataQulityIndicator);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class CalibrationDetail
    extends Calibration {
        public CalibrationDetail(AbsoluteDate date, int typeOfData, String systemConfigurationId, int numberOfPointsRecorded, int numberOfPointsUsed, double oneWayDistance, double systemDelay, double delayShift, double rms, double skew, double kurtosis, double peakMinusMean, int typeIndicator, int shiftTypeIndicator, int detectorChannel, int span, double returnRate) {
            super(date, typeOfData, systemConfigurationId, numberOfPointsRecorded, numberOfPointsUsed, oneWayDistance, systemDelay, delayShift, rms, skew, kurtosis, peakMinusMean, typeIndicator, shiftTypeIndicator, detectorChannel, span, returnRate);
        }

        @Override
        @DefaultDataContext
        public String toCrdString() {
            return String.format("41 %s", this.toString());
        }
    }

    public static class Calibration
    implements TimeStamped {
        private final AbsoluteDate date;
        private final int typeOfData;
        private final String systemConfigurationId;
        private final int numberOfPointsRecorded;
        private final int numberOfPointsUsed;
        private final double oneWayDistance;
        private final double systemDelay;
        private final double delayShift;
        private final double rms;
        private final double skew;
        private final double kurtosis;
        private final double peakMinusMean;
        private final int typeIndicator;
        private final int shiftTypeIndicator;
        private final int detectorChannel;
        private final int span;
        private final double returnRate;

        public Calibration(AbsoluteDate date, int typeOfData, String systemConfigurationId, int numberOfPointsRecorded, int numberOfPointsUsed, double oneWayDistance, double systemDelay, double delayShift, double rms, double skew, double kurtosis, double peakMinusMean, int typeIndicator, int shiftTypeIndicator, int detectorChannel, int span, double returnRate) {
            this.date = date;
            this.typeOfData = typeOfData;
            this.systemConfigurationId = systemConfigurationId;
            this.numberOfPointsRecorded = numberOfPointsRecorded;
            this.numberOfPointsUsed = numberOfPointsUsed;
            this.systemDelay = systemDelay;
            this.delayShift = delayShift;
            this.rms = rms;
            this.skew = skew;
            this.kurtosis = kurtosis;
            this.peakMinusMean = peakMinusMean;
            this.typeIndicator = typeIndicator;
            this.shiftTypeIndicator = shiftTypeIndicator;
            this.detectorChannel = detectorChannel;
            this.span = span;
            this.returnRate = returnRate;
            this.oneWayDistance = oneWayDistance == -1.0 ? Double.NaN : oneWayDistance;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public int getTypeOfData() {
            return this.typeOfData;
        }

        public String getSystemConfigurationId() {
            return this.systemConfigurationId;
        }

        public int getNumberOfPointsRecorded() {
            return this.numberOfPointsRecorded;
        }

        public int getNumberOfPointsUsed() {
            return this.numberOfPointsUsed;
        }

        public double getOneWayDistance() {
            return this.oneWayDistance;
        }

        public double getSystemDelay() {
            return this.systemDelay;
        }

        public double getDelayShift() {
            return this.delayShift;
        }

        public double getRms() {
            return this.rms;
        }

        public double getSkew() {
            return this.skew;
        }

        public double getKurtosis() {
            return this.kurtosis;
        }

        public double getPeakMinusMean() {
            return this.peakMinusMean;
        }

        public int getTypeIndicator() {
            return this.typeIndicator;
        }

        public int getShiftTypeIndicator() {
            return this.shiftTypeIndicator;
        }

        public int getDetectorChannel() {
            return this.detectorChannel;
        }

        public int getSpan() {
            return this.span;
        }

        public double getReturnRate() {
            return this.returnRate;
        }

        @DefaultDataContext
        public String toCrdString() {
            return String.format("40 %s", this.toString());
        }

        @DefaultDataContext
        public String toString() {
            double sod = this.getDate().getComponents(TimeScalesFactory.getUTC()).getTime().getSecondsInLocalDay();
            String str = String.format("%18.12f %1d %4s %8s %8s %8.4f %10.1f %8.1f %6.1f %7.3f %7.3f %6.1f %1d %1d %1d %1d %5.1f", sod, this.typeOfData, this.systemConfigurationId, CRD.formatIntegerOrNaN(this.numberOfPointsRecorded, -1), CRD.formatIntegerOrNaN(this.numberOfPointsUsed, -1), this.oneWayDistance, this.systemDelay * 1.0E12, this.delayShift * 1.0E12, this.rms * 1.0E12, this.skew, this.kurtosis, this.peakMinusMean * 1.0E12, this.typeIndicator, this.shiftTypeIndicator, this.detectorChannel, this.span, this.returnRate);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class Meteo {
        private static final int N_NEIGHBORS = 2;
        private final AbsoluteDate firstDate;
        private final AbsoluteDate lastDate;
        private transient MeteorologicalMeasurement previousParam;
        private transient MeteorologicalMeasurement nextParam;
        private final transient ImmutableTimeStampedCache<MeteorologicalMeasurement> meteo;

        public Meteo(SortedSet<MeteorologicalMeasurement> meteoData) {
            int neighborsSize;
            int n = neighborsSize = meteoData.size() < 2 ? meteoData.size() : 2;
            if (neighborsSize == 0) {
                this.meteo = ImmutableTimeStampedCache.emptyCache();
                this.firstDate = null;
                this.lastDate = null;
            } else {
                this.meteo = new ImmutableTimeStampedCache<MeteorologicalMeasurement>(neighborsSize, meteoData);
                this.firstDate = meteoData.first().getDate();
                this.lastDate = meteoData.last().getDate();
            }
        }

        public List<MeteorologicalMeasurement> getData() {
            return this.meteo.getAll();
        }

        public MeteorologicalMeasurement getMeteo(AbsoluteDate date) {
            if (this.meteo.getMaxNeighborsSize() == 0) {
                return null;
            }
            this.bracketDate(date);
            if (date.durationFrom(this.firstDate) <= 0.0 || date.durationFrom(this.lastDate) > 0.0) {
                return this.previousParam;
            }
            double pressure = this.getLinearInterpolation(date, this.previousParam.getPressure(), this.nextParam.getPressure());
            double temperature = this.getLinearInterpolation(date, this.previousParam.getTemperature(), this.nextParam.getTemperature());
            double humidity = this.getLinearInterpolation(date, this.previousParam.getHumidity(), this.nextParam.getHumidity());
            return new MeteorologicalMeasurement(date, pressure, temperature, humidity);
        }

        private void bracketDate(AbsoluteDate date) {
            if (this.previousParam != null && date.durationFrom(this.previousParam.getDate()) > 0.0 && date.durationFrom(this.nextParam.getDate()) <= 0.0) {
                return;
            }
            if (date.durationFrom(this.firstDate) <= 0.0) {
                this.nextParam = this.previousParam = this.meteo.getEarliest();
            } else if (date.durationFrom(this.lastDate) > 0.0) {
                this.nextParam = this.previousParam = this.meteo.getLatest();
            } else {
                List neighbors = this.meteo.getNeighbors(date).collect(Collectors.toList());
                this.previousParam = (MeteorologicalMeasurement)neighbors.get(0);
                this.nextParam = (MeteorologicalMeasurement)neighbors.get(1);
            }
        }

        private double getLinearInterpolation(AbsoluteDate date, double previousValue, double nextValue) {
            AbsoluteDate previousDate = this.previousParam.getDate();
            AbsoluteDate currentDate = this.nextParam.getDate();
            double dt = currentDate.durationFrom(previousDate);
            double previousWeight = currentDate.durationFrom(date) / dt;
            double nextWeight = date.durationFrom(previousDate) / dt;
            return previousValue * previousWeight + nextValue * nextWeight;
        }
    }

    public static class AnglesMeasurement
    implements TimeStamped {
        private AbsoluteDate date;
        private final double azimuth;
        private final double elevation;
        private final int directionFlag;
        private final int originIndicator;
        private final boolean refractionCorrected;
        private final double azimuthRate;
        private final double elevationRate;

        public AnglesMeasurement(AbsoluteDate date, double azimuth, double elevation, int directionFlag, int originIndicator, boolean refractionCorrected, double azimuthRate, double elevationRate) {
            this.date = date;
            this.azimuth = azimuth;
            this.elevation = elevation;
            this.directionFlag = directionFlag;
            this.originIndicator = originIndicator;
            this.refractionCorrected = refractionCorrected;
            this.azimuthRate = azimuthRate;
            this.elevationRate = elevationRate;
        }

        public double getAzimuth() {
            return this.azimuth;
        }

        public double getElevation() {
            return this.elevation;
        }

        public int getDirectionFlag() {
            return this.directionFlag;
        }

        public int getOriginIndicator() {
            return this.originIndicator;
        }

        public boolean isRefractionCorrected() {
            return this.refractionCorrected;
        }

        public double getAzimuthRate() {
            return this.azimuthRate;
        }

        public double getElevationRate() {
            return this.elevationRate;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        @DefaultDataContext
        public String toCrdString() {
            return String.format("30 %s", this.toString());
        }

        @DefaultDataContext
        public String toString() {
            double sod = this.getDate().getComponents(TimeScalesFactory.getUTC()).getTime().getSecondsInLocalDay();
            String str = String.format("%9.3f %8.4f %8.4f %1d %1d %1d %10.7f %10.7f", sod, FastMath.toDegrees((double)this.azimuth), FastMath.toDegrees((double)this.elevation), this.directionFlag, this.originIndicator, this.refractionCorrected ? 1 : 0, FastMath.toDegrees((double)this.azimuthRate), FastMath.toDegrees((double)this.elevationRate));
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class MeteorologicalMeasurement
    implements TimeStamped {
        private AbsoluteDate date;
        private final double pressure;
        private final double temperature;
        private final double humidity;
        private final int originOfValues;

        public MeteorologicalMeasurement(AbsoluteDate date, double pressure, double temperature, double humidity) {
            this(date, pressure, temperature, humidity, 0);
        }

        public MeteorologicalMeasurement(AbsoluteDate date, double pressure, double temperature, double humidity, int originOfValues) {
            this.date = date;
            this.pressure = pressure;
            this.temperature = temperature;
            this.humidity = humidity;
            this.originOfValues = originOfValues;
        }

        public double getPressure() {
            return this.pressure;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public double getHumidity() {
            return this.humidity;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public int getOriginOfValues() {
            return this.originOfValues;
        }

        @DefaultDataContext
        public String toCrdString() {
            return String.format("20 %s", this.toString());
        }

        @DefaultDataContext
        public String toString() {
            double sod = this.getDate().getComponents(TimeScalesFactory.getUTC()).getTime().getSecondsInLocalDay();
            String str = String.format("%9.3f %7.2f %6.2f %4.0f %1d", sod, this.pressure * 1000.0, this.temperature, this.humidity, this.originOfValues);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class RangeSupplement
    implements TimeStamped {
        private AbsoluteDate date;
        private final String systemConfigurationId;
        private final double troposphericRefractionCorrection;
        private final double centerOfMassCorrection;
        private final double ndFilterValue;
        private final double timeBiasApplied;
        private final double rangeRate;

        public RangeSupplement(AbsoluteDate date, String systemConfigurationId, double troposphericRefractionCorrection, double centerOfMassCorrection, double ndFilterValue, double timeBiasApplied, double rangeRate) {
            this.date = date;
            this.systemConfigurationId = systemConfigurationId;
            this.troposphericRefractionCorrection = troposphericRefractionCorrection;
            this.centerOfMassCorrection = centerOfMassCorrection;
            this.ndFilterValue = ndFilterValue;
            this.timeBiasApplied = timeBiasApplied;
            this.rangeRate = rangeRate;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public String getSystemConfigurationId() {
            return this.systemConfigurationId;
        }

        public double getTroposphericRefractionCorrection() {
            return this.troposphericRefractionCorrection;
        }

        public double getCenterOfMassCorrection() {
            return this.centerOfMassCorrection;
        }

        public double getNdFilterValue() {
            return this.ndFilterValue;
        }

        public double getTimeBiasApplied() {
            return this.timeBiasApplied;
        }

        public double getRangeRate() {
            return this.rangeRate;
        }

        @DefaultDataContext
        public String toCrdString() {
            return String.format("12 %s", this.toString());
        }

        @DefaultDataContext
        public String toString() {
            double sod = this.getDate().getComponents(TimeScalesFactory.getUTC()).getTime().getSecondsInLocalDay();
            String str = String.format("%18.12f %4s %6.1f %6.4f %5.2f %8.4f %f", sod, this.getSystemConfigurationId(), this.troposphericRefractionCorrection * 1.0E12, this.centerOfMassCorrection, this.ndFilterValue, this.timeBiasApplied, this.rangeRate);
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class NptRangeMeasurement
    extends RangeMeasurement {
        private final double windowLength;
        private final int numberOfRawRanges;
        private final double binRms;
        private final double binSkew;
        private final double binKurtosis;
        private final double binPeakMinusMean;
        private final double returnRate;
        private final int detectorChannel;

        public NptRangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent, double snr, String systemConfigurationId) {
            this(date, timeOfFlight, epochEvent, snr, systemConfigurationId, -1.0, -1, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0);
        }

        public NptRangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent, double snr, String systemConfigurationId, double windowLength, int numberOfRawRanges, double binRms, double binSkew, double binKurtosis, double binPeakMinusMean, double returnRate, int detectorChannel) {
            super(date, timeOfFlight, epochEvent, snr, systemConfigurationId);
            this.windowLength = windowLength;
            this.numberOfRawRanges = numberOfRawRanges;
            this.binSkew = binSkew;
            this.binKurtosis = binKurtosis;
            this.binPeakMinusMean = binPeakMinusMean;
            this.detectorChannel = detectorChannel;
            this.binRms = binRms == -1.0E-12 ? Double.NaN : binRms;
            this.returnRate = returnRate == -1.0 ? Double.NaN : returnRate;
        }

        public double getWindowLength() {
            return this.windowLength;
        }

        public int getNumberOfRawRanges() {
            return this.numberOfRawRanges;
        }

        public double getBinRms() {
            return this.binRms;
        }

        public double getBinSkew() {
            return this.binSkew;
        }

        public double getBinKurtosis() {
            return this.binKurtosis;
        }

        public double getBinPeakMinusMean() {
            return this.binPeakMinusMean;
        }

        public double getReturnRate() {
            return this.returnRate;
        }

        public int getDetectorChannel() {
            return this.detectorChannel;
        }

        @Override
        @DefaultDataContext
        public String toCrdString() {
            return String.format("11 %s", this.toString());
        }

        @DefaultDataContext
        public String toString() {
            double sod = this.getDate().getComponents(TimeScalesFactory.getUTC()).getTime().getSecondsInLocalDay();
            String str = String.format("%18.12f %18.12f %4s %1d %6.1f %6d %9.1f %7.3f %7.3f %9.1f %5.2f %1d %5.1f", sod, this.getTimeOfFlight(), this.getSystemConfigurationId(), this.getEpochEvent(), this.windowLength, this.numberOfRawRanges, this.binRms * 1.0E12, this.binSkew, this.binKurtosis, this.binPeakMinusMean * 1.0E12, this.returnRate, this.detectorChannel, this.getSnr());
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class FrRangeMeasurement
    extends RangeMeasurement {
        private final int filterFlag;
        private final int detectorChannel;
        private final int stopNumber;
        private final int receiveAmplitude;
        private final int transmitAmplitude;

        public FrRangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent, String systemConfigurationId, int filterFlag, int detectorChannel, int stopNumber, int receiveAmplitude, int transmitAmplitude) {
            super(date, timeOfFlight, epochEvent, Double.NaN, systemConfigurationId);
            this.filterFlag = filterFlag;
            this.detectorChannel = detectorChannel;
            this.stopNumber = stopNumber;
            this.receiveAmplitude = receiveAmplitude;
            this.transmitAmplitude = transmitAmplitude;
        }

        public int getFilterFlag() {
            return this.filterFlag;
        }

        public int getDetectorChannel() {
            return this.detectorChannel;
        }

        public int getStopNumber() {
            return this.stopNumber;
        }

        public int getReceiveAmplitude() {
            return this.receiveAmplitude;
        }

        public int getTransmitAmplitude() {
            return this.transmitAmplitude;
        }

        @Override
        @DefaultDataContext
        public String toCrdString() {
            return String.format("10 %s", this.toString());
        }

        @DefaultDataContext
        public String toString() {
            double sod = this.getDate().getComponents(TimeScalesFactory.getUTC()).getTime().getSecondsInLocalDay();
            String str = String.format("%18.12f %18.12f %4s %1d %1d %1d %1d %5s %5s", sod, this.getTimeOfFlight(), this.getSystemConfigurationId(), this.getEpochEvent(), this.filterFlag, this.detectorChannel, this.stopNumber, CRD.formatIntegerOrNaN(this.receiveAmplitude, -1), CRD.formatIntegerOrNaN(this.transmitAmplitude, -1));
            return CRD.handleNaN(str).replace(',', '.');
        }
    }

    public static class RangeMeasurement
    implements TimeStamped {
        private AbsoluteDate date;
        private final double timeOfFlight;
        private final String systemConfigurationId;
        private final int epochEvent;
        private final double snr;

        public RangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent) {
            this(date, timeOfFlight, epochEvent, Double.NaN);
        }

        public RangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent, double snr) {
            this(date, timeOfFlight, epochEvent, snr, null);
        }

        public RangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent, double snr, String systemConfigurationId) {
            this.date = date;
            this.timeOfFlight = timeOfFlight;
            this.epochEvent = epochEvent;
            this.snr = snr;
            this.systemConfigurationId = systemConfigurationId;
        }

        public double getTimeOfFlight() {
            return this.timeOfFlight;
        }

        public int getEpochEvent() {
            return this.epochEvent;
        }

        public double getSnr() {
            return this.snr;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public String getSystemConfigurationId() {
            return this.systemConfigurationId;
        }

        public String toCrdString() {
            return "00 not supported. use NptRangeMeasurement or FrRangeMeasurement instead.";
        }
    }

    public static class CRDDataBlock {
        private CRDHeader header;
        private CRDConfiguration configurationRecords;
        private List<RangeMeasurement> rangeData = new ArrayList<RangeMeasurement>();
        private final SortedSet<MeteorologicalMeasurement> meteoData = new TreeSet<TimeStamped>(new ChronologicalComparator());
        private List<AnglesMeasurement> anglesData = new ArrayList<AnglesMeasurement>();
        private List<RangeSupplement> rangeSupplementData = new ArrayList<RangeSupplement>();
        private List<SessionStatistics> sessionStatisticsData = new ArrayList<SessionStatistics>();
        private List<Calibration> calibrationData = new ArrayList<Calibration>();
        private List<CalibrationDetail> calibrationDetailData = new ArrayList<CalibrationDetail>();

        public CRDHeader getHeader() {
            return this.header;
        }

        public void setHeader(CRDHeader header) {
            this.header = header;
        }

        public CRDConfiguration getConfigurationRecords() {
            return this.configurationRecords;
        }

        public void setConfigurationRecords(CRDConfiguration configurationRecords) {
            this.configurationRecords = configurationRecords;
        }

        public void addRangeData(RangeMeasurement range) {
            this.rangeData.add(range);
        }

        public void addMeteoData(MeteorologicalMeasurement meteorologicalMeasurement) {
            this.meteoData.add(meteorologicalMeasurement);
        }

        public void addAnglesData(AnglesMeasurement angles) {
            this.anglesData.add(angles);
        }

        public List<RangeMeasurement> getRangeData() {
            return Collections.unmodifiableList(this.rangeData);
        }

        public List<AnglesMeasurement> getAnglesData() {
            return Collections.unmodifiableList(this.anglesData);
        }

        public Meteo getMeteoData() {
            return new Meteo(this.meteoData);
        }

        public void addRangeSupplementData(RangeSupplement rangeSupplement) {
            this.rangeSupplementData.add(rangeSupplement);
        }

        public List<RangeSupplement> getRangeSupplementData() {
            return Collections.unmodifiableList(this.rangeSupplementData);
        }

        public void addSessionStatisticsData(SessionStatistics sessionStatistics) {
            this.sessionStatisticsData.add(sessionStatistics);
        }

        public List<SessionStatistics> getSessionStatisticsData() {
            return Collections.unmodifiableList(this.sessionStatisticsData);
        }

        public SessionStatistics getSessionStatisticsRecord() {
            return this.getSessionStatisticsRecord(null);
        }

        public SessionStatistics getSessionStatisticsRecord(String systemConfigurationId) {
            if (this.sessionStatisticsData.isEmpty()) {
                return null;
            }
            if (systemConfigurationId == null) {
                return this.sessionStatisticsData.get(0);
            }
            for (SessionStatistics sessionStatistics : this.sessionStatisticsData) {
                if (!systemConfigurationId.equalsIgnoreCase(sessionStatistics.getSystemConfigurationId())) continue;
                return sessionStatistics;
            }
            return null;
        }

        public void addCalibrationData(Calibration cal) {
            this.calibrationData.add(cal);
        }

        public List<Calibration> getCalibrationData() {
            return Collections.unmodifiableList(this.calibrationData);
        }

        public List<Calibration> getCalibrationRecords() {
            return this.getCalibrationRecords(null);
        }

        public List<Calibration> getCalibrationRecords(String systemConfigurationId) {
            if (this.calibrationData.isEmpty()) {
                return null;
            }
            String systemConfigId = systemConfigurationId == null ? this.getConfigurationRecords().getSystemRecord().getConfigurationId() : systemConfigurationId;
            ArrayList<Calibration> list = new ArrayList<Calibration>();
            for (Calibration calibration : this.calibrationData) {
                if (!systemConfigId.equalsIgnoreCase(calibration.getSystemConfigurationId())) continue;
                list.add(calibration);
            }
            return list;
        }

        public void addCalibrationDetailData(CalibrationDetail cal) {
            this.calibrationDetailData.add(cal);
        }

        public List<CalibrationDetail> getCalibrationDetailData() {
            return Collections.unmodifiableList(this.calibrationDetailData);
        }

        public List<CalibrationDetail> getCalibrationDetailRecords() {
            return this.getCalibrationDetailRecords(null);
        }

        public List<CalibrationDetail> getCalibrationDetailRecords(String systemConfigurationId) {
            if (this.calibrationDetailData.isEmpty()) {
                return null;
            }
            String systemConfigId = systemConfigurationId == null ? this.getConfigurationRecords().getSystemRecord().getConfigurationId() : systemConfigurationId;
            ArrayList<CalibrationDetail> list = new ArrayList<CalibrationDetail>();
            for (CalibrationDetail calibration : this.calibrationDetailData) {
                if (!systemConfigId.equalsIgnoreCase(calibration.getSystemConfigurationId())) continue;
                list.add(calibration);
            }
            return list;
        }

        public double getWavelength(RangeMeasurement range) {
            return this.getConfigurationRecords().getSystemRecord(range.getSystemConfigurationId()).getWavelength();
        }
    }
}

