/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFileParser;
import org.orekit.files.ilrs.CPF;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.IERSConventions;

public class CPFParser
implements EphemerisFileParser<CPF> {
    private static final String FILE_FORMAT = "CPF";
    private static final double MS_TO_S = 1.0E-6;
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final int DEFAULT_INTERPOLATION_SAMPLE = 10;
    private final double mu;
    private final TimeScale timeScale;
    private final Frames frames;
    private final int interpolationSample;
    private final IERSConventions iersConvention;

    @DefaultDataContext
    public CPFParser() {
        this(3.986004415E14, 10, IERSConventions.IERS_2010, DataContext.getDefault().getTimeScales().getUTC(), DataContext.getDefault().getFrames());
    }

    public CPFParser(double mu, int interpolationSamples, IERSConventions iersConventions, TimeScale utc, Frames frames) {
        this.mu = mu;
        this.interpolationSample = interpolationSamples;
        this.iersConvention = iersConventions;
        this.timeScale = utc;
        this.frames = frames;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CPF parse(DataSource source) {
        try (Reader reader = source.getOpener().openReaderOnce();
             BufferedReader br = reader == null ? null : new BufferedReader(reader);){
            if (br == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, source.getName());
            }
            ParseInfo pi = new ParseInfo();
            int lineNumber = 0;
            Iterable<LineParser> candidateParsers = Collections.singleton(LineParser.H1);
            String line = br.readLine();
            while (line != null) {
                ++lineNumber;
                for (LineParser candidate : candidateParsers) {
                    if (!candidate.canHandle(line)) continue;
                    try {
                        candidate.parse(line, pi);
                        if (pi.done) {
                            pi.file.setFilter(pi.hasVelocityEntries ? CartesianDerivativesFilter.USE_PV : CartesianDerivativesFilter.USE_P);
                            CPF cPF = pi.file;
                            return cPF;
                        }
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        throw new OrekitException(e, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, source.getName(), line);
                    }
                    {
                        candidateParsers = candidate.allowedNext();
                        break;
                    }
                }
                line = br.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.CPF_UNEXPECTED_END_OF_FILE, lineNumber);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
    }

    private static enum LineParser {
        H1("H1"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String format;
                String[] values = SEPARATOR.split(line);
                int index = 1;
                if (!CPFParser.FILE_FORMAT.equals(format = values[index++])) {
                    throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FORMAT_FOR_ILRS_FILE, CPFParser.FILE_FORMAT, format);
                }
                pi.file.getHeader().setFormat(format);
                pi.file.getHeader().setVersion(Integer.parseInt(values[index++]));
                pi.file.getHeader().setSource(values[index++]);
                int year = Integer.parseInt(values[index++]);
                int month = Integer.parseInt(values[index++]);
                int day = Integer.parseInt(values[index++]);
                pi.file.getHeader().setProductionEpoch(new DateComponents(year, month, day));
                pi.file.getHeader().setProductionHour(Integer.parseInt(values[index++]));
                pi.file.getHeader().setSequenceNumber(Integer.parseInt(values[index++]));
                if (pi.file.getHeader().getVersion() == 2) {
                    pi.file.getHeader().setSubDailySequenceNumber(Integer.parseInt(values[index++]));
                }
                pi.file.getHeader().setName(values[index]);
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(H2, ZERO);
            }
        }
        ,
        H2("H2"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String[] values = SEPARATOR.split(line);
                pi.file.getHeader().setIlrsSatelliteId(values[1]);
                pi.file.getHeader().setSic(values[2]);
                pi.file.getHeader().setNoradId(values[3]);
                int yearS = Integer.parseInt(values[4]);
                int monthS = Integer.parseInt(values[5]);
                int dayS = Integer.parseInt(values[6]);
                int hourS = Integer.parseInt(values[7]);
                int minuteS = Integer.parseInt(values[8]);
                double secondS = Integer.parseInt(values[9]);
                pi.file.getHeader().setStartEpoch(new AbsoluteDate(yearS, monthS, dayS, hourS, minuteS, secondS, pi.file.getTimeScale()));
                int yearE = Integer.parseInt(values[10]);
                int monthE = Integer.parseInt(values[11]);
                int dayE = Integer.parseInt(values[12]);
                int hourE = Integer.parseInt(values[13]);
                int minuteE = Integer.parseInt(values[14]);
                double secondE = Integer.parseInt(values[15]);
                pi.file.getHeader().setEndEpoch(new AbsoluteDate(yearE, monthE, dayE, hourE, minuteE, secondE, pi.file.getTimeScale()));
                pi.file.getHeader().setStep(Integer.parseInt(values[16]));
                pi.file.getHeader().setIsCompatibleWithTIVs(Integer.parseInt(values[17]) == 1);
                pi.file.getHeader().setTargetClass(Integer.parseInt(values[18]));
                int frameId = Integer.parseInt(values[19]);
                switch (frameId) {
                    case 0: {
                        pi.frame = pi.frames.getITRF(pi.convention, false);
                        break;
                    }
                    case 1: {
                        pi.frame = pi.frames.getTOD(true);
                        break;
                    }
                    case 2: {
                        pi.frame = pi.frames.getMOD(pi.convention);
                        break;
                    }
                    default: {
                        pi.frame = pi.frames.getITRF(pi.convention, false);
                    }
                }
                pi.file.getHeader().setRefFrame(pi.frame);
                pi.file.getHeader().setRefFrameId(frameId);
                pi.file.getHeader().setRotationalAngleType(Integer.parseInt(values[20]));
                pi.file.getHeader().setIsCenterOfMassCorrectionApplied(Integer.parseInt(values[21]) == 1);
                if (pi.file.getHeader().getVersion() == 2) {
                    pi.file.getHeader().setTargetLocation(Integer.parseInt(values[22]));
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(H3, H4, H5, H9, ZERO);
            }
        }
        ,
        H3("H3"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(H4, H5, H9, ZERO);
            }
        }
        ,
        H4("H4"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String[] values = SEPARATOR.split(line);
                pi.file.getHeader().setPrf(Double.parseDouble(values[1]));
                pi.file.getHeader().setTranspTransmitDelay(Double.parseDouble(values[2]) * 1.0E-6);
                pi.file.getHeader().setTranspUtcOffset(Double.parseDouble(values[3]) * 1.0E-6);
                pi.file.getHeader().setTranspOscDrift(Double.parseDouble(values[4]));
                if (pi.file.getHeader().getVersion() == 2) {
                    pi.file.getHeader().setTranspClkRef(Double.parseDouble(values[5]));
                }
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(H5, H9, ZERO);
            }
        }
        ,
        H5("H5"){

            @Override
            public void parse(String line, ParseInfo pi) {
                double offset = Double.parseDouble(SEPARATOR.split(line)[1]);
                pi.file.getHeader().setCenterOfMassOffset(offset);
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(H9, ZERO);
            }
        }
        ,
        H9("H9"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, ZERO);
            }
        }
        ,
        TEN("10"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String[] values = SEPARATOR.split(line);
                int mjd = Integer.parseInt(values[2]);
                double secInDay = Double.parseDouble(values[3]);
                AbsoluteDate date = AbsoluteDate.createMJDDate(mjd, secInDay, pi.timeScale);
                int leap = Integer.parseInt(values[4]);
                double x = Double.parseDouble(values[5]);
                double y = Double.parseDouble(values[6]);
                double z = Double.parseDouble(values[7]);
                Vector3D position = new Vector3D(x, y, z);
                CPF.CPFCoordinate coordinate = new CPF.CPFCoordinate(date, position, leap);
                pi.file.addSatelliteCoordinate(pi.file.getHeader().getIlrsSatelliteId(), coordinate);
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        TWENTY("20"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String[] values = SEPARATOR.split(line);
                double x = Double.parseDouble(values[2]);
                double y = Double.parseDouble(values[3]);
                double z = Double.parseDouble(values[4]);
                Vector3D velocity = new Vector3D(x, y, z);
                pi.file.addSatelliteVelocityToCPFCoordinate(pi.file.getHeader().getIlrsSatelliteId(), velocity);
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        THIRTY("30"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        FORTY("40"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        FIFTY("50"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        SIXTY("60"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        SEVENTY("70"){

            @Override
            public void parse(String line, ParseInfo pi) {
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        ZERO("00"){

            @Override
            public void parse(String line, ParseInfo pi) {
                String comment = line.split(this.getIdentifier())[1].trim();
                pi.file.getComments().add(comment);
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Arrays.asList(H1, H2, H3, H4, H5, H9, TEN, TWENTY, THIRTY, FORTY, FIFTY, SIXTY, SEVENTY, ZERO, EOF);
            }
        }
        ,
        EOF("99"){

            @Override
            public void parse(String line, ParseInfo pi) {
                pi.done = true;
            }

            @Override
            public Iterable<LineParser> allowedNext() {
                return Collections.singleton(EOF);
            }
        };

        private final Pattern pattern;
        private final String identifier;

        private LineParser(String identifier) {
            this.identifier = identifier;
            this.pattern = Pattern.compile(identifier);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public abstract void parse(String var1, ParseInfo var2);

        public abstract Iterable<LineParser> allowedNext();

        public boolean canHandle(String line) {
            return this.pattern.matcher(SEPARATOR.split(line)[0]).matches();
        }
    }

    private class ParseInfo {
        private CPF file = new CPF();
        private IERSConventions convention;
        private Frames frames;
        private Frame frame;
        private TimeScale timeScale;
        private boolean hasVelocityEntries;
        private boolean done;

        protected ParseInfo() {
            this.timeScale = CPFParser.this.timeScale;
            this.file.setMu(CPFParser.this.mu);
            this.file.setInterpolationSample(CPFParser.this.interpolationSample);
            this.file.setTimeScale(this.timeScale);
            this.done = false;
            this.hasVelocityEntries = false;
            this.convention = CPFParser.this.iersConvention;
            this.frames = CPFParser.this.frames;
            this.frame = this.frames.getITRF(this.convention, false);
        }
    }
}

