/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.FixedFrameBuilder;
import org.orekit.attitudes.TabulatedProvider;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class OrekitAttitudeEphemerisFile
implements AttitudeEphemerisFile<TimeStampedAngularCoordinates, OrekitAttitudeEphemerisSegment> {
    private final Map<String, OrekitSatelliteAttitudeEphemeris> satellites = new ConcurrentHashMap<String, OrekitSatelliteAttitudeEphemeris>();

    @Override
    public Map<String, OrekitSatelliteAttitudeEphemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public OrekitSatelliteAttitudeEphemeris addSatellite(String id) {
        OrekitSatelliteAttitudeEphemeris newSat = new OrekitSatelliteAttitudeEphemeris(id);
        this.satellites.put(id, newSat);
        return newSat;
    }

    public static class OrekitAttitudeEphemerisSegment
    implements AttitudeEphemerisFile.AttitudeEphemerisSegment<TimeStampedAngularCoordinates> {
        private List<TimeStampedAngularCoordinates> attitudeDataLines;
        private String interpolationMethod;
        private int interpolationSamples;
        private AngularDerivativesFilter availableDerivatives;
        private Frame referenceFrame;

        public OrekitAttitudeEphemerisSegment(List<TimeStampedAngularCoordinates> attitudeDataLines, String interpolationMethod, int interpolationSamples, Frame referenceFrame, AngularDerivativesFilter availableDerivatives) {
            this.attitudeDataLines = attitudeDataLines;
            this.interpolationMethod = interpolationMethod;
            this.interpolationSamples = interpolationSamples;
            this.referenceFrame = referenceFrame;
            this.availableDerivatives = availableDerivatives;
        }

        @Override
        public List<TimeStampedAngularCoordinates> getAngularCoordinates() {
            return Collections.unmodifiableList(this.attitudeDataLines);
        }

        @Override
        public Frame getReferenceFrame() {
            return this.referenceFrame;
        }

        @Override
        public AbsoluteDate getStart() {
            return this.attitudeDataLines.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.attitudeDataLines.get(this.attitudeDataLines.size() - 1).getDate();
        }

        @Override
        public String getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public int getInterpolationSamples() {
            return this.interpolationSamples;
        }

        @Override
        public AngularDerivativesFilter getAvailableDerivatives() {
            return this.availableDerivatives;
        }

        @Override
        public BoundedAttitudeProvider getAttitudeProvider() {
            return new TabulatedProvider(this.getAngularCoordinates(), this.getInterpolationSamples(), this.getAvailableDerivatives(), this.getStart(), this.getStop(), new FixedFrameBuilder(this.getReferenceFrame()));
        }
    }

    public static class OrekitSatelliteAttitudeEphemeris
    implements AttitudeEphemerisFile.SatelliteAttitudeEphemeris<TimeStampedAngularCoordinates, OrekitAttitudeEphemerisSegment> {
        public static final String DEFAULT_INTERPOLATION_METHOD = "LINEAR";
        public static final int DEFAULT_INTERPOLATION_SIZE = 2;
        private final String id;
        private AbsoluteDate startDate;
        private AbsoluteDate stopDate;
        private final List<OrekitAttitudeEphemerisSegment> segments;

        public OrekitSatelliteAttitudeEphemeris(String id) {
            this.id = id;
            this.segments = new ArrayList<OrekitAttitudeEphemerisSegment>();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<OrekitAttitudeEphemerisSegment> getSegments() {
            return Collections.unmodifiableList(this.segments);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.startDate;
        }

        @Override
        public AbsoluteDate getStop() {
            return this.stopDate;
        }

        public OrekitAttitudeEphemerisSegment addNewSegment(List<SpacecraftState> states, String interpolationMethod, int interpolationSamples, AngularDerivativesFilter availableDerivatives) {
            int minimumSampleSize = 2;
            if (states == null || states.size() == 0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "states");
            }
            if (interpolationSamples < 2) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, interpolationSamples);
            }
            AbsoluteDate start = states.get(0).getDate();
            AbsoluteDate stop = states.get(states.size() - 1).getDate();
            if (this.startDate == null || start.compareTo(this.startDate) < 0) {
                this.startDate = start;
            }
            if (this.stopDate == null || stop.compareTo(this.stopDate) > 0) {
                this.stopDate = stop;
            }
            ArrayList<TimeStampedAngularCoordinates> attitudeDataLines = new ArrayList<TimeStampedAngularCoordinates>();
            for (SpacecraftState state : states) {
                attitudeDataLines.add(state.getAttitude().getOrientation());
            }
            OrekitAttitudeEphemerisSegment newSeg = new OrekitAttitudeEphemerisSegment(attitudeDataLines, interpolationMethod, interpolationSamples, states.get(0).getFrame(), availableDerivatives);
            this.segments.add(newSeg);
            return newSeg;
        }
    }
}

