/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.SortedListTrimmer;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinatesHermiteInterpolator;

public class EphemerisSegmentPropagator<C extends TimeStampedPVCoordinates>
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private final EphemerisFile.EphemerisSegment<C> ephemeris;
    private final TimeStampedPVCoordinatesHermiteInterpolator interpolator;
    private final Frame inertialFrame;
    private final Frame ephemerisFrame;

    public EphemerisSegmentPropagator(EphemerisFile.EphemerisSegment<C> ephemeris, AttitudeProvider attitudeProvider) {
        super(attitudeProvider);
        this.ephemeris = ephemeris;
        this.interpolator = new TimeStampedPVCoordinatesHermiteInterpolator(ephemeris.getInterpolationSamples(), ephemeris.getAvailableDerivatives());
        this.ephemerisFrame = ephemeris.getFrame();
        this.inertialFrame = ephemeris.getInertialFrame();
        TimeStampedPVCoordinates ic = (TimeStampedPVCoordinates)ephemeris.getCoordinates().get(0);
        TimeStampedPVCoordinates icInertial = this.ephemerisFrame.getTransformTo(this.inertialFrame, ic.getDate()).transformPVCoordinates(ic);
        super.resetInitialState(new SpacecraftState((Orbit)new CartesianOrbit(icInertial, this.inertialFrame, ephemeris.getMu()), this.getAttitudeProvider().getAttitude(icInertial.toTaylorProvider(this.inertialFrame), ic.getDate(), this.inertialFrame), 1000.0));
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates interpolatedPVCoordinates = this.interpolate(date);
        return this.ephemerisFrame.getTransformTo(frame, date).transformPVCoordinates(interpolatedPVCoordinates);
    }

    @Override
    public Vector3D getPosition(AbsoluteDate date, Frame frame) {
        Vector3D interpolatedPosition = this.interpolate(date).getPosition();
        return this.ephemerisFrame.getStaticTransformTo(frame, date).transformPosition(interpolatedPosition);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates(date, this.inertialFrame);
        return new CartesianOrbit(pv, this.inertialFrame, this.ephemeris.getMu());
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.ephemeris.getStart();
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.ephemeris.getStop();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return 1000.0;
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.basicPropagate(this.getMinDate());
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    private TimeStampedPVCoordinates interpolate(AbsoluteDate date) {
        List<C> neighbors = new SortedListTrimmer(this.interpolator.getNbInterpolationPoints()).getNeighborsSubList(date, this.ephemeris.getCoordinates());
        ArrayList<C> castedNeighbors = new ArrayList<C>(neighbors.size());
        castedNeighbors.addAll(neighbors);
        return (TimeStampedPVCoordinates)this.interpolator.interpolate(date, castedNeighbors);
    }
}

