/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.orekit.attitudes.AggregateBoundedAttitudeProvider;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public interface AttitudeEphemerisFile<C extends TimeStampedAngularCoordinates, S extends AttitudeEphemerisSegment<C>> {
    public Map<String, ? extends SatelliteAttitudeEphemeris<C, S>> getSatellites();

    public static interface AttitudeEphemerisSegment<C extends TimeStampedAngularCoordinates> {
        public List<C> getAngularCoordinates();

        public Frame getReferenceFrame();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        public String getInterpolationMethod();

        public int getInterpolationSamples();

        public AngularDerivativesFilter getAvailableDerivatives();

        public BoundedAttitudeProvider getAttitudeProvider();
    }

    public static interface SatelliteAttitudeEphemeris<C extends TimeStampedAngularCoordinates, S extends AttitudeEphemerisSegment<C>> {
        public String getId();

        public List<S> getSegments();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        default public BoundedAttitudeProvider getAttitudeProvider() {
            ArrayList<BoundedAttitudeProvider> providers = new ArrayList<BoundedAttitudeProvider>();
            for (AttitudeEphemerisSegment attitudeSegment : this.getSegments()) {
                providers.add(attitudeSegment.getAttitudeProvider());
            }
            return new AggregateBoundedAttitudeProvider(providers);
        }
    }
}

