/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.LexicalAnalyzerSelector;
import org.orekit.files.ccsds.utils.lexical.MessageParser;
import org.orekit.files.ccsds.utils.lexical.MessageVersionXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.ErrorState;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;

public abstract class AbstractMessageParser<T>
implements MessageParser<T> {
    private static final String COMMENT = "COMMENT";
    private static final int MAX_LOOP = 100;
    private final String root;
    private final String formatVersionKey;
    private final Function<ParseToken, List<ParseToken>>[] filters;
    private ProcessingState next;
    private ProcessingState current;
    private ProcessingState fallback;
    private FileFormat format;
    private boolean endTagSeen;

    protected AbstractMessageParser(String root, String formatVersionKey, Function<ParseToken, List<ParseToken>>[] filters) {
        this.root = root;
        this.formatVersionKey = formatVersionKey;
        this.filters = (Function[])filters.clone();
        this.current = null;
        this.setFallback(new ErrorState());
    }

    public void setFallback(ProcessingState fallback) {
        this.fallback = fallback;
    }

    protected void reset(FileFormat fileFormat, ProcessingState initialState) {
        this.format = fileFormat;
        this.current = initialState;
        this.endTagSeen = false;
        this.anticipateNext(this.fallback);
    }

    public void setEndTagSeen(boolean endTagSeen) {
        this.endTagSeen = endTagSeen;
    }

    public boolean wasEndTagSeen() {
        return this.endTagSeen;
    }

    public ProcessingState getCurrent() {
        return this.current;
    }

    @Override
    public FileFormat getFileFormat() {
        return this.format;
    }

    @Override
    public T parseMessage(DataSource source) {
        try {
            return LexicalAnalyzerSelector.select(source).accept(this);
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
    }

    @Override
    public String getFormatVersionKey() {
        return this.formatVersionKey;
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        HashMap<String, XmlTokenBuilder> builders = new HashMap<String, XmlTokenBuilder>();
        if (this.formatVersionKey != null) {
            builders.put(this.root, new MessageVersionXmlTokenBuilder());
        }
        return builders;
    }

    public void anticipateNext(ProcessingState anticipated) {
        this.next = anticipated;
    }

    @Override
    public void process(ParseToken token) {
        List<ParseToken> filtered = Collections.singletonList(token);
        for (Function<ParseToken, List<ParseToken>> filter : this.filters) {
            ArrayList<ParseToken> newFiltered = new ArrayList<ParseToken>();
            for (ParseToken original : filtered) {
                newFiltered.addAll((Collection<ParseToken>)filter.apply(original));
            }
            filtered = newFiltered;
        }
        if (filtered.isEmpty()) {
            return;
        }
        int remaining = filtered.size();
        block2: for (ParseToken filteredToken : filtered) {
            if (filteredToken.getType() == TokenType.ENTRY && !COMMENT.equals(filteredToken.getName()) && (filteredToken.getRawContent() == null || filteredToken.getRawContent().isEmpty())) {
                if (--remaining != 0) continue;
                return;
            }
            for (int i = 0; i < 100; ++i) {
                if (this.current.processToken(filteredToken)) {
                    if (--remaining != 0) continue block2;
                    return;
                }
                this.current = this.next;
                this.next = this.fallback;
            }
        }
        throw new OrekitInternalError(null);
    }
}

