/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.lexical;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.LexicalAnalyzer;
import org.orekit.files.ccsds.utils.lexical.MessageParser;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.RegularXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlLexicalAnalyzer
implements LexicalAnalyzer {
    private final DataSource source;

    public XmlLexicalAnalyzer(DataSource source) {
        this.source = source;
    }

    @Override
    public <T> T accept(MessageParser<T> messageParser) {
        try {
            XMLHandler handler = new XMLHandler(messageParser);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            messageParser.reset(FileFormat.XML);
            DataSource.Opener opener = this.source.getOpener();
            if (opener.rawDataIsBinary()) {
                try (InputStream is = opener.openStreamOnce();){
                    if (is == null) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, this.source.getName());
                    }
                    saxParser.parse(new InputSource(is), (DefaultHandler)handler);
                }
            }
            try (Reader reader = opener.openReaderOnce();){
                if (reader == null) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, this.source.getName());
                }
                saxParser.parse(new InputSource(reader), (DefaultHandler)handler);
            }
            return messageParser.build();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        private final MessageParser<?> messageParser;
        private final XmlTokenBuilder regularBuilder;
        private Map<String, XmlTokenBuilder> specialElements;
        private Locator locator;
        private String currentElementName;
        private int currentLineNumber;
        private String currentContent;
        private Map<String, String> currentAttributes;
        private String lastQname;
        private boolean lastWasStart;

        XMLHandler(MessageParser<?> messageParser) {
            this.messageParser = messageParser;
            this.regularBuilder = new RegularXmlTokenBuilder();
            this.specialElements = messageParser.getSpecialXmlElementsBuilders();
            this.lastQname = "";
            this.lastWasStart = false;
        }

        private XmlTokenBuilder getBuilder(String qName) {
            XmlTokenBuilder specialBuilder = this.specialElements.get(qName);
            return specialBuilder != null ? specialBuilder : this.regularBuilder;
        }

        @Override
        public void setDocumentLocator(Locator documentLocator) {
            this.locator = documentLocator;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentElementName != null) {
                this.currentLineNumber = this.locator.getLineNumber();
                this.currentContent = this.currentContent + new String(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentElementName = qName;
            this.currentLineNumber = this.locator.getLineNumber();
            this.currentContent = "";
            if (attributes.getLength() == 0) {
                this.currentAttributes = Collections.emptyMap();
            } else {
                this.currentAttributes = new HashMap<String, String>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.currentAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            for (ParseToken token : this.getBuilder(qName).buildTokens(true, false, qName, this.getContent(), this.currentAttributes, this.currentLineNumber, XmlLexicalAnalyzer.this.source.getName())) {
                this.messageParser.process(token);
            }
            this.lastQname = qName;
            this.lastWasStart = true;
        }

        private String getContent() {
            return this.currentContent.isEmpty() ? null : this.currentContent;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.currentContent == null || this.currentContent.isEmpty()) {
                this.currentLineNumber = this.locator.getLineNumber();
            }
            boolean isLeaf = this.lastWasStart && qName.equals(this.lastQname);
            for (ParseToken token : this.getBuilder(qName).buildTokens(false, isLeaf, qName, this.getContent(), this.currentAttributes, this.currentLineNumber, XmlLexicalAnalyzer.this.source.getName())) {
                this.messageParser.process(token);
            }
            this.lastQname = qName;
            this.lastWasStart = true;
            this.currentElementName = null;
            this.currentAttributes = null;
            this.currentLineNumber = -1;
            this.currentContent = "";
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource();
        }
    }
}

