/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.lexical;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.LexicalAnalyzer;
import org.orekit.files.ccsds.utils.lexical.MessageParser;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;
import org.orekit.utils.units.UnitsCache;

public class KvnLexicalAnalyzer
implements LexicalAnalyzer {
    private static final String LINE_START = "^\\p{Blank}*";
    private static final String COMMENT_KEY = "(COMMENT)\\p{Blank}*";
    private static final String NON_COMMENT_KEY = "([A-Z][A-Z_0-9]*)\\p{Blank}*=\\p{Blank}*";
    private static final String START_KEY = "([A-Z][A-Z_0-9]*)_START";
    private static final String STOP_KEY = "([A-Z][A-Z_0-9]*)_STOP";
    private static final String OPTIONAL_VALUE = "((?:(?:\\p{Graph}.*?)?))";
    private static final String UNITS_OPERATORS = "-+*\u00d7.\u00b7/\u2044^\u221a\u207a\u207b";
    private static final String UNITS_LETTERS = "A-Za-z\u00b5\u03bc";
    private static final String UNITS_DIGITS = "0-9\u2070\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079";
    private static final String UNITS_FRACTIONS = "\u00bc\u00bd\u00be\u2150\u2151\u2152\u2153\u2154\u2155\u2156\u2157\u2158\u2159\u215a\u215b\u215c\u215d\u215e";
    private static final String UNITS_SYMBOLS = "%\u00b0\u25e6\u2032'\u2033\\\"#";
    private static final String UNITS_PARENTHESES = "()";
    private static final String UNITS = "(?:\\p{Blank}+\\[([-+*\u00d7.\u00b7/\u2044^\u221a\u207a\u207bA-Za-z\u00b5\u03bc0-9\u2070\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079\u00bc\u00bd\u00be\u2150\u2151\u2152\u2153\u2154\u2155\u2156\u2157\u2158\u2159\u215a\u215b\u215c\u215d\u215e%\u00b0\u25e6\u2032'\u2033\\\"#()]*)\\])?";
    private static final String LINE_END = "\\p{Blank}*$";
    private static final Pattern COMMENT_ENTRY = Pattern.compile("^\\p{Blank}*(COMMENT)\\p{Blank}*((?:(?:\\p{Graph}.*?)?))\\p{Blank}*$");
    private static final Pattern NON_COMMENT_ENTRY = Pattern.compile("^\\p{Blank}*([A-Z][A-Z_0-9]*)\\p{Blank}*=\\p{Blank}*((?:(?:\\p{Graph}.*?)?))(?:\\p{Blank}+\\[([-+*\u00d7.\u00b7/\u2044^\u221a\u207a\u207bA-Za-z\u00b5\u03bc0-9\u2070\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079\u00bc\u00bd\u00be\u2150\u2151\u2152\u2153\u2154\u2155\u2156\u2157\u2158\u2159\u215a\u215b\u215c\u215d\u215e%\u00b0\u25e6\u2032'\u2033\\\"#()]*)\\])?\\p{Blank}*$");
    private static final Pattern START_ENTRY = Pattern.compile("^\\p{Blank}*([A-Z][A-Z_0-9]*)_START\\p{Blank}*$");
    private static final Pattern STOP_ENTRY = Pattern.compile("^\\p{Blank}*([A-Z][A-Z_0-9]*)_STOP\\p{Blank}*$");
    private final DataSource source;
    private final UnitsCache cache;

    public KvnLexicalAnalyzer(DataSource source) {
        this.source = source;
        this.cache = new UnitsCache();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T accept(MessageParser<T> messageParser) {
        messageParser.reset(FileFormat.KVN);
        try (Reader reader = this.source.getOpener().openReaderOnce();){
            T t;
            block25: {
                BufferedReader br = reader == null ? null : new BufferedReader(reader);
                try {
                    if (br == null) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, this.source.getName());
                    }
                    int lineNumber = 0;
                    String line = br.readLine();
                    while (line != null) {
                        ++lineNumber;
                        if (line.trim().length() != 0) {
                            Matcher nonComment = NON_COMMENT_ENTRY.matcher(line);
                            if (nonComment.matches()) {
                                Unit units = this.cache.getUnits(nonComment.groupCount() > 2 ? nonComment.group(3) : null);
                                messageParser.process(new ParseToken(TokenType.ENTRY, nonComment.group(1), nonComment.group(2), units, lineNumber, this.source.getName()));
                            } else {
                                Matcher comment = COMMENT_ENTRY.matcher(line);
                                if (comment.matches()) {
                                    messageParser.process(new ParseToken(TokenType.ENTRY, comment.group(1), comment.group(2), null, lineNumber, this.source.getName()));
                                } else {
                                    Matcher start = START_ENTRY.matcher(line);
                                    if (start.matches()) {
                                        messageParser.process(new ParseToken(TokenType.START, start.group(1), null, null, lineNumber, this.source.getName()));
                                    } else {
                                        Matcher stop = STOP_ENTRY.matcher(line);
                                        if (stop.matches()) {
                                            messageParser.process(new ParseToken(TokenType.STOP, stop.group(1), null, null, lineNumber, this.source.getName()));
                                        } else {
                                            messageParser.process(new ParseToken(TokenType.RAW_LINE, null, line, null, lineNumber, this.source.getName()));
                                        }
                                    }
                                }
                            }
                        }
                        line = br.readLine();
                    }
                    t = messageParser.build();
                    if (br == null) break block25;
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                br.close();
            }
            return t;
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }
}

