/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.section;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;

public class XmlStructureProcessingState
implements ProcessingState {
    private final String root;
    private final AbstractConstituentParser<?, ?, ?> parser;

    public XmlStructureProcessingState(String root, AbstractConstituentParser<?, ?, ?> parser) {
        this.root = root;
        this.parser = parser;
    }

    @Override
    public boolean processToken(ParseToken token) {
        if (this.root.equals(token.getName())) {
            this.parser.setEndTagSeen(token.getType() == TokenType.STOP);
            return true;
        }
        if (Double.isNaN(((Header)this.parser.getHeader()).getFormatVersion())) {
            if (this.parser.getFormatVersionKey() != null && this.parser.getFormatVersionKey().equals(token.getName()) && token.getType() == TokenType.ENTRY) {
                ((Header)this.parser.getHeader()).setFormatVersion(token.getContentAsDouble());
                return true;
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, token.getFileName());
        }
        try {
            return XmlStructureKey.valueOf(token.getName()).process(token, this.parser);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

