/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.section;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.MetadataKey;

public class Metadata
extends CommentsContainer {
    private static final Pattern INTERNATIONAL_DESIGNATOR = Pattern.compile("(\\p{Digit}{4})-(\\p{Digit}{3})(\\p{Upper}{1,3})");
    private TimeSystem timeSystem;

    protected Metadata(TimeSystem defaultTimeSystem) {
        this.timeSystem = defaultTimeSystem;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull((Object)this.timeSystem, MetadataKey.TIME_SYSTEM.name());
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(TimeSystem timeSystem) {
        this.refuseFurtherComments();
        this.timeSystem = timeSystem;
    }

    protected int getLaunchYear(String objectID) {
        Matcher matcher = INTERNATIONAL_DESIGNATOR.matcher(objectID);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new OrekitException((Localizable)OrekitMessages.NOT_VALID_INTERNATIONAL_DESIGNATOR, objectID);
    }

    protected int getLaunchNumber(String objectID) {
        Matcher matcher = INTERNATIONAL_DESIGNATOR.matcher(objectID);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(2));
        }
        throw new OrekitException((Localizable)OrekitMessages.NOT_VALID_INTERNATIONAL_DESIGNATOR, objectID);
    }

    protected String getLaunchPiece(String objectID) {
        Matcher matcher = INTERNATIONAL_DESIGNATOR.matcher(objectID);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        throw new OrekitException((Localizable)OrekitMessages.NOT_VALID_INTERNATIONAL_DESIGNATOR, objectID);
    }
}

