/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.section;

import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.HeaderKey;
import org.orekit.time.AbsoluteDate;

public class Header
extends CommentsContainer {
    private double formatVersion = Double.NaN;
    private String classification;
    private AbsoluteDate creationDate;
    private String originator;
    private String messageId;
    private final double minVersionMessageId;
    private final double minVersionClassification;

    public Header(double minVersionMessageId, double minVersionClassification) {
        this.minVersionMessageId = minVersionMessageId;
        this.minVersionClassification = minVersionClassification;
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.creationDate, HeaderKey.CREATION_DATE.name());
        this.checkNotNull(this.originator, HeaderKey.ORIGINATOR.name());
        this.checkAllowed(version, this.messageId, HeaderKey.MESSAGE_ID.name(), this.minVersionMessageId, Double.POSITIVE_INFINITY);
        this.checkAllowed(version, this.classification, HeaderKey.CLASSIFICATION.name(), this.minVersionClassification, Double.POSITIVE_INFINITY);
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.refuseFurtherComments();
        this.classification = classification;
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.refuseFurtherComments();
        this.creationDate = creationDate;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.refuseFurtherComments();
        this.originator = originator;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }
}

