/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.section;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.section.Section;

public class CommentsContainer
implements Section {
    private List<String> comments = new ArrayList<String>();
    private boolean acceptComments = true;

    public void checkNotNegative(int field, String key) {
        if (field < 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, key);
        }
    }

    public void checkNotNaN(double field, String key) {
        if (Double.isNaN(field)) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, key);
        }
    }

    public void checkNotNull(Object field, String key) {
        if (field == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, key);
        }
    }

    public void checkAllowed(double version, Object field, String key, double minVersion, double maxVersion) {
        if (field != null && (version < minVersion || version >= maxVersion)) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_KEYWORD_NOT_ALLOWED_IN_VERSION, key, version);
        }
    }

    @Override
    public void validate(double version) {
    }

    public List<String> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public void setComments(List<String> comments) {
        this.comments = comments;
    }

    public boolean acceptComments() {
        return this.acceptComments;
    }

    public void refuseFurtherComments() {
        this.acceptComments = false;
    }

    public boolean addComment(String comment) {
        if (this.acceptComments) {
            this.comments.add(comment);
            return true;
        }
        return false;
    }
}

