/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.section;

import java.io.IOException;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;

public abstract class AbstractWriter {
    private String xmlTag;
    private String kvnTag;

    protected AbstractWriter(String xmlTag, String kvnTag) {
        this.xmlTag = xmlTag;
        this.kvnTag = kvnTag;
    }

    public void write(Generator generator) throws IOException {
        this.enterSection(generator);
        this.writeContent(generator);
        this.exitSection(generator);
    }

    public void enterSection(Generator generator) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(this.xmlTag);
        } else if (generator.getFormat() == FileFormat.KVN && this.kvnTag != null) {
            generator.enterSection(this.kvnTag);
        }
    }

    public void exitSection(Generator generator) throws IOException {
        if (generator.getFormat() == FileFormat.XML || generator.getFormat() == FileFormat.KVN && this.kvnTag != null) {
            generator.exitSection();
        }
    }

    protected abstract void writeContent(Generator var1) throws IOException;

    protected String intArrayToString(int[] integers) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < integers.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(integers[i]);
        }
        return builder.toString();
    }
}

