/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.tdm.ObservationsBlock;
import org.orekit.files.ccsds.ndm.tdm.ObservationsBlockWriter;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.Tdm;
import org.orekit.files.ccsds.ndm.tdm.TdmHeader;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadata;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadataWriter;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.IERSConventions;

public class TdmWriter
extends AbstractMessageWriter<TdmHeader, Segment<TdmMetadata, ObservationsBlock>, Tdm> {
    public static final double CCSDS_TDM_VERS = 2.0;
    public static final int KVN_PADDING_WIDTH = 29;
    private final RangeUnitsConverter converter;

    public TdmWriter(IERSConventions conventions, DataContext dataContext, RangeUnitsConverter converter) {
        super("tdm", "CCSDS_TDM_VERS", 2.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> null, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
        this.converter = converter;
    }

    @Override
    protected void writeSegmentContent(Generator generator, double formatVersion, Segment<TdmMetadata, ObservationsBlock> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        TdmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        new TdmMetadataWriter(metadata, this.getTimeConverter()).write(generator);
        new ObservationsBlockWriter(segment.getData(), this.getTimeConverter(), segment.getMetadata(), this.converter).write(generator);
    }
}

