/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.tdm.ObservationType;
import org.orekit.files.ccsds.ndm.tdm.ObservationsBlock;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.Tdm;
import org.orekit.files.ccsds.ndm.tdm.TdmDataKey;
import org.orekit.files.ccsds.ndm.tdm.TdmHeader;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadata;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadataKey;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.KvnStructureProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.parsing.AbstractConstituentParser;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.utils.IERSConventions;

public class TdmParser
extends AbstractConstituentParser<TdmHeader, Tdm, TdmParser> {
    private final RangeUnitsConverter converter;
    private TdmMetadata metadata;
    private ContextBinding context;
    private ObservationsBlock observationsBlock;
    private TdmHeader header;
    private List<Segment<TdmMetadata, ObservationsBlock>> segments;
    private ProcessingState structureProcessor;

    public TdmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, ParsedUnitsBehavior parsedUnitsBehavior, RangeUnitsConverter converter, Function<ParseToken, List<ParseToken>>[] filters) {
        super("tdm", "CCSDS_TDM_VERS", conventions, simpleEOP, dataContext, parsedUnitsBehavior, filters);
        this.converter = converter;
    }

    @Override
    public TdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new TdmHeader();
        this.segments = new ArrayList<Segment<TdmMetadata, ObservationsBlock>>();
        this.metadata = null;
        this.context = null;
        this.observationsBlock = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("tdm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new KvnStructureProcessingState(this);
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public Tdm build() {
        return new Tdm(this.header, this.segments, this.getConventions(), this.getDataContext());
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new TdmMetadata();
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, () -> null, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareData() {
        this.observationsBlock = new ObservationsBlock();
        this.anticipateNext(this::processDataToken);
        return true;
    }

    @Override
    public boolean inData() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeData() {
        this.segments.add(new Segment<TdmMetadata, ObservationsBlock>(this.metadata, this.observationsBlock));
        this.metadata = null;
        this.context = null;
        this.observationsBlock = null;
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return TdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeT) {
                return false;
            }
        }
    }

    private boolean processDataToken(ParseToken token) {
        try {
            this.inData();
            try {
                return token.getName() != null && TdmDataKey.valueOf(token.getName()).process(token, this.context, this.observationsBlock);
            }
            catch (IllegalArgumentException iae) {
                return ObservationType.valueOf(token.getName()).process(token, this.context, this.converter, this.metadata, this.observationsBlock);
            }
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

