/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.tdm;

import java.io.IOException;
import java.util.List;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.tdm.ObservationType;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadata;
import org.orekit.files.ccsds.ndm.tdm.TdmMetadataKey;
import org.orekit.files.ccsds.ndm.tdm.TrackingMode;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class TdmMetadataWriter
extends AbstractWriter {
    private final TdmMetadata metadata;
    private final TimeConverter timeConverter;

    TdmMetadataWriter(TdmMetadata metadata, TimeConverter timeConverter) {
        super(XmlStructureKey.metadata.name(), KvnStructureKey.META.name());
        this.metadata = metadata;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.metadata.getComments());
        generator.writeEntry(TdmMetadataKey.TRACK_ID.name(), this.metadata.getTrackId(), null, false);
        List<ObservationType> dataTypes = this.metadata.getDataTypes();
        if (dataTypes != null && !dataTypes.isEmpty()) {
            StringBuilder dataTypesNames = new StringBuilder();
            for (int i = 0; i < dataTypes.size(); ++i) {
                if (i > 0) {
                    dataTypesNames.append(',');
                }
                dataTypesNames.append(dataTypes.get(i).name());
            }
            generator.writeEntry(TdmMetadataKey.DATA_TYPES.name(), dataTypesNames.toString(), null, false);
        }
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), this.metadata.getTimeSystem(), true);
        generator.writeEntry(TdmMetadataKey.START_TIME.name(), this.timeConverter, this.metadata.getStartTime(), false, false);
        generator.writeEntry(TdmMetadataKey.STOP_TIME.name(), this.timeConverter, this.metadata.getStopTime(), false, false);
        generator.writeEntry(TdmMetadataKey.PARTICIPANT_1.name(), this.metadata.getParticipants().get(1), null, true);
        generator.writeEntry(TdmMetadataKey.PARTICIPANT_2.name(), this.metadata.getParticipants().get(2), null, false);
        generator.writeEntry(TdmMetadataKey.PARTICIPANT_3.name(), this.metadata.getParticipants().get(3), null, false);
        generator.writeEntry(TdmMetadataKey.PARTICIPANT_4.name(), this.metadata.getParticipants().get(4), null, false);
        generator.writeEntry(TdmMetadataKey.PARTICIPANT_5.name(), this.metadata.getParticipants().get(5), null, false);
        TrackingMode mode = this.metadata.getMode();
        generator.writeEntry(TdmMetadataKey.MODE.name(), mode, false);
        if (mode == TrackingMode.SEQUENTIAL) {
            generator.writeEntry(TdmMetadataKey.PATH.name(), this.intArrayToString(this.metadata.getPath()), null, true);
        } else if (mode == TrackingMode.SINGLE_DIFF) {
            generator.writeEntry(TdmMetadataKey.PATH_1.name(), this.intArrayToString(this.metadata.getPath1()), null, true);
            generator.writeEntry(TdmMetadataKey.PATH_2.name(), this.intArrayToString(this.metadata.getPath2()), null, true);
        }
        generator.writeEntry(TdmMetadataKey.EPHEMERIS_NAME_1.name(), this.metadata.getEphemerisNames().get(1), null, false);
        generator.writeEntry(TdmMetadataKey.EPHEMERIS_NAME_2.name(), this.metadata.getEphemerisNames().get(2), null, false);
        generator.writeEntry(TdmMetadataKey.EPHEMERIS_NAME_3.name(), this.metadata.getEphemerisNames().get(3), null, false);
        generator.writeEntry(TdmMetadataKey.EPHEMERIS_NAME_4.name(), this.metadata.getEphemerisNames().get(4), null, false);
        generator.writeEntry(TdmMetadataKey.EPHEMERIS_NAME_5.name(), this.metadata.getEphemerisNames().get(5), null, false);
        generator.writeEntry(TdmMetadataKey.TRANSMIT_BAND.name(), this.metadata.getTransmitBand(), null, false);
        generator.writeEntry(TdmMetadataKey.RECEIVE_BAND.name(), this.metadata.getReceiveBand(), null, false);
        if (this.metadata.getTurnaroundNumerator() != 0 || this.metadata.getTurnaroundDenominator() != 0) {
            generator.writeEntry(TdmMetadataKey.TURNAROUND_NUMERATOR.name(), this.metadata.getTurnaroundNumerator(), false);
            generator.writeEntry(TdmMetadataKey.TURNAROUND_DENOMINATOR.name(), this.metadata.getTurnaroundDenominator(), false);
        }
        generator.writeEntry(TdmMetadataKey.TIMETAG_REF.name(), this.metadata.getTimetagRef(), false);
        generator.writeEntry(TdmMetadataKey.INTEGRATION_INTERVAL.name(), this.metadata.getIntegrationInterval(), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.INTEGRATION_REF.name(), this.metadata.getIntegrationRef(), false);
        generator.writeEntry(TdmMetadataKey.FREQ_OFFSET.name(), this.metadata.getFreqOffset(), Unit.HERTZ, false);
        generator.writeEntry(TdmMetadataKey.RANGE_MODE.name(), this.metadata.getRangeMode(), false);
        if (this.metadata.getRawRangeModulus() != 0.0) {
            generator.writeEntry(TdmMetadataKey.RANGE_MODULUS.name(), this.metadata.getRawRangeModulus(), Unit.ONE, false);
        }
        generator.writeEntry(TdmMetadataKey.RANGE_UNITS.name(), this.metadata.getRangeUnits(), false);
        generator.writeEntry(TdmMetadataKey.ANGLE_TYPE.name(), this.metadata.getAngleType(), false);
        if (this.metadata.getReferenceFrame() != null) {
            generator.writeEntry(TdmMetadataKey.REFERENCE_FRAME.name(), this.metadata.getReferenceFrame().getName(), null, false);
        }
        if (this.metadata.getInterpolationMethod() != null) {
            generator.writeEntry(TdmMetadataKey.INTERPOLATION.name(), this.metadata.getInterpolationMethod(), null, true);
            generator.writeEntry(TdmMetadataKey.INTERPOLATION_DEGREE.name(), Integer.toString(this.metadata.getInterpolationDegree()), null, true);
        }
        if (this.metadata.getDopplerCountBias() != 0.0) {
            generator.writeEntry(TdmMetadataKey.DOPPLER_COUNT_BIAS.name(), this.metadata.getDopplerCountBias(), Unit.HERTZ, false);
        }
        if (this.metadata.getDopplerCountScale() != 1.0) {
            generator.writeEntry(TdmMetadataKey.DOPPLER_COUNT_SCALE.name(), this.metadata.getDopplerCountScale(), Unit.ONE, false);
        }
        if (this.metadata.hasDopplerCountRollover()) {
            generator.writeEntry(TdmMetadataKey.DOPPLER_COUNT_BIAS.name(), this.metadata.hasDopplerCountRollover() ? "YES" : "NO", null, false);
        }
        generator.writeEntry(TdmMetadataKey.TRANSMIT_DELAY_1.name(), this.metadata.getTransmitDelays().get(1), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.TRANSMIT_DELAY_2.name(), this.metadata.getTransmitDelays().get(2), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.TRANSMIT_DELAY_3.name(), this.metadata.getTransmitDelays().get(3), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.TRANSMIT_DELAY_4.name(), this.metadata.getTransmitDelays().get(4), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.TRANSMIT_DELAY_5.name(), this.metadata.getTransmitDelays().get(5), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.RECEIVE_DELAY_1.name(), this.metadata.getReceiveDelays().get(1), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.RECEIVE_DELAY_2.name(), this.metadata.getReceiveDelays().get(2), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.RECEIVE_DELAY_3.name(), this.metadata.getReceiveDelays().get(3), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.RECEIVE_DELAY_4.name(), this.metadata.getReceiveDelays().get(4), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.RECEIVE_DELAY_5.name(), this.metadata.getReceiveDelays().get(5), Unit.SECOND, false);
        generator.writeEntry(TdmMetadataKey.DATA_QUALITY.name(), this.metadata.getDataQuality(), false);
        if (this.metadata.getCorrectionAngle1() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_ANGLE_1.name(), this.metadata.getCorrectionAngle1(), Unit.DEGREE, false);
        }
        if (this.metadata.getCorrectionAngle2() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_ANGLE_2.name(), this.metadata.getCorrectionAngle2(), Unit.DEGREE, false);
        }
        if (this.metadata.getCorrectionDoppler() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_DOPPLER.name(), this.metadata.getCorrectionDoppler(), Units.KM_PER_S, false);
        }
        if (this.metadata.getCorrectionMagnitude() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_MAG.name(), this.metadata.getCorrectionMagnitude(), Unit.ONE, false);
        }
        if (this.metadata.getRawCorrectionRange() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_RANGE.name(), this.metadata.getRawCorrectionRange(), Unit.ONE, false);
        }
        if (this.metadata.getCorrectionRcs() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_RCS.name(), this.metadata.getCorrectionRcs(), Units.M2, false);
        }
        if (this.metadata.getCorrectionReceive() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_RECEIVE.name(), this.metadata.getCorrectionReceive(), Unit.HERTZ, false);
        }
        if (this.metadata.getCorrectionTransmit() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_TRANSMIT.name(), this.metadata.getCorrectionTransmit(), Unit.HERTZ, false);
        }
        if (this.metadata.getCorrectionAberrationYearly() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_ABERRATION_YEARLY.name(), this.metadata.getCorrectionAberrationYearly(), Unit.DEGREE, false);
        }
        if (this.metadata.getCorrectionAberrationDiurnal() != 0.0) {
            generator.writeEntry(TdmMetadataKey.CORRECTION_ABERRATION_DIURNAL.name(), this.metadata.getCorrectionAberrationDiurnal(), Unit.DEGREE, false);
        }
        generator.writeEntry(TdmMetadataKey.CORRECTIONS_APPLIED.name(), this.metadata.getCorrectionsApplied(), false);
    }
}

