/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceWriter;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataWriter;
import org.orekit.files.ccsds.ndm.odm.OdmCommonMetadata;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParametersWriter;
import org.orekit.files.ccsds.ndm.odm.StateVectorWriter;
import org.orekit.files.ccsds.ndm.odm.UserDefinedWriter;
import org.orekit.files.ccsds.ndm.odm.opm.Maneuver;
import org.orekit.files.ccsds.ndm.odm.opm.ManeuverWriter;
import org.orekit.files.ccsds.ndm.odm.opm.Opm;
import org.orekit.files.ccsds.ndm.odm.opm.OpmData;
import org.orekit.files.ccsds.ndm.odm.opm.OsculationgKeplerianElementsWriter;
import org.orekit.files.ccsds.ndm.odm.opm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class OpmWriter
extends AbstractMessageWriter<OdmHeader, Segment<OdmCommonMetadata, OpmData>, Opm> {
    public static final double CCSDS_OPM_VERS = 3.0;
    public static final int KVN_PADDING_WIDTH = 18;

    public OpmWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("opm", "CCSDS_OPM_VERS", 3.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    protected void writeSegmentContent(Generator generator, double formatVersion, Segment<OdmCommonMetadata, OpmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        OdmCommonMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        new CommonMetadataWriter(metadata, this.getTimeConverter()).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        new StateVectorWriter(XmlSubStructureKey.stateVector.name(), null, segment.getData().getStateVectorBlock(), this.getTimeConverter()).write(generator);
        if (segment.getData().getKeplerianElementsBlock() != null) {
            new OsculationgKeplerianElementsWriter(XmlSubStructureKey.keplerianElements.name(), null, segment.getData().getKeplerianElementsBlock()).write(generator);
        }
        if (segment.getData().getSpacecraftParametersBlock() != null) {
            new SpacecraftParametersWriter(XmlSubStructureKey.spacecraftParameters.name(), null, segment.getData().getSpacecraftParametersBlock()).write(generator);
        }
        if (segment.getData().getCovarianceBlock() != null) {
            new CartesianCovarianceWriter(XmlSubStructureKey.covarianceMatrix.name(), null, segment.getData().getCovarianceBlock()).write(generator);
        }
        if (!segment.getData().getManeuvers().isEmpty()) {
            for (Maneuver maneuver : segment.getData().getManeuvers()) {
                new ManeuverWriter(maneuver, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getUserDefinedBlock() != null) {
            new UserDefinedWriter(XmlSubStructureKey.userDefinedParameters.name(), null, segment.getData().getUserDefinedBlock()).write(generator);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

