/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceKey;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataKey;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.KeplerianElementsKey;
import org.orekit.files.ccsds.ndm.odm.OdmCommonMetadata;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmParser;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParametersKey;
import org.orekit.files.ccsds.ndm.odm.StateVector;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.opm.Maneuver;
import org.orekit.files.ccsds.ndm.odm.opm.ManeuverKey;
import org.orekit.files.ccsds.ndm.odm.opm.Opm;
import org.orekit.files.ccsds.ndm.odm.opm.OpmData;
import org.orekit.files.ccsds.ndm.odm.opm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.UserDefinedXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.ErrorState;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class OpmParser
extends OdmParser<Opm, OpmParser> {
    private final double defaultMass;
    private OdmHeader header;
    private List<Segment<OdmCommonMetadata, OpmData>> segments;
    private OdmCommonMetadata metadata;
    private ContextBinding context;
    private StateVector stateVectorBlock;
    private KeplerianElements keplerianElementsBlock;
    private SpacecraftParameters spacecraftParametersBlock;
    private CartesianCovariance covarianceBlock;
    private Maneuver currentManeuver;
    private List<Maneuver> maneuverBlocks;
    private UserDefined userDefinedBlock;
    private ProcessingState structureProcessor;

    public OpmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, double mu, double defaultMass, ParsedUnitsBehavior parsedUnitsBehavior, Function<ParseToken, List<ParseToken>>[] filters) {
        super("opm", "CCSDS_OPM_VERS", conventions, simpleEOP, dataContext, missionReferenceDate, mu, parsedUnitsBehavior, filters);
        this.defaultMass = defaultMass;
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        Map<String, XmlTokenBuilder> builders = super.getSpecialXmlElementsBuilders();
        builders.put("USER_DEFINED", new UserDefinedXmlTokenBuilder());
        return builders;
    }

    @Override
    public OdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new OdmHeader();
        this.segments = new ArrayList<Segment<OdmCommonMetadata, OpmData>>();
        this.metadata = null;
        this.context = null;
        this.stateVectorBlock = null;
        this.keplerianElementsBlock = null;
        this.spacecraftParametersBlock = null;
        this.covarianceBlock = null;
        this.currentManeuver = null;
        this.maneuverBlocks = new ArrayList<Maneuver>();
        this.userDefinedBlock = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("opm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new ErrorState();
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new OdmCommonMetadata();
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this::getMissionReferenceDate, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processStateVectorToken);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.finalizeMetadata(this.context);
        this.metadata.validate(this.header.getFormatVersion());
        if (this.metadata.getCenter().getBody() != null) {
            this.setMuCreated(this.metadata.getCenter().getBody().getGM());
        }
        return true;
    }

    @Override
    public boolean prepareData() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processStateVectorToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            if (this.userDefinedBlock != null && this.userDefinedBlock.getParameters().isEmpty()) {
                this.userDefinedBlock = null;
            }
            if (this.keplerianElementsBlock != null) {
                this.keplerianElementsBlock.setEpoch(this.stateVectorBlock.getEpoch());
                if (Double.isNaN(this.keplerianElementsBlock.getMu())) {
                    this.keplerianElementsBlock.setMu(this.getSelectedMu());
                } else {
                    this.setMuParsed(this.keplerianElementsBlock.getMu());
                }
            }
            double mass = this.spacecraftParametersBlock == null ? this.defaultMass : this.spacecraftParametersBlock.getMass();
            OpmData data = new OpmData(this.stateVectorBlock, this.keplerianElementsBlock, this.spacecraftParametersBlock, this.covarianceBlock, this.maneuverBlocks, this.userDefinedBlock, mass);
            data.validate(this.header.getFormatVersion());
            this.segments.add(new Segment<OdmCommonMetadata, OpmData>(this.metadata, data));
        }
        this.metadata = null;
        this.context = null;
        this.stateVectorBlock = null;
        this.keplerianElementsBlock = null;
        this.spacecraftParametersBlock = null;
        this.covarianceBlock = null;
        this.currentManeuver = null;
        this.maneuverBlocks = null;
        this.userDefinedBlock = null;
        return true;
    }

    @Override
    public Opm build() {
        this.finalizeData();
        return new Opm(this.header, this.segments, this.getConventions(), this.getDataContext(), this.getSelectedMu());
    }

    boolean manageStateVectorSection(boolean starting) {
        this.anticipateNext(starting ? this::processStateVectorToken : this.structureProcessor);
        return true;
    }

    boolean manageKeplerianElementsSection(boolean starting) {
        this.anticipateNext(starting ? this::processKeplerianElementsToken : this.structureProcessor);
        return true;
    }

    boolean manageSpacecraftParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processSpacecraftParametersToken : this.structureProcessor);
        return true;
    }

    boolean manageCovarianceSection(boolean starting) {
        this.anticipateNext(starting ? this::processCovarianceToken : this.structureProcessor);
        return true;
    }

    boolean manageManeuversSection(boolean starting) {
        this.anticipateNext(starting ? this::processManeuverToken : this.structureProcessor);
        return true;
    }

    boolean manageUserDefinedParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processUserDefinedToken : this.structureProcessor);
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        if (this.metadata == null) {
            this.prepareMetadata();
        }
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return OdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return CommonMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    return false;
                }
            }
        }
    }

    private boolean processXmlSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && XmlSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processStateVectorToken(ParseToken token) {
        if (this.stateVectorBlock == null) {
            this.finalizeMetadata();
            this.prepareData();
            this.stateVectorBlock = new StateVector();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processKeplerianElementsToken);
        try {
            return token.getName() != null && StateVectorKey.valueOf(token.getName()).process(token, this.context, this.stateVectorBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processKeplerianElementsToken(ParseToken token) {
        if (this.keplerianElementsBlock == null) {
            this.keplerianElementsBlock = new KeplerianElements();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processSpacecraftParametersToken);
        try {
            return token.getName() != null && KeplerianElementsKey.valueOf(token.getName()).process(token, this.context, this.keplerianElementsBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processSpacecraftParametersToken(ParseToken token) {
        if (this.spacecraftParametersBlock == null) {
            this.spacecraftParametersBlock = new SpacecraftParameters();
            if (this.moveCommentsIfEmpty(this.keplerianElementsBlock, this.spacecraftParametersBlock)) {
                this.keplerianElementsBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processCovarianceToken);
        try {
            return token.getName() != null && SpacecraftParametersKey.valueOf(token.getName()).process(token, this.context, this.spacecraftParametersBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processCovarianceToken(ParseToken token) {
        if (this.covarianceBlock == null) {
            OdmCommonMetadata savedMetadata = this.metadata;
            this.covarianceBlock = new CartesianCovariance(() -> savedMetadata.getReferenceFrame());
            if (this.moveCommentsIfEmpty(this.spacecraftParametersBlock, this.covarianceBlock)) {
                this.spacecraftParametersBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processManeuverToken);
        try {
            return token.getName() != null && CartesianCovarianceKey.valueOf(token.getName()).process(token, this.context, this.covarianceBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processManeuverToken(ParseToken token) {
        if (this.currentManeuver == null) {
            this.currentManeuver = new Maneuver();
            if (this.covarianceBlock != null && this.moveCommentsIfEmpty(this.covarianceBlock, this.currentManeuver)) {
                this.covarianceBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processUserDefinedToken);
        try {
            if (token.getName() != null && ManeuverKey.valueOf(token.getName()).process(token, this.context, this.currentManeuver)) {
                if (this.currentManeuver.completed()) {
                    this.maneuverBlocks.add(this.currentManeuver);
                    this.currentManeuver = null;
                }
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private boolean processUserDefinedToken(ParseToken token) {
        if (this.userDefinedBlock == null) {
            this.userDefinedBlock = new UserDefined();
            if (this.moveCommentsIfEmpty(this.currentManeuver, this.userDefinedBlock)) {
                this.currentManeuver = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : new ErrorState());
        if (token.getName().startsWith("USER_DEFINED_")) {
            if (token.getType() == TokenType.ENTRY) {
                this.userDefinedBlock.addEntry(token.getName().substring("USER_DEFINED_".length()), token.getContentAsNormalizedString());
            }
            return true;
        }
        return false;
    }

    private boolean moveCommentsIfEmpty(CommentsContainer origin, CommentsContainer destination) {
        if (origin != null && origin.acceptComments()) {
            for (String comment : origin.getComments()) {
                destination.addComment(comment);
            }
            return true;
        }
        return false;
    }
}

