/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.opm.Maneuver;
import org.orekit.files.ccsds.ndm.odm.opm.ManeuverKey;
import org.orekit.files.ccsds.ndm.odm.opm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class ManeuverWriter
extends AbstractWriter {
    private final Maneuver maneuver;
    private final TimeConverter timeConverter;

    ManeuverWriter(Maneuver maneuver, TimeConverter timeConverter) {
        super(XmlSubStructureKey.maneuverParameters.name(), null);
        this.maneuver = maneuver;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.maneuver.getComments());
        generator.writeEntry(ManeuverKey.MAN_EPOCH_IGNITION.name(), this.timeConverter, this.maneuver.getEpochIgnition(), false, true);
        generator.writeEntry(ManeuverKey.MAN_DURATION.name(), this.maneuver.getDuration(), Unit.SECOND, true);
        generator.writeEntry(ManeuverKey.MAN_DELTA_MASS.name(), this.maneuver.getDeltaMass(), Unit.KILOGRAM, true);
        generator.writeEntry(ManeuverKey.MAN_REF_FRAME.name(), this.maneuver.getReferenceFrame().getName(), null, true);
        generator.writeEntry(ManeuverKey.MAN_DV_1.name(), this.maneuver.getDV().getX(), Units.KM_PER_S, true);
        generator.writeEntry(ManeuverKey.MAN_DV_2.name(), this.maneuver.getDV().getY(), Units.KM_PER_S, true);
        generator.writeEntry(ManeuverKey.MAN_DV_3.name(), this.maneuver.getDV().getZ(), Units.KM_PER_S, true);
    }
}

