/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.opm.Maneuver;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum ManeuverKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    MAN_EPOCH_IGNITION((token, context, container) -> token.processAsDate(container::setEpochIgnition, context)),
    MAN_REF_FRAME((token, context, container) -> token.processAsFrame(container::setReferenceFrame, context, true, true, false)),
    MAN_DURATION((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setDuration)),
    MAN_DELTA_MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setDeltaMass)),
    MAN_DV_1((token, context, container) -> token.processAsIndexedDouble(0, Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setDV)),
    MAN_DV_2((token, context, container) -> token.processAsIndexedDouble(1, Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setDV)),
    MAN_DV_3((token, context, container) -> token.processAsIndexedDouble(2, Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setDV));

    private final transient TokenProcessor processor;

    private ManeuverKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, Maneuver container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, Maneuver var3);
    }
}

