/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.opm;

import java.util.Arrays;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.opm.ManeuverKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class Maneuver
extends CommentsContainer {
    private AbsoluteDate epochIgnition;
    private FrameFacade referenceFrame;
    private double duration = Double.NaN;
    private double deltaMass = Double.NaN;
    private double[] dV = new double[3];

    public Maneuver() {
        Arrays.fill(this.dV, Double.NaN);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.epochIgnition, ManeuverKey.MAN_EPOCH_IGNITION.name());
        this.checkNotNull(this.referenceFrame, ManeuverKey.MAN_REF_FRAME.name());
        this.checkNotNaN(this.duration, ManeuverKey.MAN_DURATION.name());
        this.checkNotNaN(this.deltaMass, ManeuverKey.MAN_DELTA_MASS.name());
        this.checkNotNaN(this.dV[0], ManeuverKey.MAN_DV_1.name());
        this.checkNotNaN(this.dV[1], ManeuverKey.MAN_DV_2.name());
        this.checkNotNaN(this.dV[2], ManeuverKey.MAN_DV_3.name());
    }

    public AbsoluteDate getEpochIgnition() {
        return this.epochIgnition;
    }

    public void setEpochIgnition(AbsoluteDate epochIgnition) {
        this.epochIgnition = epochIgnition;
    }

    public FrameFacade getReferenceFrame() {
        return this.referenceFrame;
    }

    public void setReferenceFrame(FrameFacade referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDeltaMass() {
        return this.deltaMass;
    }

    public void setDeltaMass(double deltaMass) {
        this.deltaMass = deltaMass;
    }

    public Vector3D getDV() {
        return new Vector3D(this.dV);
    }

    public void setDV(int i, double dVi) {
        this.dV[i] = dVi;
    }

    public boolean completed() {
        return this.epochIgnition != null && this.referenceFrame != null && !Double.isNaN(this.duration + this.deltaMass + this.dV[0] + this.dV[1] + this.dV[2]);
    }
}

