/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import org.orekit.files.ccsds.ndm.odm.omm.OmmTleKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class OmmTle
extends CommentsContainer {
    public static final int EPHEMERIS_TYPE_SGP = 0;
    public static final int EPHEMERIS_TYPE_SGP4 = 2;
    public static final int EPHEMERIS_TYPE_PPT3 = 3;
    public static final int EPHEMERIS_TYPE_SGP4_XP = 4;
    public static final int EPHEMERIS_TYPE_SPECIAL_PERTURBATIONS = 6;
    private int ephemerisType = 0;
    private char classificationType = (char)85;
    private int noradID = -1;
    private int elementSetNo = -1;
    private int revAtEpoch = -1;
    private double bStar = Double.NaN;
    private double bTerm = Double.NaN;
    private double meanMotionDot = Double.NaN;
    private double meanMotionDotDot = Double.NaN;
    private double agOm = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNegative(this.noradID, OmmTleKey.NORAD_CAT_ID.name());
        this.checkNotNegative(this.elementSetNo, OmmTleKey.ELEMENT_SET_NO.name());
        this.checkNotNegative(this.revAtEpoch, OmmTleKey.REV_AT_EPOCH.name());
        if (this.ephemerisType == 2) {
            this.checkNotNaN(this.bStar, OmmTleKey.BSTAR.name());
        } else if (this.ephemerisType == 4) {
            this.checkNotNaN(this.bTerm, OmmTleKey.BTERM.name());
        }
        if (this.ephemerisType == 0 || this.ephemerisType == 3) {
            this.checkNotNaN(this.meanMotionDot, OmmTleKey.MEAN_MOTION_DOT.name());
        }
        if (this.ephemerisType == 0 || this.ephemerisType == 3) {
            this.checkNotNaN(this.meanMotionDotDot, OmmTleKey.MEAN_MOTION_DDOT.name());
        } else if (this.ephemerisType == 4) {
            this.checkNotNaN(this.agOm, OmmTleKey.AGOM.name());
        }
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    public void setEphemerisType(int ephemerisType) {
        this.refuseFurtherComments();
        this.ephemerisType = ephemerisType;
    }

    public char getClassificationType() {
        return this.classificationType;
    }

    public void setClassificationType(char classificationType) {
        this.refuseFurtherComments();
        this.classificationType = classificationType;
    }

    public int getNoradID() {
        return this.noradID;
    }

    public void setNoradID(int noradID) {
        this.refuseFurtherComments();
        this.noradID = noradID;
    }

    public int getElementSetNumber() {
        return this.elementSetNo;
    }

    public void setElementSetNo(int elementSetNo) {
        this.refuseFurtherComments();
        this.elementSetNo = elementSetNo;
    }

    public int getRevAtEpoch() {
        return this.revAtEpoch;
    }

    public void setRevAtEpoch(int revAtEpoch) {
        this.refuseFurtherComments();
        this.revAtEpoch = revAtEpoch;
    }

    public double getBStar() {
        return this.bStar;
    }

    public void setBStar(double bstar) {
        this.refuseFurtherComments();
        this.bStar = bstar;
    }

    public double getBTerm() {
        return this.bTerm;
    }

    public void setBTerm(double bterm) {
        this.refuseFurtherComments();
        this.bTerm = bterm;
    }

    public double getMeanMotionDot() {
        return this.meanMotionDot;
    }

    public void setMeanMotionDot(double meanMotionDot) {
        this.refuseFurtherComments();
        this.meanMotionDot = meanMotionDot;
    }

    public double getMeanMotionDotDot() {
        return this.meanMotionDotDot;
    }

    public void setMeanMotionDotDot(double meanMotionDotDot) {
        this.refuseFurtherComments();
        this.meanMotionDotDot = meanMotionDotDot;
    }

    public double getAGoM() {
        return this.agOm;
    }

    public void setAGoM(double agom) {
        this.refuseFurtherComments();
        this.agOm = agom;
    }
}

