/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceKey;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataKey;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.KeplerianElementsKey;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmParser;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParametersKey;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.omm.Omm;
import org.orekit.files.ccsds.ndm.odm.omm.OmmData;
import org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata;
import org.orekit.files.ccsds.ndm.odm.omm.OmmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTle;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTleKey;
import org.orekit.files.ccsds.ndm.odm.omm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.lexical.UserDefinedXmlTokenBuilder;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.ErrorState;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class OmmParser
extends OdmParser<Omm, OmmParser> {
    private final double defaultMass;
    private OdmHeader header;
    private List<Segment<OmmMetadata, OmmData>> segments;
    private OmmMetadata metadata;
    private ContextBinding context;
    private KeplerianElements keplerianElementsBlock;
    private SpacecraftParameters spacecraftParametersBlock;
    private OmmTle tleBlock;
    private CartesianCovariance covarianceBlock;
    private UserDefined userDefinedBlock;
    private ProcessingState structureProcessor;

    public OmmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, double mu, double defaultMass, ParsedUnitsBehavior parsedUnitsBehavior, Function<ParseToken, List<ParseToken>>[] filters) {
        super("omm", "CCSDS_OMM_VERS", conventions, simpleEOP, dataContext, missionReferenceDate, mu, parsedUnitsBehavior, filters);
        this.defaultMass = defaultMass;
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        Map<String, XmlTokenBuilder> builders = super.getSpecialXmlElementsBuilders();
        builders.put("USER_DEFINED", new UserDefinedXmlTokenBuilder());
        return builders;
    }

    @Override
    public OdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new OdmHeader();
        this.segments = new ArrayList<Segment<OmmMetadata, OmmData>>();
        this.metadata = null;
        this.context = null;
        this.keplerianElementsBlock = null;
        this.spacecraftParametersBlock = null;
        this.tleBlock = null;
        this.covarianceBlock = null;
        this.userDefinedBlock = null;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("omm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new ErrorState();
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new OmmMetadata();
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this::getMissionReferenceDate, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processKeplerianElementsToken);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.finalizeMetadata(this.context);
        this.metadata.validate(this.header.getFormatVersion());
        if (this.metadata.getCenter().getBody() != null) {
            this.setMuCreated(this.metadata.getCenter().getBody().getGM());
        }
        return true;
    }

    @Override
    public boolean prepareData() {
        this.keplerianElementsBlock = new KeplerianElements();
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processKeplerianElementsToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            if (this.userDefinedBlock != null && this.userDefinedBlock.getParameters().isEmpty()) {
                this.userDefinedBlock = null;
            }
            if (this.tleBlock != null) {
                if (Double.isNaN(this.keplerianElementsBlock.getMu())) {
                    this.keplerianElementsBlock.setMu(TLEPropagator.getMU());
                }
                double mu = this.keplerianElementsBlock.getMu();
                double n = this.keplerianElementsBlock.getMeanMotion();
                this.keplerianElementsBlock.setA(FastMath.cbrt((double)(mu / (n * n))));
                this.setMuParsed(mu);
            }
            double mass = this.spacecraftParametersBlock == null ? this.defaultMass : this.spacecraftParametersBlock.getMass();
            OmmData data = new OmmData(this.keplerianElementsBlock, this.spacecraftParametersBlock, this.tleBlock, this.covarianceBlock, this.userDefinedBlock, mass);
            data.validate(this.header.getFormatVersion());
            this.segments.add(new Segment<OmmMetadata, OmmData>(this.metadata, data));
        }
        this.metadata = null;
        this.context = null;
        this.keplerianElementsBlock = null;
        this.spacecraftParametersBlock = null;
        this.tleBlock = null;
        this.covarianceBlock = null;
        this.userDefinedBlock = null;
        return true;
    }

    @Override
    public Omm build() {
        this.finalizeData();
        return new Omm(this.header, this.segments, this.getConventions(), this.getDataContext());
    }

    boolean manageKeplerianElementsSection(boolean starting) {
        this.anticipateNext(starting ? this::processKeplerianElementsToken : this.structureProcessor);
        return true;
    }

    boolean manageSpacecraftParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processSpacecraftParametersToken : this.structureProcessor);
        return true;
    }

    boolean manageTleParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processTLEToken : this.structureProcessor);
        return true;
    }

    boolean manageCovarianceSection(boolean starting) {
        this.anticipateNext(starting ? this::processCovarianceToken : this.structureProcessor);
        return true;
    }

    boolean manageUserDefinedParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processUserDefinedToken : this.structureProcessor);
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        if (this.metadata == null) {
            this.prepareMetadata();
        }
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeG) {
            try {
                return OdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return CommonMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    try {
                        return OmmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                    }
                    catch (IllegalArgumentException iaeM) {
                        return false;
                    }
                }
            }
        }
    }

    private boolean processXmlSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && XmlSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processKeplerianElementsToken(ParseToken token) {
        if (this.keplerianElementsBlock == null) {
            this.finalizeMetadata();
            this.prepareData();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processSpacecraftParametersToken);
        try {
            return token.getName() != null && KeplerianElementsKey.valueOf(token.getName()).process(token, this.context, this.keplerianElementsBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processSpacecraftParametersToken(ParseToken token) {
        if (this.spacecraftParametersBlock == null) {
            this.spacecraftParametersBlock = new SpacecraftParameters();
            if (this.moveCommentsIfEmpty(this.keplerianElementsBlock, this.spacecraftParametersBlock)) {
                this.keplerianElementsBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processTLEToken);
        try {
            return token.getName() != null && SpacecraftParametersKey.valueOf(token.getName()).process(token, this.context, this.spacecraftParametersBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processTLEToken(ParseToken token) {
        if (this.tleBlock == null) {
            this.tleBlock = new OmmTle();
            if (this.moveCommentsIfEmpty(this.spacecraftParametersBlock, this.tleBlock)) {
                this.spacecraftParametersBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processCovarianceToken);
        try {
            return token.getName() != null && OmmTleKey.valueOf(token.getName()).process(token, this.context, this.tleBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processCovarianceToken(ParseToken token) {
        if (this.covarianceBlock == null) {
            OmmMetadata savedMetadata = this.metadata;
            this.covarianceBlock = new CartesianCovariance(() -> savedMetadata.getReferenceFrame());
            if (this.moveCommentsIfEmpty(this.tleBlock, this.covarianceBlock)) {
                this.tleBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processUserDefinedToken);
        try {
            return token.getName() != null && CartesianCovarianceKey.valueOf(token.getName()).process(token, this.context, this.covarianceBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processUserDefinedToken(ParseToken token) {
        if (this.userDefinedBlock == null) {
            this.userDefinedBlock = new UserDefined();
            if (this.moveCommentsIfEmpty(this.covarianceBlock, this.userDefinedBlock)) {
                this.covarianceBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : new ErrorState());
        if (token.getName().startsWith("USER_DEFINED_")) {
            if (token.getType() == TokenType.ENTRY) {
                this.userDefinedBlock.addEntry(token.getName().substring("USER_DEFINED_".length()), token.getContentAsNormalizedString());
            }
            return true;
        }
        return false;
    }

    private boolean moveCommentsIfEmpty(CommentsContainer origin, CommentsContainer destination) {
        if (origin != null && origin.acceptComments()) {
            for (String comment : origin.getComments()) {
                destination.addComment(comment);
            }
            return true;
        }
        return false;
    }
}

