/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.ndm.odm.KeplerianElementsKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class MeanKeplerianElementsWriter
extends AbstractWriter {
    private final KeplerianElements keplerianElements;
    private final TimeConverter timeConverter;
    private final boolean theoryIsSgpSdp;

    MeanKeplerianElementsWriter(String xmlTag, String kvnTag, KeplerianElements keplerianElements, TimeConverter timeConverter, boolean theoryIsSgpSdp) {
        super(xmlTag, kvnTag);
        this.keplerianElements = keplerianElements;
        this.timeConverter = timeConverter;
        this.theoryIsSgpSdp = theoryIsSgpSdp;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.keplerianElements.getComments());
        generator.writeEntry(KeplerianElementsKey.EPOCH.name(), this.timeConverter, this.keplerianElements.getEpoch(), true, true);
        if (this.theoryIsSgpSdp) {
            generator.writeEntry(KeplerianElementsKey.MEAN_MOTION.name(), this.keplerianElements.getMeanMotion(), Units.REV_PER_DAY, true);
        } else {
            generator.writeEntry(KeplerianElementsKey.SEMI_MAJOR_AXIS.name(), this.keplerianElements.getA(), Unit.KILOMETRE, true);
        }
        generator.writeEntry(KeplerianElementsKey.ECCENTRICITY.name(), this.keplerianElements.getE(), Unit.ONE, true);
        generator.writeEntry(KeplerianElementsKey.INCLINATION.name(), this.keplerianElements.getI(), Unit.DEGREE, true);
        generator.writeEntry(KeplerianElementsKey.RA_OF_ASC_NODE.name(), this.keplerianElements.getRaan(), Unit.DEGREE, true);
        generator.writeEntry(KeplerianElementsKey.ARG_OF_PERICENTER.name(), this.keplerianElements.getPa(), Unit.DEGREE, true);
        generator.writeEntry(KeplerianElementsKey.MEAN_ANOMALY.name(), this.keplerianElements.getAnomaly(), Unit.DEGREE, true);
        generator.writeEntry(KeplerianElementsKey.GM.name(), this.keplerianElements.getMu(), Units.KM3_PER_S2, false);
    }
}

