/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceKey;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmParser;
import org.orekit.files.ccsds.ndm.odm.StateVector;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.ndm.odm.oem.Oem;
import org.orekit.files.ccsds.ndm.odm.oem.OemData;
import org.orekit.files.ccsds.ndm.odm.oem.OemDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadata;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadataKey;
import org.orekit.files.ccsds.ndm.odm.oem.OemSegment;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.KvnStructureProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.files.general.EphemerisFileParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.Unit;

public class OemParser
extends OdmParser<Oem, OemParser>
implements EphemerisFileParser<Oem> {
    private static final String COMMENT = "COMMENT";
    private static final Pattern SPLIT_AT_BLANKS = Pattern.compile("\\s+");
    private OdmHeader header;
    private List<OemSegment> segments;
    private OemMetadata metadata;
    private ContextBinding context;
    private OemData currentBlock;
    private boolean inCovariance;
    private CartesianCovariance currentCovariance;
    private int currentRow;
    private int defaultInterpolationDegree;
    private ProcessingState structureProcessor;
    private StateVector stateVectorBlock;

    public OemParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, double mu, int defaultInterpolationDegree, ParsedUnitsBehavior parsedUnitsBehavior, Function<ParseToken, List<ParseToken>>[] filters) {
        super("oem", "CCSDS_OEM_VERS", conventions, simpleEOP, dataContext, missionReferenceDate, mu, parsedUnitsBehavior, filters);
        this.defaultInterpolationDegree = defaultInterpolationDegree;
    }

    @Override
    public Oem parse(DataSource source) {
        return (Oem)this.parseMessage(source);
    }

    @Override
    public OdmHeader getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new OdmHeader();
        this.segments = new ArrayList<OemSegment>();
        this.metadata = null;
        this.context = null;
        this.currentBlock = null;
        this.inCovariance = false;
        this.currentCovariance = null;
        this.currentRow = -1;
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("oem", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new KvnStructureProcessingState(this);
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.currentBlock != null) {
            this.finalizeData();
        }
        this.metadata = new OemMetadata(this.defaultInterpolationDegree);
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this::getMissionReferenceDate, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.structureProcessor);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.finalizeMetadata(this.context);
        this.metadata.validate(this.header.getFormatVersion());
        if (this.metadata.getCenter().getBody() != null) {
            this.setMuCreated(this.metadata.getCenter().getBody().getGM());
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processKvnDataToken);
        return true;
    }

    @Override
    public boolean prepareData() {
        this.currentBlock = new OemData();
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inData() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processKvnCovarianceToken);
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            this.currentBlock.validate(this.header.getFormatVersion());
            this.segments.add(new OemSegment(this.metadata, this.currentBlock, this.getSelectedMu()));
        }
        this.metadata = null;
        this.context = null;
        this.currentBlock = null;
        this.inCovariance = false;
        this.currentCovariance = null;
        this.currentRow = -1;
        return true;
    }

    @Override
    public Oem build() {
        this.finalizeData();
        Oem file = new Oem(this.header, this.segments, this.getConventions(), this.getDataContext(), this.getSelectedMu());
        file.checkTimeSystems();
        return file;
    }

    boolean manageXmlStateVectorSection(boolean starting) {
        if (starting) {
            this.stateVectorBlock = new StateVector();
            this.anticipateNext(this::processXmlStateVectorToken);
        } else {
            this.currentBlock.addData(this.stateVectorBlock.toTimeStampedPVCoordinates(), this.stateVectorBlock.hasAcceleration());
            this.stateVectorBlock = null;
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    boolean manageCovarianceSection(boolean starting) {
        if (starting) {
            OemMetadata savedMetadata = this.metadata;
            this.currentCovariance = new CartesianCovariance(() -> savedMetadata.getReferenceFrame());
            this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlCovarianceToken : this::processKvnCovarianceToken);
        } else {
            this.currentBlock.addCovarianceMatrix(this.currentCovariance);
            this.currentCovariance = null;
            this.anticipateNext(this.structureProcessor);
        }
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return OdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                try {
                    return CommonMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                }
                catch (IllegalArgumentException iaeC) {
                    try {
                        return OemMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
                    }
                    catch (IllegalArgumentException iaeE) {
                        return false;
                    }
                }
            }
        }
    }

    private boolean processXmlSubStructureToken(ParseToken token) {
        if (COMMENT.equals(token.getName())) {
            return token.getType() == TokenType.ENTRY ? this.currentBlock.addComment(token.getContentAsNormalizedString()) : true;
        }
        try {
            return token.getName() != null && OemDataSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processKvnDataToken(ParseToken token) {
        if (this.currentBlock == null) {
            this.prepareData();
        }
        this.inData();
        if (COMMENT.equals(token.getName())) {
            return token.getType() == TokenType.ENTRY ? this.currentBlock.addComment(token.getContentAsNormalizedString()) : true;
        }
        if (token.getType() == TokenType.RAW_LINE) {
            try {
                String[] fields = SPLIT_AT_BLANKS.split(token.getRawContent().trim());
                if (fields.length != 7 && fields.length != 10) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
                }
                this.stateVectorBlock = new StateVector();
                this.stateVectorBlock.setEpoch(this.context.getTimeSystem().getConverter(this.context).parse(fields[0]));
                this.stateVectorBlock.setP(0, Unit.KILOMETRE.toSI(Double.parseDouble(fields[1])));
                this.stateVectorBlock.setP(1, Unit.KILOMETRE.toSI(Double.parseDouble(fields[2])));
                this.stateVectorBlock.setP(2, Unit.KILOMETRE.toSI(Double.parseDouble(fields[3])));
                this.stateVectorBlock.setV(0, Units.KM_PER_S.toSI(Double.parseDouble(fields[4])));
                this.stateVectorBlock.setV(1, Units.KM_PER_S.toSI(Double.parseDouble(fields[5])));
                this.stateVectorBlock.setV(2, Units.KM_PER_S.toSI(Double.parseDouble(fields[6])));
                if (fields.length == 10) {
                    this.stateVectorBlock.setA(0, Units.KM_PER_S2.toSI(Double.parseDouble(fields[7])));
                    this.stateVectorBlock.setA(1, Units.KM_PER_S2.toSI(Double.parseDouble(fields[8])));
                    this.stateVectorBlock.setA(2, Units.KM_PER_S2.toSI(Double.parseDouble(fields[9])));
                }
                return this.currentBlock.addData(this.stateVectorBlock.toTimeStampedPVCoordinates(), this.stateVectorBlock.hasAcceleration());
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getRawContent());
            }
        }
        return false;
    }

    private boolean processXmlStateVectorToken(ParseToken token) {
        this.anticipateNext(this::processXmlSubStructureToken);
        try {
            return token.getName() != null && StateVectorKey.valueOf(token.getName()).process(token, this.context, this.stateVectorBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processKvnCovarianceToken(ParseToken token) {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processMetadataToken);
        if (token.getName() != null) {
            if (OemDataSubStructureKey.COVARIANCE.name().equals(token.getName()) || OemDataSubStructureKey.covarianceMatrix.name().equals(token.getName())) {
                this.inCovariance = token.getType() == TokenType.START;
                return true;
            }
            if (!this.inCovariance) {
                return false;
            }
            if (this.currentRow > 0) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_ELEMENT_IN_FILE, token.getName(), token.getLineNumber(), token.getFileName());
            }
            if (this.currentCovariance == null) {
                OemMetadata savedMetadata = this.metadata;
                this.currentCovariance = new CartesianCovariance(() -> savedMetadata.getReferenceFrame());
                this.currentRow = 0;
            }
            try {
                return CartesianCovarianceKey.valueOf(token.getName()).process(token, this.context, this.currentCovariance);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        try {
            String[] fields = SPLIT_AT_BLANKS.split(token.getContentAsNormalizedString().trim());
            if (fields.length != this.currentRow + 1) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
            }
            for (int j = 0; j < fields.length; ++j) {
                this.currentCovariance.setCovarianceMatrixEntry(this.currentRow, j, 1000000.0 * Double.parseDouble(fields[j]));
            }
            if (++this.currentRow == 6) {
                this.currentBlock.addCovarianceMatrix(this.currentCovariance);
                this.currentCovariance = null;
                this.currentRow = -1;
            }
            return true;
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, token.getLineNumber(), token.getFileName(), token.getContentAsNormalizedString());
        }
    }

    private boolean processXmlCovarianceToken(ParseToken token) {
        this.anticipateNext(this::processXmlSubStructureToken);
        try {
            return token.getName() != null && CartesianCovarianceKey.valueOf(token.getName()).process(token, this.context, this.currentCovariance);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }
}

