/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Data;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OemData
extends CommentsContainer
implements Data {
    private List<TimeStampedPVCoordinates> ephemeridesDataLines = new ArrayList<TimeStampedPVCoordinates>();
    private CartesianDerivativesFilter cartesianDerivativesFilter;
    private List<CartesianCovariance> covarianceMatrices = new ArrayList<CartesianCovariance>();

    public OemData() {
        this.cartesianDerivativesFilter = CartesianDerivativesFilter.USE_PVA;
    }

    public boolean addData(TimeStampedPVCoordinates data, boolean hasAcceleration) {
        this.ephemeridesDataLines.add(data);
        if (!hasAcceleration) {
            this.cartesianDerivativesFilter = CartesianDerivativesFilter.USE_PV;
        }
        return true;
    }

    public void addCovarianceMatrix(CartesianCovariance covarianceMatrix) {
        this.covarianceMatrices.add(covarianceMatrix);
    }

    public List<TimeStampedPVCoordinates> getEphemeridesDataLines() {
        return Collections.unmodifiableList(this.ephemeridesDataLines);
    }

    public CartesianDerivativesFilter getAvailableDerivatives() {
        return this.cartesianDerivativesFilter;
    }

    public List<TimeStampedPVCoordinates> getCoordinates() {
        return Collections.unmodifiableList(this.ephemeridesDataLines);
    }

    public List<CartesianCovariance> getCovarianceMatrices() {
        return Collections.unmodifiableList(this.covarianceMatrices);
    }
}

