/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.io.IOException;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.oem.OemData;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadata;
import org.orekit.files.ccsds.ndm.odm.oem.OemSegment;
import org.orekit.files.ccsds.ndm.odm.oem.OemWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractGenerator;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.KvnGenerator;
import org.orekit.files.ccsds.utils.generation.XmlGenerator;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.general.EphemerisFileWriter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class EphemerisOemWriter
implements EphemerisFileWriter {
    private final OemWriter writer;
    private final OdmHeader header;
    private final OemMetadata metadata;
    private final FileFormat fileFormat;
    private final String outputName;
    private final double maxRelativeOffset;
    private final int unitsColumn;

    public EphemerisOemWriter(OemWriter writer, OdmHeader header, OemMetadata template, FileFormat fileFormat, String outputName, double maxRelativeOffset, int unitsColumn) {
        this.writer = writer;
        this.header = header;
        this.metadata = template.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.fileFormat = fileFormat;
        this.outputName = outputName;
        this.maxRelativeOffset = maxRelativeOffset;
        this.unitsColumn = unitsColumn;
    }

    @Override
    public <C extends TimeStampedPVCoordinates, S extends EphemerisFile.EphemerisSegment<C>> void write(Appendable appendable, EphemerisFile<C, S> ephemerisFile) throws IOException {
        if (appendable == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        EphemerisFile.SatelliteEphemeris<C, S> satEphem = ephemerisFile.getSatellites().get(this.metadata.getObjectID());
        if (satEphem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.VALUE_NOT_FOUND, this.metadata.getObjectID(), "ephemerisFile");
        }
        List<S> segments = satEphem.getSegments();
        if (segments.isEmpty()) {
            return;
        }
        try (AbstractGenerator generator = this.fileFormat == FileFormat.KVN ? new KvnGenerator(appendable, 20, this.outputName, this.maxRelativeOffset, this.unitsColumn) : new XmlGenerator(appendable, 2, this.outputName, this.maxRelativeOffset, this.unitsColumn > 0, null);){
            this.writer.writeHeader(generator, this.header);
            for (EphemerisFile.EphemerisSegment segment : segments) {
                this.writeSegment(generator, segment);
            }
            this.writer.writeFooter(generator);
        }
    }

    public <C extends TimeStampedPVCoordinates, S extends EphemerisFile.EphemerisSegment<C>> void writeSegment(Generator generator, S segment) throws IOException {
        CartesianDerivativesFilter filter;
        if (segment instanceof OemSegment) {
            OemSegment oemSegment = (OemSegment)segment;
            this.metadata.setReferenceFrame(((OemMetadata)oemSegment.getMetadata()).getReferenceFrame());
        } else {
            this.metadata.setReferenceFrame(FrameFacade.map(segment.getFrame()));
        }
        this.metadata.setStartTime(segment.getStart());
        this.metadata.setStopTime(segment.getStop());
        this.metadata.setInterpolationDegree(segment.getInterpolationSamples() - 1);
        this.writer.writeMetadata(generator, this.metadata);
        this.writer.startData(generator);
        if (segment instanceof OemSegment) {
            generator.writeComments(((OemData)((OemSegment)segment).getData()).getComments());
        }
        if ((filter = segment.getAvailableDerivatives()) == CartesianDerivativesFilter.USE_P) {
            throw new OrekitException((Localizable)OrekitMessages.MISSING_VELOCITY, new Object[0]);
        }
        boolean useAcceleration = filter.equals((Object)CartesianDerivativesFilter.USE_PVA);
        for (TimeStampedPVCoordinates coordinates : segment.getCoordinates()) {
            this.writer.writeOrbitEphemerisLine(generator, this.metadata, coordinates, useAcceleration);
        }
        if (segment instanceof OemSegment) {
            this.writer.writeCovariances(generator, this.metadata, ((OemSegment)segment).getCovarianceMatrices());
        }
        this.writer.endData(generator);
    }
}

