/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.List;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitElementsType;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryState;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class TrajectoryStateHistoryWriter
extends AbstractWriter {
    private final TrajectoryStateHistory history;
    private final TimeConverter timeConverter;

    TrajectoryStateHistoryWriter(TrajectoryStateHistory trajectoryStateHistory, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.traj.name(), OcmDataSubStructureKey.TRAJ.name());
        this.history = trajectoryStateHistory;
        this.timeConverter = timeConverter;
    }

    TrajectoryStateHistory getHistory() {
        return this.history;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        this.writeMetadata(generator);
        List<Unit> units = this.history.getMetadata().getTrajType().getUnits();
        for (TrajectoryState state : this.history.getTrajectoryStates()) {
            this.writeState(generator, state, units);
        }
    }

    protected void writeMetadata(Generator generator) throws IOException {
        TrajectoryStateHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_ID.name(), metadata.getTrajID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_PREV_ID.name(), metadata.getTrajPrevID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_NEXT_ID.name(), metadata.getTrajNextID(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_BASIS.name(), metadata.getTrajBasis(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_BASIS_ID.name(), metadata.getTrajBasisID(), null, false);
        if (metadata.getInterpolationMethod() != TrajectoryStateHistoryMetadata.DEFAULT_INTERPOLATION_METHOD || metadata.getInterpolationDegree() != 3) {
            generator.writeEntry(TrajectoryStateHistoryMetadataKey.INTERPOLATION.name(), metadata.getInterpolationMethod(), false);
            generator.writeEntry(TrajectoryStateHistoryMetadataKey.INTERPOLATION_DEGREE.name(), metadata.getInterpolationDegree(), false);
        }
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.PROPAGATOR.name(), metadata.getPropagator(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.CENTER_NAME.name(), metadata.getCenter().getName(), null, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_REF_FRAME.name(), metadata.getTrajReferenceFrame().getName(), null, false);
        if (!metadata.getTrajFrameEpoch().equals(this.timeConverter.getReferenceDate())) {
            generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_FRAME_EPOCH.name(), this.timeConverter, metadata.getTrajFrameEpoch(), true, false);
        }
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.USEABLE_START_TIME.name(), this.timeConverter, metadata.getUseableStartTime(), false, false);
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.USEABLE_STOP_TIME.name(), this.timeConverter, metadata.getUseableStopTime(), false, false);
        if (metadata.getOrbRevNum() > 0) {
            generator.writeEntry(TrajectoryStateHistoryMetadataKey.ORB_REVNUM.name(), metadata.getOrbRevNum(), false);
            generator.writeEntry(TrajectoryStateHistoryMetadataKey.ORB_REVNUM_BASIS.name(), metadata.getOrbRevNumBasis(), false);
        }
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_TYPE.name(), metadata.getTrajType(), true);
        if (metadata.getTrajType() != OrbitElementsType.CARTP && metadata.getTrajType() != OrbitElementsType.CARTPV && metadata.getTrajType() != OrbitElementsType.CARTPVA) {
            generator.writeEntry(TrajectoryStateHistoryMetadataKey.ORB_AVERAGING.name(), metadata.getOrbAveraging(), null, true);
        }
        generator.writeEntry(TrajectoryStateHistoryMetadataKey.TRAJ_UNITS.name(), generator.unitsListToString(metadata.getTrajUnits()), null, false);
    }

    protected void writeState(Generator generator, TrajectoryState state, List<Unit> units) throws IOException {
        double[] elements = state.getElements();
        StringBuilder line = new StringBuilder();
        line.append(generator.dateToString(this.timeConverter, state.getDate()));
        for (int i = 0; i < units.size(); ++i) {
            line.append(' ');
            line.append(AccurateFormatter.format(units.get(i).fromSI(elements[i])));
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.writeEntry("trajLine", line.toString(), null, true);
        } else {
            generator.writeRawData(line);
            generator.newLine();
        }
    }
}

