/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.CelestialBodyFrame;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitElementsType;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.oem.InterpolationMethod;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.units.Unit;

public class TrajectoryStateHistoryMetadata
extends CommentsContainer {
    public static final InterpolationMethod DEFAULT_INTERPOLATION_METHOD = InterpolationMethod.HERMITE;
    public static final int DEFAULT_INTERPOLATION_DEGREE = 3;
    private String trajID;
    private String trajPrevID;
    private String trajNextID;
    private String trajBasis = "PREDICTED";
    private String trajBasisID;
    private InterpolationMethod interpolationMethod = DEFAULT_INTERPOLATION_METHOD;
    private int interpolationDegree = 3;
    private String propagator;
    private BodyFacade center;
    private FrameFacade trajReferenceFrame;
    private AbsoluteDate trajFrameEpoch;
    private AbsoluteDate useableStartTime;
    private AbsoluteDate useableStopTime;
    private int orbRevNum;
    private int orbRevNumBasis;
    private OrbitElementsType trajType;
    private String orbAveraging = "OSCULATING";
    private List<Unit> trajUnits;
    private final DataContext dataContext;

    public TrajectoryStateHistoryMetadata(AbsoluteDate epochT0, DataContext dataContext) {
        this.center = new BodyFacade("EARTH", dataContext.getCelestialBodies().getEarth());
        this.trajReferenceFrame = new FrameFacade(dataContext.getFrames().getICRF(), CelestialBodyFrame.ICRF, null, null, CelestialBodyFrame.ICRF.name());
        this.trajFrameEpoch = epochT0;
        this.trajType = OrbitElementsType.CARTPV;
        this.orbRevNum = -1;
        this.orbRevNumBasis = -1;
        this.dataContext = dataContext;
    }

    @Override
    public void validate(double version) {
        this.checkMandatoryEntriesExceptOrbitsCounter(version);
        if (this.orbRevNum >= 0 && this.orbRevNumBasis < 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, TrajectoryStateHistoryMetadataKey.ORB_REVNUM_BASIS.name());
        }
    }

    private void checkMandatoryEntriesExceptOrbitsCounter(double version) {
        super.validate(version);
        if (this.trajType != OrbitElementsType.CARTP && this.trajType != OrbitElementsType.CARTPV && this.trajType != OrbitElementsType.CARTPVA) {
            this.checkNotNull(this.orbAveraging, TrajectoryStateHistoryMetadataKey.ORB_AVERAGING.name());
        }
        if (this.trajUnits != null) {
            Unit.ensureCompatible(this.trajType.toString(), this.trajType.getUnits(), false, this.trajUnits);
        }
    }

    public static String incrementTrajID(String original) {
        int end;
        if (original == null) {
            return null;
        }
        for (end = original.length(); end > 0 && Character.isDigit(original.charAt(end - 1)); --end) {
        }
        String prefix = original.substring(0, end);
        int index = end < original.length() ? Integer.parseInt(original.substring(end)) : 0;
        String newIndex = String.format(String.format("%%0%dd", original.length() - end), index + 1);
        return prefix + newIndex;
    }

    public String getTrajID() {
        return this.trajID;
    }

    public void setTrajID(String trajID) {
        this.refuseFurtherComments();
        this.trajID = trajID;
    }

    public String getTrajPrevID() {
        return this.trajPrevID;
    }

    public void setTrajPrevID(String trajPrevID) {
        this.refuseFurtherComments();
        this.trajPrevID = trajPrevID;
    }

    public String getTrajNextID() {
        return this.trajNextID;
    }

    public void setTrajNextID(String trajNextID) {
        this.refuseFurtherComments();
        this.trajNextID = trajNextID;
    }

    public String getTrajBasis() {
        return this.trajBasis;
    }

    public void setTrajBasis(String trajBasis) {
        this.refuseFurtherComments();
        this.trajBasis = trajBasis;
    }

    public String getTrajBasisID() {
        return this.trajBasisID;
    }

    public void setTrajBasisID(String trajBasisID) {
        this.refuseFurtherComments();
        this.trajBasisID = trajBasisID;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(InterpolationMethod interpolationMethod) {
        this.refuseFurtherComments();
        this.interpolationMethod = interpolationMethod;
    }

    public int getInterpolationDegree() {
        return this.interpolationDegree;
    }

    public void setInterpolationDegree(int interpolationDegree) {
        this.refuseFurtherComments();
        this.interpolationDegree = interpolationDegree;
    }

    public String getPropagator() {
        return this.propagator;
    }

    public void setPropagator(String propagator) {
        this.refuseFurtherComments();
        this.propagator = propagator;
    }

    public BodyFacade getCenter() {
        return this.center;
    }

    public void setCenter(BodyFacade center) {
        this.refuseFurtherComments();
        this.center = center;
    }

    public FrameFacade getTrajReferenceFrame() {
        return this.trajReferenceFrame;
    }

    public void setTrajReferenceFrame(FrameFacade trajReferenceFrame) {
        this.refuseFurtherComments();
        this.trajReferenceFrame = trajReferenceFrame;
    }

    public AbsoluteDate getTrajFrameEpoch() {
        return this.trajFrameEpoch;
    }

    public void setTrajFrameEpoch(AbsoluteDate trajFrameEpoch) {
        this.refuseFurtherComments();
        this.trajFrameEpoch = trajFrameEpoch;
    }

    public AbsoluteDate getUseableStartTime() {
        return this.useableStartTime;
    }

    public void setUseableStartTime(AbsoluteDate useableStartTime) {
        this.refuseFurtherComments();
        this.useableStartTime = useableStartTime;
    }

    public AbsoluteDate getUseableStopTime() {
        return this.useableStopTime;
    }

    public void setUseableStopTime(AbsoluteDate useableStopTime) {
        this.refuseFurtherComments();
        this.useableStopTime = useableStopTime;
    }

    public int getOrbRevNum() {
        return this.orbRevNum;
    }

    public void setOrbRevNum(int orbRevNum) {
        this.orbRevNum = orbRevNum;
    }

    public int getOrbRevNumBasis() {
        return this.orbRevNumBasis;
    }

    public void setOrbRevNumBasis(int orbRevNumBasis) {
        this.orbRevNumBasis = orbRevNumBasis;
    }

    public String getOrbAveraging() {
        return this.orbAveraging;
    }

    public void setOrbAveraging(String orbAveraging) {
        this.refuseFurtherComments();
        this.orbAveraging = orbAveraging;
    }

    public OrbitElementsType getTrajType() {
        return this.trajType;
    }

    public void setTrajType(OrbitElementsType trajType) {
        this.refuseFurtherComments();
        this.trajType = trajType;
    }

    public List<Unit> getTrajUnits() {
        return this.trajUnits;
    }

    public void setTrajUnits(List<Unit> trajUnits) {
        this.refuseFurtherComments();
        this.trajUnits = trajUnits;
    }

    public TrajectoryStateHistoryMetadata copy(double version) {
        this.checkMandatoryEntriesExceptOrbitsCounter(version);
        TrajectoryStateHistoryMetadata copy = new TrajectoryStateHistoryMetadata(this.trajFrameEpoch, this.dataContext);
        for (String comment : this.getComments()) {
            copy.addComment(comment);
        }
        copy.setTrajPrevID(this.getTrajPrevID());
        copy.setTrajID(this.getTrajID());
        copy.setTrajNextID(this.getTrajNextID());
        copy.setTrajBasis(this.getTrajBasis());
        copy.setTrajBasisID(this.getTrajBasisID());
        copy.setInterpolationMethod(this.getInterpolationMethod());
        copy.setInterpolationDegree(this.getInterpolationDegree());
        copy.setPropagator(this.getPropagator());
        copy.setCenter(this.getCenter());
        copy.setTrajReferenceFrame(this.getTrajReferenceFrame());
        copy.setTrajFrameEpoch(this.getTrajFrameEpoch());
        copy.setOrbRevNumBasis(this.getOrbRevNumBasis());
        copy.setOrbAveraging(this.getOrbAveraging());
        copy.setTrajType(this.getTrajType());
        copy.setTrajUnits(this.getTrajUnits());
        return copy;
    }
}

