/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryState;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadata;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TrajectoryStateHistory
implements EphemerisFile.EphemerisSegment<TimeStampedPVCoordinates> {
    private final TrajectoryStateHistoryMetadata metadata;
    private final List<TrajectoryState> states;
    private final double mu;
    private final OneAxisEllipsoid body;

    public TrajectoryStateHistory(TrajectoryStateHistoryMetadata metadata, List<TrajectoryState> states, OneAxisEllipsoid body, double mu) {
        this.metadata = metadata;
        this.states = states;
        this.mu = mu;
        this.body = body;
    }

    public TrajectoryStateHistoryMetadata getMetadata() {
        return this.metadata;
    }

    public List<TrajectoryState> getTrajectoryStates() {
        return Collections.unmodifiableList(this.states);
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    @Override
    public Frame getFrame() {
        Frame frame = this.metadata.getTrajReferenceFrame().asFrame();
        if (frame == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.metadata.getTrajReferenceFrame().getName());
        }
        return frame;
    }

    @Override
    public int getInterpolationSamples() {
        return this.metadata.getInterpolationDegree() + 1;
    }

    @Override
    public CartesianDerivativesFilter getAvailableDerivatives() {
        return this.states.get(0).getAvailableDerivatives();
    }

    @Override
    public AbsoluteDate getStart() {
        return this.states.get(0).getDate();
    }

    @Override
    public AbsoluteDate getStop() {
        return this.states.get(this.states.size() - 1).getDate();
    }

    @Override
    public List<TimeStampedPVCoordinates> getCoordinates() {
        return this.states.stream().map(os -> os.toCartesian(this.body, this.mu)).collect(Collectors.toList());
    }
}

