/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitElementsType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.units.Unit;

public class TrajectoryState
implements TimeStamped {
    private final OrbitElementsType type;
    private final AbsoluteDate date;
    private final double[] elements;

    public TrajectoryState(OrbitElementsType type, AbsoluteDate date, String[] fields, int first, List<Unit> units) {
        this.type = type;
        this.date = date;
        this.elements = new double[units.size()];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = units.get(i).toSI(Double.parseDouble(fields[first + i]));
        }
    }

    public TrajectoryState(OrbitElementsType type, AbsoluteDate date, double[] elements) {
        this.type = type;
        this.date = date;
        this.elements = (double[])elements.clone();
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public double[] getElements() {
        return (double[])this.elements.clone();
    }

    public OrbitElementsType getType() {
        return this.type;
    }

    public CartesianDerivativesFilter getAvailableDerivatives() {
        return this.type == OrbitElementsType.CARTP ? CartesianDerivativesFilter.USE_P : (this.type == OrbitElementsType.CARTPVA ? CartesianDerivativesFilter.USE_PVA : CartesianDerivativesFilter.USE_PV);
    }

    public TimeStampedPVCoordinates toCartesian(OneAxisEllipsoid body, double mu) {
        return this.type.toCartesian(this.date, this.elements, body, mu);
    }
}

