/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.Collections;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadataWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitElementsType;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryState;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryWriter;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class StreamingOcmWriter
implements AutoCloseable {
    private final Generator generator;
    private final OcmWriter writer;
    private TrajectoryStateHistoryWriter trajectoryWriter;
    private final OdmHeader header;
    private final OcmMetadata metadata;
    private final TrajectoryStateHistoryMetadata trajectoryMetadata;
    private final boolean useAttitudeFrame;
    private boolean headerWritePending;
    private double lastZ;

    public StreamingOcmWriter(Generator generator, OcmWriter writer, OdmHeader header, OcmMetadata metadata, TrajectoryStateHistoryMetadata template) {
        this(generator, writer, header, metadata, template, true);
    }

    public StreamingOcmWriter(Generator generator, OcmWriter writer, OdmHeader header, OcmMetadata metadata, TrajectoryStateHistoryMetadata template, boolean useAttitudeFrame) {
        this.generator = generator;
        this.writer = writer;
        this.header = header;
        this.metadata = metadata;
        this.trajectoryMetadata = template.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.useAttitudeFrame = useAttitudeFrame;
        this.headerWritePending = true;
        this.lastZ = Double.NaN;
    }

    public BlockWriter newBlock() {
        return new BlockWriter();
    }

    @Override
    public void close() throws IOException {
        this.writer.writeFooter(this.generator);
    }

    public class BlockWriter
    implements OrekitFixedStepHandler {
        private Frame frame;
        private OrbitElementsType type;
        private int crossings;

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t, double step) {
            try {
                AbsoluteDate date = s0.getDate();
                if (t.isBefore(date)) {
                    throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICALLY_SORTED_ENTRIES, date, t, date.durationFrom(t));
                }
                if (StreamingOcmWriter.this.headerWritePending) {
                    StreamingOcmWriter.this.writer.writeHeader(StreamingOcmWriter.this.generator, StreamingOcmWriter.this.header);
                    if (StreamingOcmWriter.this.generator.getFormat() == FileFormat.XML) {
                        StreamingOcmWriter.this.generator.enterSection(XmlStructureKey.segment.name());
                    }
                    new OcmMetadataWriter(StreamingOcmWriter.this.metadata, StreamingOcmWriter.this.writer.getTimeConverter()).write(StreamingOcmWriter.this.generator);
                    if (StreamingOcmWriter.this.generator.getFormat() == FileFormat.XML) {
                        StreamingOcmWriter.this.generator.enterSection(XmlStructureKey.data.name());
                    }
                    StreamingOcmWriter.this.headerWritePending = false;
                }
                StreamingOcmWriter.this.trajectoryMetadata.setTrajNextID(TrajectoryStateHistoryMetadata.incrementTrajID(StreamingOcmWriter.this.trajectoryMetadata.getTrajID()));
                StreamingOcmWriter.this.trajectoryMetadata.setUseableStartTime(date);
                StreamingOcmWriter.this.trajectoryMetadata.setUseableStopTime(t);
                if (StreamingOcmWriter.this.useAttitudeFrame) {
                    this.frame = s0.getAttitude().getReferenceFrame();
                    StreamingOcmWriter.this.trajectoryMetadata.setTrajReferenceFrame(FrameFacade.map(this.frame));
                } else {
                    this.frame = StreamingOcmWriter.this.trajectoryMetadata.getTrajReferenceFrame().asFrame();
                }
                this.crossings = 0;
                this.type = StreamingOcmWriter.this.trajectoryMetadata.getTrajType();
                OneAxisEllipsoid body = StreamingOcmWriter.this.trajectoryMetadata.getTrajType() == OrbitElementsType.GEODETIC ? new OneAxisEllipsoid(StreamingOcmWriter.this.writer.getEquatorialRadius(), StreamingOcmWriter.this.writer.getFlattening(), StreamingOcmWriter.this.trajectoryMetadata.getTrajReferenceFrame().asFrame()) : null;
                StreamingOcmWriter.this.trajectoryWriter = new TrajectoryStateHistoryWriter(new TrajectoryStateHistory(StreamingOcmWriter.this.trajectoryMetadata, Collections.emptyList(), body, s0.getMu()), StreamingOcmWriter.this.writer.getTimeConverter());
                StreamingOcmWriter.this.trajectoryWriter.enterSection(StreamingOcmWriter.this.generator);
                StreamingOcmWriter.this.trajectoryWriter.writeMetadata(StreamingOcmWriter.this.generator);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void handleStep(SpacecraftState currentState) {
            try {
                TimeStampedPVCoordinates pv = currentState.getPVCoordinates(this.frame);
                if (StreamingOcmWriter.this.lastZ < 0.0 && pv.getPosition().getZ() >= 0.0) {
                    ++this.crossings;
                }
                StreamingOcmWriter.this.lastZ = pv.getPosition().getZ();
                TrajectoryState state = new TrajectoryState(this.type, pv.getDate(), this.type.toRawElements(pv, this.frame, StreamingOcmWriter.this.trajectoryWriter.getHistory().getBody(), currentState.getMu()));
                StreamingOcmWriter.this.trajectoryWriter.writeState(StreamingOcmWriter.this.generator, state, this.type.getUnits());
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void finish(SpacecraftState finalState) {
            try {
                StreamingOcmWriter.this.trajectoryWriter.exitSection(StreamingOcmWriter.this.generator);
                StreamingOcmWriter.this.trajectoryMetadata.setTrajPrevID(StreamingOcmWriter.this.trajectoryMetadata.getTrajID());
                StreamingOcmWriter.this.trajectoryMetadata.setTrajID(StreamingOcmWriter.this.trajectoryMetadata.getTrajNextID());
                if (StreamingOcmWriter.this.trajectoryMetadata.getOrbRevNum() >= 0) {
                    StreamingOcmWriter.this.trajectoryMetadata.setOrbRevNum(StreamingOcmWriter.this.trajectoryMetadata.getOrbRevNum() + this.crossings);
                }
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }
    }
}

