/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.ArrayList;
import org.orekit.files.ccsds.definitions.BodyFacade;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.Perturbations;
import org.orekit.files.ccsds.ndm.odm.ocm.PerturbationsKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class PerturbationsWriter
extends AbstractWriter {
    private final Perturbations perturbations;
    private final TimeConverter timeConverter;

    PerturbationsWriter(Perturbations perturbations, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.pert.name(), OcmDataSubStructureKey.PERT.name());
        this.perturbations = perturbations;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        ArrayList<String> names;
        generator.writeComments(this.perturbations.getComments());
        generator.writeEntry(PerturbationsKey.ATMOSPHERIC_MODEL.name(), this.perturbations.getAtmosphericModel(), null, false);
        if (this.perturbations.getGravityModel() != null) {
            String model = this.perturbations.getGravityModel() + ": " + this.perturbations.getGravityDegree() + "D " + this.perturbations.getGravityOrder() + 'O';
            generator.writeEntry(PerturbationsKey.GRAVITY_MODEL.name(), model, null, false);
        }
        generator.writeEntry(PerturbationsKey.EQUATORIAL_RADIUS.name(), this.perturbations.getEquatorialRadius(), Unit.KILOMETRE, false);
        generator.writeEntry(PerturbationsKey.GM.name(), this.perturbations.getGm(), Units.KM3_PER_S2, false);
        if (this.perturbations.getNBodyPerturbations() != null && !this.perturbations.getNBodyPerturbations().isEmpty()) {
            names = new ArrayList<String>();
            for (BodyFacade bf : this.perturbations.getNBodyPerturbations()) {
                names.add(bf.getName());
            }
            generator.writeEntry(PerturbationsKey.N_BODY_PERTURBATIONS.name(), names, false);
        }
        generator.writeEntry(PerturbationsKey.CENTRAL_BODY_ROTATION.name(), this.perturbations.getCentralBodyRotation(), Units.DEG_PER_S, false);
        generator.writeEntry(PerturbationsKey.OBLATE_FLATTENING.name(), this.perturbations.getOblateFlattening(), Unit.ONE, false);
        generator.writeEntry(PerturbationsKey.OCEAN_TIDES_MODEL.name(), this.perturbations.getOceanTidesModel(), null, false);
        generator.writeEntry(PerturbationsKey.SOLID_TIDES_MODEL.name(), this.perturbations.getSolidTidesModel(), null, false);
        generator.writeEntry(PerturbationsKey.REDUCTION_THEORY.name(), this.perturbations.getReductionTheory(), null, false);
        generator.writeEntry(PerturbationsKey.ALBEDO_MODEL.name(), this.perturbations.getAlbedoModel(), null, false);
        generator.writeEntry(PerturbationsKey.ALBEDO_GRID_SIZE.name(), this.perturbations.getAlbedoGridSize(), false);
        generator.writeEntry(PerturbationsKey.SHADOW_MODEL.name(), this.perturbations.getShadowModel(), false);
        if (this.perturbations.getShadowBodies() != null && !this.perturbations.getShadowBodies().isEmpty()) {
            names = new ArrayList();
            for (BodyFacade bf : this.perturbations.getShadowBodies()) {
                names.add(bf.getName());
            }
            generator.writeEntry(PerturbationsKey.SHADOW_BODIES.name(), names, false);
        }
        generator.writeEntry(PerturbationsKey.SRP_MODEL.name(), this.perturbations.getSrpModel(), null, false);
        generator.writeEntry(PerturbationsKey.SW_DATA_SOURCE.name(), this.perturbations.getSpaceWeatherSource(), null, false);
        generator.writeEntry(PerturbationsKey.SW_DATA_EPOCH.name(), this.timeConverter, this.perturbations.getSpaceWeatherEpoch(), true, false);
        generator.writeEntry(PerturbationsKey.SW_INTERP_METHOD.name(), this.perturbations.getInterpMethodSW(), null, false);
        generator.writeEntry(PerturbationsKey.FIXED_GEOMAG_KP.name(), this.perturbations.getFixedGeomagneticKp(), Units.NANO_TESLA, false);
        generator.writeEntry(PerturbationsKey.FIXED_GEOMAG_AP.name(), this.perturbations.getFixedGeomagneticAp(), Units.NANO_TESLA, false);
        generator.writeEntry(PerturbationsKey.FIXED_GEOMAG_DST.name(), this.perturbations.getFixedGeomagneticDst(), Units.NANO_TESLA, false);
        generator.writeEntry(PerturbationsKey.FIXED_F10P7.name(), this.perturbations.getFixedF10P7(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_F10P7_MEAN.name(), this.perturbations.getFixedF10P7Mean(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_M10P7.name(), this.perturbations.getFixedM10P7(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_M10P7_MEAN.name(), this.perturbations.getFixedM10P7Mean(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_S10P7.name(), this.perturbations.getFixedS10P7(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_S10P7_MEAN.name(), this.perturbations.getFixedS10P7Mean(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_Y10P7.name(), this.perturbations.getFixedY10P7(), Unit.SOLAR_FLUX_UNIT, false);
        generator.writeEntry(PerturbationsKey.FIXED_Y10P7_MEAN.name(), this.perturbations.getFixedY10P7Mean(), Unit.SOLAR_FLUX_UNIT, false);
    }
}

