/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitPhysicalProperties;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum OrbitPhysicalPropertiesKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    MANUFACTURER((token, context, container) -> token.processAsFreeTextString(container::setManufacturer)),
    BUS_MODEL((token, context, container) -> token.processAsFreeTextString(container::setBusModel)),
    DOCKED_WITH((token, context, container) -> token.processAsFreeTextList(container::setDockedWith)),
    DRAG_CONST_AREA((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setDragConstantArea)),
    DRAG_COEFF_NOM((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setDragCoefficient)),
    DRAG_UNCERTAINTY((token, context, container) -> token.processAsDouble(Unit.PERCENT, context.getParsedUnitsBehavior(), container::setDragUncertainty)),
    INITIAL_WET_MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setInitialWetMass)),
    WET_MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setWetMass)),
    DRY_MASS((token, context, container) -> token.processAsDouble(Unit.KILOGRAM, context.getParsedUnitsBehavior(), container::setDryMass)),
    OEB_PARENT_FRAME((token, context, container) -> token.processAsFrame(container::setOebParentFrame, context, true, true, false)),
    OEB_PARENT_FRAME_EPOCH((token, context, container) -> token.processAsDate(container::setOebParentFrameEpoch, context)),
    OEB_Q1((token, context, container) -> token.processAsIndexedDouble(1, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_Q2((token, context, container) -> token.processAsIndexedDouble(2, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_Q3((token, context, container) -> token.processAsIndexedDouble(3, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_QC((token, context, container) -> token.processAsIndexedDouble(0, Unit.ONE, context.getParsedUnitsBehavior(), container::setOebQ)),
    OEB_MAX((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setOebMax)),
    OEB_INT((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setOebIntermediate)),
    OEB_MIN((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setOebMin)),
    AREA_ALONG_OEB_MAX((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setOebAreaAlongMax)),
    AREA_ALONG_OEB_INT((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setOebAreaAlongIntermediate)),
    AREA_ALONG_OEB_MIN((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setOebAreaAlongMin)),
    AREA_MIN_FOR_PC((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setMinAreaForCollisionProbability)),
    AREA_MAX_FOR_PC((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setMaxAreaForCollisionProbability)),
    AREA_TYP_FOR_PC((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setTypAreaForCollisionProbability)),
    RCS((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setRcs)),
    RCS_MIN((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setMinRcs)),
    RCS_MAX((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setMaxRcs)),
    SRP_CONST_AREA((token, context, container) -> token.processAsDouble(Units.M2, context.getParsedUnitsBehavior(), container::setSrpConstantArea)),
    SOLAR_RAD_COEFF((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setSrpCoefficient)),
    SOLAR_RAD_UNCERTAINTY((token, context, container) -> token.processAsDouble(Unit.PERCENT, context.getParsedUnitsBehavior(), container::setSrpUncertainty)),
    VM_ABSOLUTE((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmAbsolute)),
    VM_APPARENT_MIN((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmApparentMin)),
    VM_APPARENT((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmApparent)),
    VM_APPARENT_MAX((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setVmApparentMax)),
    REFLECTANCE((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setReflectance)),
    ATT_CONTROL_MODE((token, context, container) -> token.processAsFreeTextString(container::setAttitudeControlMode)),
    ATT_ACTUATOR_TYPE((token, context, container) -> token.processAsFreeTextString(container::setAttitudeActuatorType)),
    ATT_KNOWLEDGE((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setAttitudeKnowledgeAccuracy)),
    ATT_CONTROL((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setAttitudeControlAccuracy)),
    ATT_POINTING((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setAttitudePointingAccuracy)),
    AVG_MANEUVER_FREQ((token, context, container) -> token.processAsDouble(Units.NB_PER_Y, context.getParsedUnitsBehavior(), container::setManeuversFrequency)),
    MAX_THRUST((token, context, container) -> token.processAsDouble(Unit.NEWTON, context.getParsedUnitsBehavior(), container::setMaxThrust)),
    DV_BOL((token, context, container) -> token.processAsDouble(Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setBolDv)),
    DV_REMAINING((token, context, container) -> token.processAsDouble(Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setRemainingDv)),
    IXX((token, context, container) -> token.processAsDoublyIndexedDouble(0, 0, Units.KG_M2, context.getParsedUnitsBehavior(), container::setInertiaMatrixEntry)),
    IYY((token, context, container) -> token.processAsDoublyIndexedDouble(1, 1, Units.KG_M2, context.getParsedUnitsBehavior(), container::setInertiaMatrixEntry)),
    IZZ((token, context, container) -> token.processAsDoublyIndexedDouble(2, 2, Units.KG_M2, context.getParsedUnitsBehavior(), container::setInertiaMatrixEntry)),
    IXY((token, context, container) -> token.processAsDoublyIndexedDouble(0, 1, Units.KG_M2, context.getParsedUnitsBehavior(), container::setInertiaMatrixEntry)),
    IXZ((token, context, container) -> token.processAsDoublyIndexedDouble(0, 2, Units.KG_M2, context.getParsedUnitsBehavior(), container::setInertiaMatrixEntry)),
    IYZ((token, context, container) -> token.processAsDoublyIndexedDouble(1, 2, Units.KG_M2, context.getParsedUnitsBehavior(), container::setInertiaMatrixEntry));

    private final transient TokenProcessor processor;

    private OrbitPhysicalPropertiesKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, OrbitPhysicalProperties data) {
        return this.processor.process(token, context, data);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, OrbitPhysicalProperties var3);
    }
}

