/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.ndm.CommonPhysicalProperties;
import org.orekit.time.AbsoluteDate;

public class OrbitPhysicalProperties
extends CommonPhysicalProperties {
    private String manufacturer;
    private String busModel;
    private List<String> dockedWith = new ArrayList<String>();
    private double dragConstantArea = Double.NaN;
    private double dragCoefficient = Double.NaN;
    private double dragUncertainty = 0.0;
    private double initialWetMass = Double.NaN;
    private double wetMass = Double.NaN;
    private double dryMass = Double.NaN;
    private double minAreaForCollisionProbability = Double.NaN;
    private double maxAreaForCollisionProbability = Double.NaN;
    private double typAreaForCollisionProbability = Double.NaN;
    private double srpConstantArea;
    private double srpCoefficient;
    private double srpUncertainty;
    private String attitudeControlMode;
    private String attitudeActuatorType;
    private double attitudeKnowledgeAccuracy = Double.NaN;
    private double attitudeControlAccuracy = Double.NaN;
    private double attitudePointingAccuracy = Double.NaN;
    private double maneuversFrequency = Double.NaN;
    private double maxThrust = Double.NaN;
    private double bolDv = Double.NaN;
    private double remainingDv = Double.NaN;
    private RealMatrix inertiaMatrix = MatrixUtils.createRealMatrix((int)3, (int)3);

    public OrbitPhysicalProperties(AbsoluteDate epochT0) {
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.refuseFurtherComments();
        this.manufacturer = manufacturer;
    }

    public String getBusModel() {
        return this.busModel;
    }

    public void setBusModel(String busModel) {
        this.refuseFurtherComments();
        this.busModel = busModel;
    }

    public List<String> getDockedWith() {
        return this.dockedWith;
    }

    public void setDockedWith(List<String> dockedWith) {
        this.refuseFurtherComments();
        this.dockedWith = dockedWith;
    }

    public double getDragConstantArea() {
        return this.dragConstantArea;
    }

    public void setDragConstantArea(double dragConstantArea) {
        this.refuseFurtherComments();
        this.dragConstantArea = dragConstantArea;
    }

    public double getDragCoefficient() {
        return this.dragCoefficient;
    }

    public void setDragCoefficient(double dragCoefficient) {
        this.refuseFurtherComments();
        this.dragCoefficient = dragCoefficient;
    }

    public double getDragUncertainty() {
        return this.dragUncertainty;
    }

    public void setDragUncertainty(double dragUncertainty) {
        this.refuseFurtherComments();
        this.dragUncertainty = dragUncertainty;
    }

    public double getInitialWetMass() {
        return this.initialWetMass;
    }

    public void setInitialWetMass(double initialWetMass) {
        this.refuseFurtherComments();
        this.initialWetMass = initialWetMass;
    }

    public double getWetMass() {
        return this.wetMass;
    }

    public void setWetMass(double wetMass) {
        this.refuseFurtherComments();
        this.wetMass = wetMass;
    }

    public double getDryMass() {
        return this.dryMass;
    }

    public void setDryMass(double dryMass) {
        this.refuseFurtherComments();
        this.dryMass = dryMass;
    }

    public double getMinAreaForCollisionProbability() {
        return this.minAreaForCollisionProbability;
    }

    public void setMinAreaForCollisionProbability(double minAreaForCollisionProbability) {
        this.refuseFurtherComments();
        this.minAreaForCollisionProbability = minAreaForCollisionProbability;
    }

    public double getMaxAreaForCollisionProbability() {
        return this.maxAreaForCollisionProbability;
    }

    public void setMaxAreaForCollisionProbability(double maxAreaForCollisionProbability) {
        this.refuseFurtherComments();
        this.maxAreaForCollisionProbability = maxAreaForCollisionProbability;
    }

    public double getTypAreaForCollisionProbability() {
        return this.typAreaForCollisionProbability;
    }

    public void setTypAreaForCollisionProbability(double typAreaForCollisionProbability) {
        this.refuseFurtherComments();
        this.typAreaForCollisionProbability = typAreaForCollisionProbability;
    }

    public double getSrpConstantArea() {
        return this.srpConstantArea;
    }

    public void setSrpConstantArea(double srpConstantArea) {
        this.refuseFurtherComments();
        this.srpConstantArea = srpConstantArea;
    }

    public double getSrpCoefficient() {
        return this.srpCoefficient;
    }

    public void setSrpCoefficient(double srpCoefficient) {
        this.refuseFurtherComments();
        this.srpCoefficient = srpCoefficient;
    }

    public double getSrpUncertainty() {
        return this.srpUncertainty;
    }

    public void setSrpUncertainty(double srpUncertainty) {
        this.refuseFurtherComments();
        this.srpUncertainty = srpUncertainty;
    }

    public String getAttitudeControlMode() {
        return this.attitudeControlMode;
    }

    public void setAttitudeControlMode(String attitudeControlMode) {
        this.refuseFurtherComments();
        this.attitudeControlMode = attitudeControlMode;
    }

    public String getAttitudeActuatorType() {
        return this.attitudeActuatorType;
    }

    public void setAttitudeActuatorType(String attitudeActuatorType) {
        this.refuseFurtherComments();
        this.attitudeActuatorType = attitudeActuatorType;
    }

    public double getAttitudeKnowledgeAccuracy() {
        return this.attitudeKnowledgeAccuracy;
    }

    public void setAttitudeKnowledgeAccuracy(double attitudeKnowledgeAccuracy) {
        this.refuseFurtherComments();
        this.attitudeKnowledgeAccuracy = attitudeKnowledgeAccuracy;
    }

    public double getAttitudeControlAccuracy() {
        return this.attitudeControlAccuracy;
    }

    public void setAttitudeControlAccuracy(double attitudeControlAccuracy) {
        this.refuseFurtherComments();
        this.attitudeControlAccuracy = attitudeControlAccuracy;
    }

    public double getAttitudePointingAccuracy() {
        return this.attitudePointingAccuracy;
    }

    public void setAttitudePointingAccuracy(double attitudePointingAccuracy) {
        this.refuseFurtherComments();
        this.attitudePointingAccuracy = attitudePointingAccuracy;
    }

    public double getManeuversPerYear() {
        return this.maneuversFrequency * 3.15576E7;
    }

    public double getManeuversFrequency() {
        return this.maneuversFrequency;
    }

    public void setManeuversFrequency(double maneuversFrequency) {
        this.refuseFurtherComments();
        this.maneuversFrequency = maneuversFrequency;
    }

    public double getMaxThrust() {
        return this.maxThrust;
    }

    public void setMaxThrust(double maxThrust) {
        this.refuseFurtherComments();
        this.maxThrust = maxThrust;
    }

    public double getBolDv() {
        return this.bolDv;
    }

    public void setBolDv(double bolDv) {
        this.refuseFurtherComments();
        this.bolDv = bolDv;
    }

    public double getRemainingDv() {
        return this.remainingDv;
    }

    public void setRemainingDv(double remainingDv) {
        this.refuseFurtherComments();
        this.remainingDv = remainingDv;
    }

    public RealMatrix getInertiaMatrix() {
        return this.inertiaMatrix;
    }

    public void setInertiaMatrixEntry(int j, int k, double entry) {
        this.refuseFurtherComments();
        this.inertiaMatrix.setEntry(j, k, entry);
        this.inertiaMatrix.setEntry(k, j, entry);
    }
}

