/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.definitions.DutyCycleType;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverFieldType;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuver;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuverHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuverHistoryMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class OrbitManeuverHistoryWriter
extends AbstractWriter {
    private final OrbitManeuverHistory history;
    private final TimeConverter timeConverter;

    OrbitManeuverHistoryWriter(OrbitManeuverHistory maneuverHistory, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.man.name(), OcmDataSubStructureKey.MAN.name());
        this.history = maneuverHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        OrbitManeuverHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_ID.name(), metadata.getManID(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_PREV_ID.name(), metadata.getManPrevID(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_NEXT_ID.name(), metadata.getManNextID(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_BASIS.name(), metadata.getManBasis(), false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_BASIS_ID.name(), metadata.getManBasisID(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_DEVICE_ID.name(), metadata.getManDeviceID(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_PREV_EPOCH.name(), this.timeConverter, metadata.getManPrevEpoch(), true, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_NEXT_EPOCH.name(), this.timeConverter, metadata.getManNextEpoch(), true, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_PURPOSE.name(), metadata.getManPurpose(), false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_PRED_SOURCE.name(), metadata.getManPredSource(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_REF_FRAME.name(), metadata.getManReferenceFrame().getName(), null, false);
        if (!metadata.getManFrameEpoch().equals(this.timeConverter.getReferenceDate()) && metadata.getManReferenceFrame().asOrbitRelativeFrame() == null && metadata.getManReferenceFrame().asSpacecraftBodyFrame() == null) {
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_FRAME_EPOCH.name(), this.timeConverter, metadata.getManFrameEpoch(), true, false);
        }
        if (metadata.getGravitationalAssist() != null) {
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.GRAV_ASSIST_NAME.name(), metadata.getGravitationalAssist().getName(), null, false);
        }
        boolean notContinuous = metadata.getDcType() != DutyCycleType.CONTINUOUS;
        boolean timeAndAngle = metadata.getDcType() == DutyCycleType.TIME_AND_ANGLE;
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_TYPE.name(), metadata.getDcType(), false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_WIN_OPEN.name(), this.timeConverter, metadata.getDcWindowOpen(), false, notContinuous);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_WIN_CLOSE.name(), this.timeConverter, metadata.getDcWindowClose(), false, notContinuous);
        if (metadata.getDcMinCycles() >= 0) {
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_MIN_CYCLES.name(), metadata.getDcMinCycles(), false);
        }
        if (metadata.getDcMaxCycles() >= 0) {
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_MAX_CYCLES.name(), metadata.getDcMaxCycles(), false);
        }
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_EXEC_START.name(), this.timeConverter, metadata.getDcExecStart(), false, notContinuous);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_EXEC_STOP.name(), this.timeConverter, metadata.getDcExecStop(), false, notContinuous);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_REF_TIME.name(), this.timeConverter, metadata.getDcRefTime(), false, notContinuous);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_TIME_PULSE_DURATION.name(), metadata.getDcTimePulseDuration(), Unit.SECOND, notContinuous);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_TIME_PULSE_PERIOD.name(), metadata.getDcTimePulsePeriod(), Unit.SECOND, notContinuous);
        if (timeAndAngle) {
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_REF_DIR.name(), this.toString(metadata.getDcRefDir()), null, timeAndAngle);
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_BODY_FRAME.name(), metadata.getDcBodyFrame().toString().replace(' ', '_'), null, timeAndAngle);
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_BODY_TRIGGER.name(), this.toString(metadata.getDcBodyTrigger()), null, timeAndAngle);
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_PA_START_ANGLE.name(), metadata.getDcPhaseStartAngle(), Unit.DEGREE, timeAndAngle);
            generator.writeEntry(OrbitManeuverHistoryMetadataKey.DC_PA_STOP_ANGLE.name(), metadata.getDcPhaseStopAngle(), Unit.DEGREE, timeAndAngle);
        }
        List<ManeuverFieldType> types = metadata.getManComposition();
        StringBuilder composition = new StringBuilder();
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                composition.append(',');
            }
            composition.append(types.get(i).name());
        }
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_COMPOSITION.name(), composition.toString(), null, false);
        generator.writeEntry(OrbitManeuverHistoryMetadataKey.MAN_UNITS.name(), generator.unitsListToString(metadata.getManUnits()), null, false);
        for (OrbitManeuver maneuver : this.history.getManeuvers()) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < types.size(); ++i) {
                if (i > 0) {
                    line.append(' ');
                }
                line.append(types.get(i).outputField(this.timeConverter, maneuver));
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("manLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }

    private String toString(Vector3D vector) {
        StringBuilder builder = new StringBuilder();
        builder.append(AccurateFormatter.format(Unit.ONE.fromSI(vector.getX())));
        builder.append(' ');
        builder.append(AccurateFormatter.format(Unit.ONE.fromSI(vector.getY())));
        builder.append(' ');
        builder.append(AccurateFormatter.format(Unit.ONE.fromSI(vector.getZ())));
        return builder.toString();
    }
}

