/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.units.Unit;

public enum OrbitElementsType {
    ADBARV("Spherical 6-element set (\u03b1,\u03b4,\u03b2,A,r,v)", "\u00b0", "\u00b0", "\u00b0", "\u00b0", "km", "km/s"),
    CARTP("Cartesian 3-element position (X, Y, Z)", new String[]{"km", "km", "km"}){

        @Override
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            return new TimeStampedPVCoordinates(date, new Vector3D(elements[0], elements[1], elements[2]), Vector3D.ZERO, Vector3D.ZERO);
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            return new double[]{pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ()};
        }
    }
    ,
    CARTPV("Cartesian 6-element position and velocity (X, Y, Z, XD, YD, ZD)", new String[]{"km", "km", "km", "km/s", "km/s", "km/s"}){

        @Override
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            return new TimeStampedPVCoordinates(date, new Vector3D(elements[0], elements[1], elements[2]), new Vector3D(elements[3], elements[4], elements[5]), Vector3D.ZERO);
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            return new double[]{pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ()};
        }
    }
    ,
    CARTPVA("Cartesian 9-element position, velocity and acceleration (X, Y, Z, XD, YD, ZD, XDD, YDD, ZDD)", new String[]{"km", "km", "km", "km/s", "km/s", "km/s", "km/s\u00b2", "km/s\u00b2", "km/s\u00b2"}){

        @Override
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            return new TimeStampedPVCoordinates(date, new Vector3D(elements[0], elements[1], elements[2]), new Vector3D(elements[3], elements[4], elements[5]), new Vector3D(elements[6], elements[7], elements[8]));
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            return new double[]{pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()};
        }
    }
    ,
    DELAUNAY("Delaunay elements (L, G, H, l, g, h)", "km\u00b2/s", "km\u00b2/s", "km\u00b2/s", "\u00b0", "\u00b0", "\u00b0"),
    DELAUNAYMOD("Delaunay elements (Lm, Gm, Hm, lm, gm, hm)", "\u221akm", "\u221akm", "\u221akm", "\u00b0", "\u00b0", "\u00b0"),
    EIGVAL3EIGVEC3("12 elements eigenvalue/eigenvectors (EigMaj, EigMed, EigMin, EigVecMaj, EigVecMed, EigVecMin)", "km", "km", "km", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a", "n/a"),
    EQUINOCTIAL("Equinoctial elements (a, af, ag, L=M+\u03c9+fr\u03a9, \u03c7, \u03c8, fr)", new String[]{"km", "n/a", "n/a", "\u00b0", "n/a", "n/a", "n/a"}){

        @Override
        @DefaultDataContext
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            if (elements[6] < 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNSUPPORTED_RETROGRADE_EQUINOCTIAL, EQUINOCTIAL.name());
            }
            return new EquinoctialOrbit(elements[0], elements[1], elements[2], elements[5], elements[4], elements[3], PositionAngleType.MEAN, FramesFactory.getGCRF(), date, mu).getPVCoordinates();
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            EquinoctialOrbit orbit = new EquinoctialOrbit(pv, frame, mu);
            return new double[]{orbit.getA(), orbit.getEquinoctialEx(), orbit.getEquinoctialEy(), orbit.getLM(), orbit.getHy(), orbit.getHx(), 1.0};
        }
    }
    ,
    EQUINOCTIALMOD("Modified equinoctial elements (p=a(1\u2212e\u00b2), af, ag, L'=\u03c5+\u03c9+fr\u03a9, \u03c7, \u03c8, fr)", new String[]{"km", "n/a", "n/a", "\u00b0", "n/a", "n/a", "n/a"}){

        @Override
        @DefaultDataContext
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            if (elements[6] < 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNSUPPORTED_RETROGRADE_EQUINOCTIAL, EQUINOCTIALMOD.name());
            }
            double oMe2 = 1.0 - (elements[1] * elements[1] + elements[2] * elements[2]);
            return new EquinoctialOrbit(elements[0] / oMe2, elements[1], elements[2], elements[5], elements[4], elements[3], PositionAngleType.TRUE, FramesFactory.getGCRF(), date, mu).getPVCoordinates();
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            EquinoctialOrbit orbit = new EquinoctialOrbit(pv, frame, mu);
            double ex = orbit.getEquinoctialEx();
            double ey = orbit.getEquinoctialEy();
            return new double[]{orbit.getA() * (1.0 - (ex * ex + ey * ey)), ex, ey, orbit.getLv(), orbit.getHy(), orbit.getHx(), 1.0};
        }
    }
    ,
    GEODETIC("Geodetic elements (\u03bb, \u03a6GD, \u03b2, A, h, vre)", new String[]{"\u00b0", "\u00b0", "\u00b0", "\u00b0", "km", "km/s"}){

        @Override
        @DefaultDataContext
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            GeodeticPoint gp = new GeodeticPoint(elements[1], elements[0], elements[4]);
            Vector3D position = body.transform(gp);
            SinCos scBeta = FastMath.sinCos((double)elements[2]);
            SinCos scAzi = FastMath.sinCos((double)elements[3]);
            Vector3D velocity = new Vector3D(elements[5] * scBeta.cos() * scAzi.sin(), gp.getEast(), elements[5] * scBeta.cos() * scAzi.cos(), gp.getNorth(), elements[5] * scBeta.sin(), gp.getZenith());
            return new TimeStampedPVCoordinates(date, position, velocity);
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            GeodeticPoint gp = body.transform(pv.getPosition(), frame, pv.getDate());
            return new double[]{gp.getLongitude(), gp.getLatitude(), 1.5707963267948966 - Vector3D.angle((Vector3D)pv.getVelocity(), (Vector3D)gp.getZenith()), FastMath.atan2((double)Vector3D.dotProduct((Vector3D)pv.getVelocity(), (Vector3D)gp.getEast()), (double)Vector3D.dotProduct((Vector3D)pv.getVelocity(), (Vector3D)gp.getNorth())), gp.getAltitude(), pv.getVelocity().getNorm()};
        }
    }
    ,
    KEPLERIAN("Keplerian 6-elemnt classical set (a, e, i, \u03a9, \u03c9, \u03bd)", new String[]{"km", "n/a", "\u00b0", "\u00b0", "\u00b0", "\u00b0"}){

        @Override
        @DefaultDataContext
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            return new KeplerianOrbit(elements[0], elements[1], elements[2], elements[4], elements[3], elements[5], PositionAngleType.TRUE, FramesFactory.getGCRF(), date, mu).getPVCoordinates();
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            KeplerianOrbit orbit = new KeplerianOrbit(pv, frame, mu);
            return new double[]{orbit.getA(), orbit.getE(), orbit.getI(), orbit.getRightAscensionOfAscendingNode(), orbit.getPerigeeArgument(), orbit.getTrueAnomaly()};
        }
    }
    ,
    KEPLERIANMEAN("Keplerian 6-elemnt classical set (a, e, i, \u03a9, \u03c9, M)", new String[]{"km", "n/a", "\u00b0", "\u00b0", "\u00b0", "\u00b0"}){

        @Override
        @DefaultDataContext
        public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
            return new KeplerianOrbit(elements[0], elements[1], elements[2], elements[4], elements[3], elements[5], PositionAngleType.MEAN, FramesFactory.getGCRF(), date, mu).getPVCoordinates();
        }

        @Override
        public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
            KeplerianOrbit orbit = new KeplerianOrbit(pv, frame, mu);
            return new double[]{orbit.getA(), orbit.getE(), orbit.getI(), orbit.getRightAscensionOfAscendingNode(), orbit.getPerigeeArgument(), orbit.getMeanAnomaly()};
        }
    }
    ,
    LDBARV("Modified spherical 6-element set (\u03bb, \u03b4, \u03b2, A, r, v)", "\u00b0", "\u00b0", "\u00b0", "\u00b0", "km", "km/s"),
    ONSTATION("Geosynchronous on-station tailored set (a, ex, ey, ix, iy, \u03bb)", "km", "n/a", "n/a", "n/a", "n/a", "\u00b0"),
    POINCARE("Canonical counterpart of equinoctial 6-element set (\u03bbM=M+\u03c9+\u03a9, gp, hp, Lp, Gp, Hp)", "\u00b0", "km/\u221as", "km/\u221as", "km\u00b2/s", "km/\u221as", "km/\u221as");

    private final String description;
    private final List<Unit> units;

    private OrbitElementsType(String description, String ... unitsSpecifications) {
        this.description = description;
        this.units = Stream.of(unitsSpecifications).map(s -> Unit.parse(s)).collect(Collectors.toList());
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    public TimeStampedPVCoordinates toCartesian(AbsoluteDate date, double[] elements, OneAxisEllipsoid body, double mu) {
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNSUPPORTED_ELEMENT_SET_TYPE, this.name(), this.toString());
    }

    public double[] toRawElements(TimeStampedPVCoordinates pv, Frame frame, OneAxisEllipsoid body, double mu) {
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNSUPPORTED_ELEMENT_SET_TYPE, this.name(), this.toString());
    }

    public String toString() {
        return this.description;
    }
}

