/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import org.orekit.files.ccsds.definitions.OdMethodFacade;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDetermination;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum OrbitDeterminationKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    OD_ID((token, context, container) -> token.processAsFreeTextString(container::setId)),
    OD_PREV_ID((token, context, container) -> token.processAsFreeTextString(container::setPrevId)),
    OD_METHOD((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.setMethod(OdMethodFacade.parse(token.getRawContent()));
        }
        return true;
    }),
    OD_EPOCH((token, context, container) -> token.processAsDate(container::setEpoch, context)),
    DAYS_SINCE_FIRST_OBS((token, context, container) -> token.processAsDouble(Unit.DAY, context.getParsedUnitsBehavior(), container::setTimeSinceFirstObservation)),
    DAYS_SINCE_LAST_OBS((token, context, container) -> token.processAsDouble(Unit.DAY, context.getParsedUnitsBehavior(), container::setTimeSinceLastObservation)),
    RECOMMENDED_OD_SPAN((token, context, container) -> token.processAsDouble(Unit.DAY, context.getParsedUnitsBehavior(), container::setRecommendedOdSpan)),
    ACTUAL_OD_SPAN((token, context, container) -> token.processAsDouble(Unit.DAY, context.getParsedUnitsBehavior(), container::setActualOdSpan)),
    OBS_AVAILABLE((token, context, container) -> token.processAsInteger(container::setObsAvailable)),
    OBS_USED((token, context, container) -> token.processAsInteger(container::setObsUsed)),
    TRACKS_AVAILABLE((token, context, container) -> token.processAsInteger(container::setTracksAvailable)),
    TRACKS_USED((token, context, container) -> token.processAsInteger(container::setTracksUsed)),
    MAXIMUM_OBS_GAP((token, context, container) -> token.processAsDouble(Unit.DAY, context.getParsedUnitsBehavior(), container::setMaximumObsGap)),
    OD_EPOCH_EIGMAJ((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setEpochEigenMaj)),
    OD_EPOCH_EIGINT((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setEpochEigenInt)),
    OD_EPOCH_EIGMIN((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setEpochEigenMin)),
    OD_MAX_PRED_EIGMAJ((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setMaxPredictedEigenMaj)),
    OD_MIN_PRED_EIGMIN((token, context, container) -> token.processAsDouble(Unit.METRE, context.getParsedUnitsBehavior(), container::setMinPredictedEigenMin)),
    OD_CONFIDENCE((token, context, container) -> token.processAsDouble(Unit.PERCENT, context.getParsedUnitsBehavior(), container::setConfidence)),
    GDOP((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setGdop)),
    SOLVE_N((token, context, container) -> token.processAsInteger(container::setSolveN)),
    SOLVE_STATES((token, context, container) -> token.processAsFreeTextList(container::setSolveStates)),
    CONSIDER_N((token, context, container) -> token.processAsInteger(container::setConsiderN)),
    CONSIDER_PARAMS((token, context, container) -> token.processAsFreeTextList(container::setConsiderParameters)),
    SEDR((token, context, container) -> token.processAsDouble(Units.W_PER_KG, context.getParsedUnitsBehavior(), container::setSedr)),
    SENSORS_N((token, context, container) -> token.processAsInteger(container::setSensorsN)),
    SENSORS((token, context, container) -> token.processAsFreeTextList(container::setSensors)),
    WEIGHTED_RMS((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setWeightedRms)),
    DATA_TYPES((token, context, container) -> token.processAsFreeTextList(container::setDataTypes));

    private final transient TokenProcessor processor;

    private OrbitDeterminationKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, OrbitDetermination container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, OrbitDetermination var3);
    }
}

