/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.List;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceIndexer;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovariance;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovarianceHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovarianceHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.Ordering;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class OrbitCovarianceHistoryWriter
extends AbstractWriter {
    private final OrbitCovarianceHistory history;
    private final TimeConverter timeConverter;

    OrbitCovarianceHistoryWriter(OrbitCovarianceHistory covarianceHistory, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.cov.name(), OcmDataSubStructureKey.COV.name());
        this.history = covarianceHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        OrbitCovarianceHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_ID.name(), metadata.getCovID(), null, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_PREV_ID.name(), metadata.getCovPrevID(), null, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_NEXT_ID.name(), metadata.getCovNextID(), null, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_BASIS.name(), metadata.getCovBasis(), null, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_BASIS_ID.name(), metadata.getCovBasisID(), null, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_REF_FRAME.name(), metadata.getCovReferenceFrame().getName(), null, false);
        if (!metadata.getCovFrameEpoch().equals(this.timeConverter.getReferenceDate()) && metadata.getCovReferenceFrame().asOrbitRelativeFrame() == null && metadata.getCovReferenceFrame().asSpacecraftBodyFrame() == null) {
            generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_FRAME_EPOCH.name(), this.timeConverter, metadata.getCovFrameEpoch(), true, false);
        }
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_SCALE_MIN.name(), metadata.getCovScaleMin(), Unit.ONE, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_SCALE_MAX.name(), metadata.getCovScaleMax(), Unit.ONE, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_CONFIDENCE.name(), metadata.getCovConfidence(), Unit.PERCENT, false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_TYPE.name(), metadata.getCovType(), false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_ORDERING.name(), metadata.getCovOrdering(), false);
        generator.writeEntry(OrbitCovarianceHistoryMetadataKey.COV_UNITS.name(), generator.unitsListToString(metadata.getCovUnits()), null, false);
        List<Unit> units = metadata.getCovType().getUnits();
        for (OrbitCovariance covariance : this.history.getCovariances()) {
            RealMatrix matrix = covariance.getMatrix();
            Ordering ordering = metadata.getCovOrdering();
            CovarianceIndexer indexer = new CovarianceIndexer(units.size());
            StringBuilder line = new StringBuilder();
            line.append(generator.dateToString(this.timeConverter, covariance.getDate()));
            for (int k = 0; k < ordering.nbElements(units.size()); ++k) {
                int i = indexer.getRow();
                int j = indexer.getColumn();
                double cij = indexer.isCrossCorrelation() ? matrix.getEntry(i, j) / FastMath.sqrt((double)(matrix.getEntry(i, i) * matrix.getEntry(j, j))) : units.get(i).fromSI(units.get(j).fromSI(matrix.getEntry(i, j)));
                line.append(' ');
                line.append(AccurateFormatter.format(cij));
                ordering.update(indexer);
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("covLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }
}

