/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceIndexer;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitElementsType;
import org.orekit.files.ccsds.ndm.odm.ocm.Ordering;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.units.Unit;

public class OrbitCovariance
implements TimeStamped {
    private final OrbitElementsType type;
    private final AbsoluteDate date;
    private final RealMatrix matrix;

    public OrbitCovariance(OrbitElementsType type, Ordering ordering, AbsoluteDate date, String[] fields, int first) {
        List<Unit> units = type.getUnits();
        this.type = type;
        this.date = date;
        this.matrix = MatrixUtils.createRealMatrix((int)units.size(), (int)units.size());
        CovarianceIndexer indexer = new CovarianceIndexer(units.size());
        int k = 0;
        while (first + k < fields.length) {
            if (!indexer.isCrossCorrelation()) {
                int i = indexer.getRow();
                int j = indexer.getColumn();
                double raw = Double.parseDouble(fields[first + k]);
                double converted = units.get(i).toSI(units.get(j).toSI(raw));
                this.matrix.setEntry(i, j, converted);
                if (i != j) {
                    this.matrix.setEntry(j, i, converted);
                }
            }
            ordering.update(indexer);
            ++k;
        }
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public RealMatrix getMatrix() {
        return this.matrix;
    }

    public OrbitElementsType getType() {
        return this.type;
    }
}

