/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.OdmHeader;
import org.orekit.files.ccsds.ndm.odm.UserDefinedWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.Ocm;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmData;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadataWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovarianceHistoryWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDeterminationWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuverHistoryWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitPhysicalPropertiesWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.PerturbationsWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryWriter;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.IERSConventions;

public class OcmWriter
extends AbstractMessageWriter<OdmHeader, Segment<OcmMetadata, OcmData>, Ocm> {
    public static final double CCSDS_OCM_VERS = 3.0;
    public static final int KVN_PADDING_WIDTH = 24;
    private final double equatorialRadius;
    private final double flattening;

    public OcmWriter(IERSConventions conventions, double equatorialRadius, double flattening, DataContext dataContext) {
        super("ocm", "CCSDS_OCM_VERS", 3.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> null, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
        this.equatorialRadius = equatorialRadius;
        this.flattening = flattening;
    }

    public double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    public double getFlattening() {
        return this.flattening;
    }

    @Override
    protected void writeSegmentContent(Generator generator, double formatVersion, Segment<OcmMetadata, OcmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        OcmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, metadata::getEpochT0, metadata::getTimeSystem, metadata::getSclkOffsetAtEpoch, metadata::getSclkSecPerSISec));
        new OcmMetadataWriter(metadata, this.getTimeConverter()).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        if (segment.getData().getTrajectoryBlocks() != null && !segment.getData().getTrajectoryBlocks().isEmpty()) {
            for (TrajectoryStateHistory trajectoryStateHistory : segment.getData().getTrajectoryBlocks()) {
                new TrajectoryStateHistoryWriter(trajectoryStateHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getPhysicBlock() != null) {
            new OrbitPhysicalPropertiesWriter(segment.getData().getPhysicBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getCovarianceBlocks() != null && !segment.getData().getCovarianceBlocks().isEmpty()) {
            for (OrbitCovarianceHistory orbitCovarianceHistory : segment.getData().getCovarianceBlocks()) {
                new OrbitCovarianceHistoryWriter(orbitCovarianceHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getManeuverBlocks() != null && !segment.getData().getManeuverBlocks().isEmpty()) {
            for (OrbitManeuverHistory orbitManeuverHistory : segment.getData().getManeuverBlocks()) {
                new OrbitManeuverHistoryWriter(orbitManeuverHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getPerturbationsBlock() != null) {
            new PerturbationsWriter(segment.getData().getPerturbationsBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getOrbitDeterminationBlock() != null) {
            new OrbitDeterminationWriter(segment.getData().getOrbitDeterminationBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getUserDefinedBlock() != null) {
            new UserDefinedWriter(OcmDataSubStructureKey.user.name(), OcmDataSubStructureKey.USER.name(), segment.getData().getUserDefinedBlock()).write(generator);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

