/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.stream.Collectors;
import org.hipparchus.util.Precision;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadataKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class OcmMetadataWriter
extends AbstractWriter {
    private final OcmMetadata metadata;
    private final TimeConverter timeConverter;

    OcmMetadataWriter(OcmMetadata metadata, TimeConverter timeConverter) {
        super(XmlStructureKey.metadata.name(), KvnStructureKey.META.name());
        this.metadata = metadata;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.metadata.getComments());
        generator.writeEntry(OdmMetadataKey.OBJECT_NAME.name(), this.metadata.getObjectName(), null, false);
        generator.writeEntry(OcmMetadataKey.INTERNATIONAL_DESIGNATOR.name(), this.metadata.getInternationalDesignator(), null, false);
        generator.writeEntry(OcmMetadataKey.CATALOG_NAME.name(), this.metadata.getCatalogName(), null, false);
        generator.writeEntry(OcmMetadataKey.OBJECT_DESIGNATOR.name(), this.metadata.getObjectDesignator(), null, false);
        generator.writeEntry(OcmMetadataKey.ALTERNATE_NAMES.name(), this.metadata.getAlternateNames(), false);
        generator.writeEntry(OcmMetadataKey.ORIGINATOR_POC.name(), this.metadata.getOriginatorPOC(), null, false);
        generator.writeEntry(OcmMetadataKey.ORIGINATOR_POSITION.name(), this.metadata.getOriginatorPosition(), null, false);
        generator.writeEntry(OcmMetadataKey.ORIGINATOR_PHONE.name(), this.metadata.getOriginatorPhone(), null, false);
        generator.writeEntry(OcmMetadataKey.ORIGINATOR_EMAIL.name(), this.metadata.getOriginatorEmail(), null, false);
        generator.writeEntry(OcmMetadataKey.ORIGINATOR_ADDRESS.name(), this.metadata.getOriginatorAddress(), null, false);
        generator.writeEntry(OcmMetadataKey.TECH_ORG.name(), this.metadata.getTechOrg(), null, false);
        generator.writeEntry(OcmMetadataKey.TECH_POC.name(), this.metadata.getTechPOC(), null, false);
        generator.writeEntry(OcmMetadataKey.TECH_POSITION.name(), this.metadata.getTechPosition(), null, false);
        generator.writeEntry(OcmMetadataKey.TECH_PHONE.name(), this.metadata.getTechPhone(), null, false);
        generator.writeEntry(OcmMetadataKey.TECH_EMAIL.name(), this.metadata.getTechEmail(), null, false);
        generator.writeEntry(OcmMetadataKey.TECH_ADDRESS.name(), this.metadata.getTechAddress(), null, false);
        generator.writeEntry(OcmMetadataKey.PREVIOUS_MESSAGE_ID.name(), this.metadata.getPreviousMessageID(), null, false);
        generator.writeEntry(OcmMetadataKey.NEXT_MESSAGE_ID.name(), this.metadata.getNextMessageID(), null, false);
        generator.writeEntry(OcmMetadataKey.ADM_MSG_LINK.name(), this.metadata.getAdmMessageLink(), null, false);
        generator.writeEntry(OcmMetadataKey.CDM_MSG_LINK.name(), this.metadata.getCdmMessageLink(), null, false);
        generator.writeEntry(OcmMetadataKey.PRM_MSG_LINK.name(), this.metadata.getPrmMessageLink(), null, false);
        generator.writeEntry(OcmMetadataKey.RDM_MSG_LINK.name(), this.metadata.getRdmMessageLink(), null, false);
        generator.writeEntry(OcmMetadataKey.TDM_MSG_LINK.name(), this.metadata.getTdmMessageLink(), null, false);
        generator.writeEntry(OcmMetadataKey.OPERATOR.name(), this.metadata.getOperator(), null, false);
        generator.writeEntry(OcmMetadataKey.OWNER.name(), this.metadata.getOwner(), null, false);
        generator.writeEntry(OcmMetadataKey.COUNTRY.name(), this.metadata.getCountry(), null, false);
        generator.writeEntry(OcmMetadataKey.CONSTELLATION.name(), this.metadata.getConstellation(), null, false);
        generator.writeEntry(OcmMetadataKey.OBJECT_TYPE.name(), this.metadata.getObjectType(), false);
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), this.metadata.getTimeSystem(), false);
        generator.writeEntry(OcmMetadataKey.EPOCH_TZERO.name(), this.timeConverter, this.metadata.getEpochT0(), true, true);
        generator.writeEntry(OcmMetadataKey.OPS_STATUS.name(), this.metadata.getOpsStatus(), false);
        generator.writeEntry(OcmMetadataKey.ORBIT_CATEGORY.name(), this.metadata.getOrbitCategory(), false);
        if (this.metadata.getOcmDataElements() != null) {
            generator.writeEntry(OcmMetadataKey.OCM_DATA_ELEMENTS.name(), this.metadata.getOcmDataElements().stream().map(e -> e.name()).collect(Collectors.toList()), false);
        }
        if (!Precision.equals((double)this.metadata.getSclkOffsetAtEpoch(), (double)0.0) || !Precision.equals((double)this.metadata.getSclkSecPerSISec(), (double)1.0)) {
            generator.writeEntry(OcmMetadataKey.SCLK_OFFSET_AT_EPOCH.name(), this.metadata.getSclkOffsetAtEpoch(), Unit.SECOND, false);
            generator.writeEntry(OcmMetadataKey.SCLK_SEC_PER_SI_SEC.name(), this.metadata.getSclkSecPerSISec(), Unit.SECOND, false);
        }
        generator.writeEntry(OcmMetadataKey.PREVIOUS_MESSAGE_EPOCH.name(), this.timeConverter, this.metadata.getPreviousMessageEpoch(), true, false);
        generator.writeEntry(OcmMetadataKey.NEXT_MESSAGE_EPOCH.name(), this.timeConverter, this.metadata.getNextMessageEpoch(), true, false);
        generator.writeEntry(OcmMetadataKey.START_TIME.name(), this.timeConverter, this.metadata.getStartTime(), false, false);
        generator.writeEntry(OcmMetadataKey.STOP_TIME.name(), this.timeConverter, this.metadata.getStopTime(), false, false);
        generator.writeEntry(OcmMetadataKey.TIME_SPAN.name(), this.metadata.getTimeSpan(), Unit.DAY, false);
        generator.writeEntry(OcmMetadataKey.TAIMUTC_AT_TZERO.name(), this.metadata.getTaimutcT0(), Unit.SECOND, false);
        if (this.metadata.getNextLeapEpoch() != null) {
            generator.writeEntry(OcmMetadataKey.NEXT_LEAP_EPOCH.name(), this.timeConverter, this.metadata.getNextLeapEpoch(), true, true);
            generator.writeEntry(OcmMetadataKey.NEXT_LEAP_TAIMUTC.name(), this.metadata.getNextLeapTaimutc(), Unit.SECOND, true);
        }
        generator.writeEntry(OcmMetadataKey.UT1MUTC_AT_TZERO.name(), this.metadata.getUt1mutcT0(), Unit.SECOND, false);
        generator.writeEntry(OcmMetadataKey.EOP_SOURCE.name(), this.metadata.getEopSource(), null, false);
        generator.writeEntry(OcmMetadataKey.INTERP_METHOD_EOP.name(), this.metadata.getInterpMethodEOP(), null, false);
        generator.writeEntry(OcmMetadataKey.CELESTIAL_SOURCE.name(), this.metadata.getCelestialSource(), null, false);
    }
}

