/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDetermination;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitPhysicalProperties;
import org.orekit.files.ccsds.ndm.odm.ocm.Perturbations;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.section.Data;

public class OcmData
implements Data {
    private final List<TrajectoryStateHistory> trajectoryBlocks;
    private final OrbitPhysicalProperties physicBlock;
    private final List<OrbitCovarianceHistory> covarianceBlocks;
    private final List<OrbitManeuverHistory> maneuverBlocks;
    private final Perturbations perturbationsBlock;
    private final OrbitDetermination orbitDeterminationBlock;
    private final UserDefined userDefinedBlock;

    public OcmData(List<TrajectoryStateHistory> trajectoryBlocks, OrbitPhysicalProperties physicBlock, List<OrbitCovarianceHistory> covarianceBlocks, List<OrbitManeuverHistory> maneuverBlocks, Perturbations perturbationsBlock, OrbitDetermination orbitDeterminationBlock, UserDefined userDefinedBlock) {
        this.trajectoryBlocks = trajectoryBlocks;
        this.physicBlock = physicBlock;
        this.covarianceBlocks = covarianceBlocks;
        this.maneuverBlocks = maneuverBlocks;
        this.perturbationsBlock = perturbationsBlock;
        this.orbitDeterminationBlock = orbitDeterminationBlock;
        this.userDefinedBlock = userDefinedBlock;
    }

    @Override
    public void validate(double version) {
        if (this.trajectoryBlocks != null) {
            for (TrajectoryStateHistory osh : this.trajectoryBlocks) {
                osh.getMetadata().validate(version);
            }
        }
        if (this.physicBlock != null) {
            this.physicBlock.validate(version);
        }
        if (this.covarianceBlocks != null) {
            for (OrbitCovarianceHistory ch : this.covarianceBlocks) {
                ch.getMetadata().validate(version);
            }
        }
        if (this.maneuverBlocks != null) {
            for (OrbitManeuverHistory mh : this.maneuverBlocks) {
                mh.getMetadata().validate(version);
            }
        }
        if (this.perturbationsBlock != null) {
            this.perturbationsBlock.validate(version);
        }
        if (this.orbitDeterminationBlock != null) {
            this.orbitDeterminationBlock.validate(version);
        }
        if (this.userDefinedBlock != null) {
            this.userDefinedBlock.validate(version);
        }
    }

    public List<TrajectoryStateHistory> getTrajectoryBlocks() {
        return this.trajectoryBlocks;
    }

    public OrbitPhysicalProperties getPhysicBlock() {
        return this.physicBlock;
    }

    public List<OrbitCovarianceHistory> getCovarianceBlocks() {
        return this.covarianceBlocks;
    }

    public List<OrbitManeuverHistory> getManeuverBlocks() {
        return this.maneuverBlocks;
    }

    public Perturbations getPerturbationsBlock() {
        return this.perturbationsBlock;
    }

    public OrbitDetermination getOrbitDeterminationBlock() {
        return this.orbitDeterminationBlock;
    }

    public UserDefined getUserDefinedBlock() {
        return this.userDefinedBlock;
    }
}

